/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state.utils;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateVariableType$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.state.ReadStateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import scala.;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class SchemaUtil$ {
    public static final SchemaUtil$ MODULE$ = new SchemaUtil$();

    public DataType getSchemaAsDataType(StructType schema, String fieldName) {
        Option option = schema.getFieldIndex(fieldName);
        if (option instanceof Some) {
            Some some = (Some)option;
            int idx = BoxesRunTime.unboxToInt((Object)some.value());
            return schema.apply(idx).dataType();
        }
        throw new AnalysisException("_LEGACY_ERROR_TEMP_3074", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)fieldName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema.toString())})));
    }

    public StructType getSourceSchema(StateSourceOptions sourceOptions, StructType keySchema, StructType valueSchema, Option<TransformWithStateVariableInfo> transformWithStateVariableInfoOpt, Option<StateStoreColFamilySchema> stateStoreColFamilySchemaOpt) {
        if (transformWithStateVariableInfoOpt.isDefined()) {
            Predef$.MODULE$.require(stateStoreColFamilySchemaOpt.isDefined());
            return this.generateSchemaForStateVar((TransformWithStateVariableInfo)transformWithStateVariableInfoOpt.get(), (StateStoreColFamilySchema)stateStoreColFamilySchemaOpt.get(), sourceOptions);
        }
        if (sourceOptions.readChangeFeed()) {
            return new StructType().add("batch_id", (DataType)LongType$.MODULE$).add("change_type", (DataType)StringType$.MODULE$).add("key", (DataType)keySchema).add("value", (DataType)valueSchema).add("partition_id", (DataType)IntegerType$.MODULE$);
        }
        if (sourceOptions.internalOnlyReadAllColumnFamilies()) {
            return new StructType().add("partition_key", (DataType)keySchema).add("key_bytes", (DataType)BinaryType$.MODULE$).add("value_bytes", (DataType)BinaryType$.MODULE$).add("column_family_name", (DataType)StringType$.MODULE$);
        }
        return new StructType().add("key", (DataType)keySchema).add("value", (DataType)valueSchema).add("partition_id", (DataType)IntegerType$.MODULE$);
    }

    public InternalRow unifyStateRowPair(Tuple2<UnsafeRow, UnsafeRow> pair, int partition) {
        GenericInternalRow row = new GenericInternalRow(3);
        row.update(0, pair._1());
        row.update(1, pair._2());
        row.update(2, (Object)BoxesRunTime.boxToInteger((int)partition));
        return row;
    }

    public InternalRow unifyStateRowPairAsRawBytes(Tuple2<UnsafeRow, UnsafeRow> pair, String colFamilyName) {
        GenericInternalRow row = new GenericInternalRow(4);
        row.update(0, pair._1());
        row.update(1, (Object)((UnsafeRow)pair._1()).getBytes());
        row.update(2, (Object)((UnsafeRow)pair._2()).getBytes());
        row.update(3, (Object)UTF8String.fromString((String)colFamilyName));
        return row;
    }

    public InternalRow unifyStateRowPairWithMultipleValues(Tuple2<UnsafeRow, GenericArrayData> pair, int partition) {
        GenericInternalRow row = new GenericInternalRow(3);
        row.update(0, pair._1());
        row.update(1, pair._2());
        row.update(2, (Object)BoxesRunTime.boxToInteger((int)partition));
        return row;
    }

    public Iterator<InternalRow> unifyMapStateRowPair(Iterator<UnsafeRowPair> stateRows, StructType compositeKeySchema, int partitionId, StateSourceOptions stateSourceOptions) {
        StructType groupingKeySchema = (StructType)this.getSchemaAsDataType(compositeKeySchema, "key");
        StructType userKeySchema = (StructType)this.getSchemaAsDataType(compositeKeySchema, "userKey");
        if (stateSourceOptions.flattenCollectionTypes()) {
            return stateRows.map((Function1 & Serializable)pair -> {
                UnsafeRow groupingKey = (UnsafeRow)pair.key().get(0, (DataType)groupingKeySchema);
                UnsafeRow userMapKey = (UnsafeRow)pair.key().get(1, (DataType)userKeySchema);
                UnsafeRow userMapValue = pair.value();
                return SchemaUtil$.createFlattenedRow$1(groupingKey, userMapKey, userMapValue, partitionId);
            });
        }
        return new Iterator<InternalRow>(stateRows, groupingKeySchema, userKeySchema, partitionId){
            private UnsafeRow curGroupingKey;
            private UnsafeRowPair curStateRowPair;
            private final scala.collection.mutable.Map<Object, Object> curMap;
            private final Iterator stateRows$1;
            private final StructType groupingKeySchema$1;
            private final StructType userKeySchema$1;
            private final int partitionId$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<InternalRow> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<InternalRow> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<InternalRow> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<InternalRow, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<InternalRow> filterImpl(Function1<InternalRow, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<InternalRow> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<InternalRow> distinctBy(Function1<InternalRow, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<InternalRow, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<InternalRow, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<InternalRow, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<InternalRow> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<InternalRow> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<InternalRow> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<InternalRow> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<InternalRow, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U$> Iterator<InternalRow> tapEach(Function1<InternalRow, U$> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<InternalRow> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U$> void foreach(Function1<InternalRow, U$> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<InternalRow, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<InternalRow, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<InternalRow, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<InternalRow> find(Function1<InternalRow, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<InternalRow, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object dest) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest);
            }

            public <B> int copyToArray(Object dest, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start);
            }

            public <B> int copyToArray(Object dest, int start, int n) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start, (int)n);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<InternalRow> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<InternalRow> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<InternalRow> maxByOption(Function1<InternalRow, B> f, Ordering<B> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<InternalRow> minByOption(Function1<InternalRow, B> f, Ordering<B> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<InternalRow, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<InternalRow, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<InternalRow> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<InternalRow> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<InternalRow> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<InternalRow, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<InternalRow> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<InternalRow> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<InternalRow> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<InternalRow> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S$ extends Stepper<?>> S$ stepper(StepperShape<InternalRow, S$> shape) {
                return (S$)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private UnsafeRow curGroupingKey() {
                return this.curGroupingKey;
            }

            private void curGroupingKey_$eq(UnsafeRow x$1) {
                this.curGroupingKey = x$1;
            }

            private UnsafeRowPair curStateRowPair() {
                return this.curStateRowPair;
            }

            private void curStateRowPair_$eq(UnsafeRowPair x$1) {
                this.curStateRowPair = x$1;
            }

            private scala.collection.mutable.Map<Object, Object> curMap() {
                return this.curMap;
            }

            public boolean hasNext() {
                return this.stateRows$1.hasNext() || !this.curMap().isEmpty();
            }

            public InternalRow next() {
                boolean foundNewGroupingKey = false;
                while (this.stateRows$1.hasNext() && !foundNewGroupingKey) {
                    Object curPairGroupingKey;
                    this.curStateRowPair_$eq((UnsafeRowPair)this.stateRows$1.next());
                    if (this.curGroupingKey() == null) {
                        this.curGroupingKey_$eq(((UnsafeRow)this.curStateRowPair().key().get(0, (DataType)this.groupingKeySchema$1)).copy());
                        SchemaUtil$.org$apache$spark$sql$execution$datasources$v2$state$utils$SchemaUtil$$appendKVPairToMap$1(this.curMap(), this.curStateRowPair(), this.userKeySchema$1);
                        continue;
                    }
                    Object object = curPairGroupingKey = this.curStateRowPair().key().get(0, (DataType)this.groupingKeySchema$1);
                    UnsafeRow unsafeRow = this.curGroupingKey();
                    if (!(object != null ? !object.equals(unsafeRow) : unsafeRow != null)) {
                        SchemaUtil$.org$apache$spark$sql$execution$datasources$v2$state$utils$SchemaUtil$$appendKVPairToMap$1(this.curMap(), this.curStateRowPair(), this.userKeySchema$1);
                        continue;
                    }
                    foundNewGroupingKey = true;
                }
                if (foundNewGroupingKey) {
                    GenericInternalRow row = SchemaUtil$.org$apache$spark$sql$execution$datasources$v2$state$utils$SchemaUtil$$createDataRow$1(this.curGroupingKey(), this.curMap(), this.partitionId$1);
                    this.curGroupingKey_$eq(((UnsafeRow)this.curStateRowPair().key().get(0, (DataType)this.groupingKeySchema$1)).copy());
                    this.curMap().clear();
                    SchemaUtil$.org$apache$spark$sql$execution$datasources$v2$state$utils$SchemaUtil$$appendKVPairToMap$1(this.curMap(), this.curStateRowPair(), this.userKeySchema$1);
                    return row;
                }
                if (this.curMap().isEmpty()) {
                    throw new NoSuchElementException("Please check if the iterator hasNext(); Likely user is trying to get element from an exhausted iterator.");
                }
                GenericInternalRow row = SchemaUtil$.org$apache$spark$sql$execution$datasources$v2$state$utils$SchemaUtil$$createDataRow$1(this.curGroupingKey(), this.curMap(), this.partitionId$1);
                this.curMap().clear();
                return row;
            }
            {
                this.stateRows$1 = stateRows$1;
                this.groupingKeySchema$1 = groupingKeySchema$1;
                this.userKeySchema$1 = userKeySchema$1;
                this.partitionId$1 = partitionId$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.curMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidSchema(StateSourceOptions sourceOptions, StructType schema, Option<TransformWithStateVariableInfo> transformWithStateVariableInfoOpt) {
        .colon.colon colon2;
        scala.collection.immutable.Map expectedTypes = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batch_id"), LongType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"change_type"), StringType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), StructType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), StructType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"list_element"), StructType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"list_value"), ArrayType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"map_value"), MapType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user_map_key"), StructType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user_map_value"), StructType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expiration_timestamp_ms"), LongType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition_id"), IntegerType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition_key"), StructType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key_bytes"), BinaryType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value_bytes"), BinaryType.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"column_family_name"), StringType.class)}));
        if (transformWithStateVariableInfoOpt.isDefined()) {
            Enumeration.Value stateVarType;
            TransformWithStateVariableInfo stateVarInfo = (TransformWithStateVariableInfo)transformWithStateVariableInfoOpt.get();
            Enumeration.Value value = stateVarType = stateVarInfo.stateVariableType();
            Enumeration.Value value2 = StateVariableType$.MODULE$.ValueState();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                colon2 = sourceOptions.readChangeFeed() ? new .colon.colon((Object)"batch_id", (List)new .colon.colon((Object)"change_type", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$))))) : new .colon.colon((Object)"key", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$)));
            } else {
                Enumeration.Value value4 = StateVariableType$.MODULE$.ListState();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    colon2 = sourceOptions.readChangeFeed() ? new .colon.colon((Object)"batch_id", (List)new .colon.colon((Object)"change_type", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"list_element", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$))))) : (sourceOptions.flattenCollectionTypes() ? new .colon.colon((Object)"key", (List)new .colon.colon((Object)"list_element", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$))) : new .colon.colon((Object)"key", (List)new .colon.colon((Object)"list_value", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$))));
                } else {
                    Enumeration.Value value6 = StateVariableType$.MODULE$.MapState();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        colon2 = sourceOptions.readChangeFeed() ? new .colon.colon((Object)"batch_id", (List)new .colon.colon((Object)"change_type", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"user_map_key", (List)new .colon.colon((Object)"user_map_value", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$)))))) : (sourceOptions.flattenCollectionTypes() ? new .colon.colon((Object)"key", (List)new .colon.colon((Object)"user_map_key", (List)new .colon.colon((Object)"user_map_value", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$)))) : new .colon.colon((Object)"key", (List)new .colon.colon((Object)"map_value", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$))));
                    } else {
                        Enumeration.Value value8 = StateVariableType$.MODULE$.TimerState();
                        Enumeration.Value value9 = value;
                        if (value8 != null ? !value8.equals(value9) : value9 != null) throw StateDataSourceErrors$.MODULE$.internalError("Unsupported state variable type " + stateVarType);
                        colon2 = new .colon.colon((Object)"key", (List)new .colon.colon((Object)"expiration_timestamp_ms", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$)));
                    }
                }
            }
        } else {
            colon2 = sourceOptions.readChangeFeed() ? new .colon.colon((Object)"batch_id", (List)new .colon.colon((Object)"change_type", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$))))) : (sourceOptions.internalOnlyReadAllColumnFamilies() ? new .colon.colon((Object)"partition_key", (List)new .colon.colon((Object)"key_bytes", (List)new .colon.colon((Object)"value_bytes", (List)new .colon.colon((Object)"column_family_name", (List)Nil$.MODULE$)))) : new .colon.colon((Object)"key", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"partition_id", (List)Nil$.MODULE$))));
        }
        .colon.colon expectedFieldNames = colon2;
        ArraySeq arraySeq = ArrayImplicits$.MODULE$.SparkArrayOps((Object)schema.fieldNames()).toImmutableArraySeq();
        .colon.colon colon3 = expectedFieldNames;
        if (!(arraySeq == null ? colon3 != null : !arraySeq.equals(colon3))) return ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Function1 & Serializable)fieldName -> BoxesRunTime.boxToBoolean((boolean)SchemaUtil$.$anonfun$isValidSchema$1(expectedTypes, schema, fieldName)));
        return false;
    }

    private StructType generateSchemaForStateVar(TransformWithStateVariableInfo stateVarInfo, StateStoreColFamilySchema stateStoreColFamilySchema, StateSourceOptions stateSourceOptions) {
        Enumeration.Value stateVarType;
        Enumeration.Value value = stateVarType = stateVarInfo.stateVariableType();
        Enumeration.Value value2 = StateVariableType$.MODULE$.ValueState();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            if (stateSourceOptions.readChangeFeed()) {
                return new StructType().add("batch_id", (DataType)LongType$.MODULE$).add("change_type", (DataType)StringType$.MODULE$).add("key", (DataType)stateStoreColFamilySchema.keySchema()).add("value", (DataType)stateStoreColFamilySchema.valueSchema()).add("partition_id", (DataType)IntegerType$.MODULE$);
            }
            return new StructType().add("key", (DataType)stateStoreColFamilySchema.keySchema()).add("value", (DataType)stateStoreColFamilySchema.valueSchema()).add("partition_id", (DataType)IntegerType$.MODULE$);
        }
        Enumeration.Value value4 = StateVariableType$.MODULE$.ListState();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            if (stateSourceOptions.readChangeFeed()) {
                return new StructType().add("batch_id", (DataType)LongType$.MODULE$).add("change_type", (DataType)StringType$.MODULE$).add("key", (DataType)stateStoreColFamilySchema.keySchema()).add("list_element", (DataType)stateStoreColFamilySchema.valueSchema()).add("partition_id", (DataType)IntegerType$.MODULE$);
            }
            if (stateSourceOptions.flattenCollectionTypes()) {
                return new StructType().add("key", (DataType)stateStoreColFamilySchema.keySchema()).add("list_element", (DataType)stateStoreColFamilySchema.valueSchema()).add("partition_id", (DataType)IntegerType$.MODULE$);
            }
            return new StructType().add("key", (DataType)stateStoreColFamilySchema.keySchema()).add("list_value", (DataType)ArrayType$.MODULE$.apply((DataType)stateStoreColFamilySchema.valueSchema())).add("partition_id", (DataType)IntegerType$.MODULE$);
        }
        Enumeration.Value value6 = StateVariableType$.MODULE$.MapState();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            DataType groupingKeySchema = this.getSchemaAsDataType(stateStoreColFamilySchema.keySchema(), "key");
            StructType userKeySchema = (StructType)stateStoreColFamilySchema.userKeyEncoderSchema().get();
            MapType valueMapSchema = MapType$.MODULE$.apply((DataType)userKeySchema, (DataType)stateStoreColFamilySchema.valueSchema());
            if (stateSourceOptions.readChangeFeed()) {
                return new StructType().add("batch_id", (DataType)LongType$.MODULE$).add("change_type", (DataType)StringType$.MODULE$).add("key", groupingKeySchema).add("user_map_key", (DataType)userKeySchema).add("user_map_value", (DataType)stateStoreColFamilySchema.valueSchema()).add("partition_id", (DataType)IntegerType$.MODULE$);
            }
            if (stateSourceOptions.flattenCollectionTypes()) {
                return new StructType().add("key", groupingKeySchema).add("user_map_key", (DataType)userKeySchema).add("user_map_value", (DataType)stateStoreColFamilySchema.valueSchema()).add("partition_id", (DataType)IntegerType$.MODULE$);
            }
            return new StructType().add("key", groupingKeySchema).add("map_value", (DataType)valueMapSchema).add("partition_id", (DataType)IntegerType$.MODULE$);
        }
        Enumeration.Value value8 = StateVariableType$.MODULE$.TimerState();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            DataType groupingKeySchema = this.getSchemaAsDataType(stateStoreColFamilySchema.keySchema(), "key");
            return new StructType().add("key", groupingKeySchema).add("expiration_timestamp_ms", (DataType)LongType$.MODULE$).add("partition_id", (DataType)IntegerType$.MODULE$);
        }
        throw StateDataSourceErrors$.MODULE$.internalError("Unsupported state variable type " + stateVarType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkVariableType(Option<TransformWithStateVariableInfo> stateVariableInfoOpt, Enumeration.Value varType) {
        if (!stateVariableInfoOpt.isDefined()) return false;
        Enumeration.Value value = ((TransformWithStateVariableInfo)stateVariableInfoOpt.get()).stateVariableType();
        Enumeration.Value value2 = varType;
        if (value != null) {
            if (!value.equals(value2)) return false;
            return true;
        }
        if (value2 == null) return true;
        return false;
    }

    public StructType getCompositeKeySchema(StructType schema, StateSourceOptions stateSourceOptions) {
        Option option;
        StructType groupingKeySchema = (StructType)this.getSchemaAsDataType(schema, "key");
        try {
            option = stateSourceOptions.flattenCollectionTypes() ? Option$.MODULE$.apply((Object)((StructType)this.getSchemaAsDataType(schema, "user_map_key"))) : Option$.MODULE$.apply((Object)((StructType)((MapType)this.getSchemaAsDataType(schema, "map_value")).keyType()));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw StateDataSourceErrors$.MODULE$.internalError("No such field named as 'map_value' during state source reader schema initialization. Internal exception message: " + throwable2);
            }
            throw throwable;
        }
        Option userKeySchema = option;
        return new StructType().add("key", (DataType)groupingKeySchema).add("userKey", (DataType)userKeySchema.get());
    }

    public Iterator<InternalRow> processStateEntries(Enumeration.Value stateVarType, String stateVarName, ReadStateStore store, StructType compositeKeySchema, int partitionId, StateSourceOptions stateSourceOptions) {
        Enumeration.Value value = stateVarType;
        Enumeration.Value value2 = StateVariableType$.MODULE$.ValueState();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return store.iterator(stateVarName).map((Function1 & Serializable)pair -> MODULE$.unifyStateRowPair((Tuple2<UnsafeRow, UnsafeRow>)new Tuple2((Object)pair.key(), (Object)pair.value()), partitionId));
        }
        Enumeration.Value value4 = StateVariableType$.MODULE$.ListState();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            if (stateSourceOptions.flattenCollectionTypes()) {
                return store.iterator(stateVarName).flatMap((Function1 & Serializable)pair -> {
                    UnsafeRow key = pair.key();
                    Iterator<UnsafeRow> result = store.valuesIterator(key, stateVarName);
                    return result.map((Function1 & Serializable)entry -> MODULE$.unifyStateRowPair((Tuple2<UnsafeRow, UnsafeRow>)new Tuple2((Object)key, entry), partitionId));
                });
            }
            return store.iterator(stateVarName).map((Function1 & Serializable)pair -> {
                UnsafeRow key = pair.key();
                Iterator<UnsafeRow> result = store.valuesIterator(key, stateVarName);
                ArrayBuffer unsafeRowArr = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                result.foreach((Function1 & Serializable)entry -> (ArrayBuffer)unsafeRowArr.$plus$eq((Object)entry.copy()));
                GenericArrayData arrData = new GenericArrayData(unsafeRowArr.toArray(ClassTag$.MODULE$.apply(UnsafeRow.class)));
                return MODULE$.unifyStateRowPairWithMultipleValues((Tuple2<UnsafeRow, GenericArrayData>)new Tuple2((Object)key, (Object)arrData), partitionId);
            });
        }
        Enumeration.Value value6 = StateVariableType$.MODULE$.MapState();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return this.unifyMapStateRowPair(store.iterator(stateVarName), compositeKeySchema, partitionId, stateSourceOptions);
        }
        Enumeration.Value value8 = StateVariableType$.MODULE$.TimerState();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return store.iterator(stateVarName).map((Function1 & Serializable)pair -> MODULE$.unifyTimerRow(pair.key(), compositeKeySchema, partitionId));
        }
        throw new IllegalStateException("Unsupported state variable type: " + stateVarType);
    }

    private InternalRow unifyTimerRow(UnsafeRow rowKey, StructType groupingKeySchema, int partitionId) {
        UnsafeRow groupingKey = (UnsafeRow)rowKey.get(0, (DataType)groupingKeySchema);
        long expirationTimestamp = rowKey.getLong(1);
        GenericInternalRow row = new GenericInternalRow(3);
        row.update(0, (Object)groupingKey);
        row.update(1, (Object)BoxesRunTime.boxToLong((long)expirationTimestamp));
        row.update(2, (Object)BoxesRunTime.boxToInteger((int)partitionId));
        return row;
    }

    public static final void org$apache$spark$sql$execution$datasources$v2$state$utils$SchemaUtil$$appendKVPairToMap$1(scala.collection.mutable.Map curMap, UnsafeRowPair stateRowPair, StructType userKeySchema$1) {
        curMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((UnsafeRow)stateRowPair.key().get(1, (DataType)userKeySchema$1)).copy()), (Object)stateRowPair.value().copy()));
    }

    public static final GenericInternalRow org$apache$spark$sql$execution$datasources$v2$state$utils$SchemaUtil$$createDataRow$1(Object groupingKey, scala.collection.mutable.Map curMap, int partitionId$1) {
        GenericInternalRow row = new GenericInternalRow(3);
        ArrayBasedMapData mapData = ArrayBasedMapData$.MODULE$.apply((Map)curMap, ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
        row.update(0, groupingKey);
        row.update(1, (Object)mapData);
        row.update(2, (Object)BoxesRunTime.boxToInteger((int)partitionId$1));
        return row;
    }

    private static final GenericInternalRow createFlattenedRow$1(UnsafeRow groupingKey, UnsafeRow userMapKey, UnsafeRow userMapValue, int partitionId) {
        GenericInternalRow row = new GenericInternalRow(4);
        row.update(0, (Object)groupingKey);
        row.update(1, (Object)userMapKey);
        row.update(2, (Object)userMapValue);
        row.update(3, (Object)BoxesRunTime.boxToInteger((int)partitionId));
        return row;
    }

    public static final /* synthetic */ boolean $anonfun$isValidSchema$1(scala.collection.immutable.Map expectedTypes$1, StructType schema$1, String fieldName) {
        return ((Class)expectedTypes$1.apply((Object)fieldName)).isAssignableFrom(MODULE$.getSchemaAsDataType(schema$1, fieldName).getClass());
    }

    private SchemaUtil$() {
    }
}

