/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.StreamBlockData;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.storage.ExecutorStreamSummary;
import org.apache.spark.ui.storage.ToolTips$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SortedMap$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005%e!\u0002\f\u0018\u0001e\t\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u0011-\u0002!\u0011!Q\u0001\n1BQA\r\u0001\u0005\u0002MBQ\u0001\u000f\u0001\u0005\u0002eBaA\u0017\u0001\u0005\u0002]Y\u0006b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007s\u0002\u0001\u000b\u0011\u00026\t\u000fi\u0004!\u0019!C\u0001w\"9\u00111\u0001\u0001!\u0002\u0013a\bbBA\u0003\u0001\u0011%\u0011q\u0001\u0005\t\u0003\u001f\u0001A\u0011A\f\u0002\u0012!9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0002\u0002CA\u0013\u0001\t\u0007I\u0011B5\t\u000f\u0005\u001d\u0002\u0001)A\u0005U\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\t\u0003#\u0002!\u0019!C\u0005S\"9\u00111\u000b\u0001!\u0002\u0013Q\u0007bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u0003;\u0002A\u0011BA0\u0011!\tY\b\u0001C\u0001/\u0005u$aC*u_J\fw-\u001a)bO\u0016T!\u0001G\r\u0002\u000fM$xN]1hK*\u0011!dG\u0001\u0003k&T!\u0001H\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\n\u0003\u0001\t\u0002\"a\t\u0013\u000e\u0003eI!!J\r\u0003\u0013]+'-V%QC\u001e,\u0017A\u00029be\u0016tGo\u0001\u0001\u0011\u0005\rJ\u0013B\u0001\u0016\u001a\u0005)\u0019\u0006/\u0019:l+&#\u0016MY\u0001\u0006gR|'/\u001a\t\u0003[Aj\u0011A\f\u0006\u0003_m\taa\u001d;biV\u001c\u0018BA\u0019/\u00059\t\u0005\u000f]*uCR,8o\u0015;pe\u0016\fa\u0001P5oSRtDc\u0001\u001b7oA\u0011Q\u0007A\u0007\u0002/!)ae\u0001a\u0001Q!)1f\u0001a\u0001Y\u00051!/\u001a8eKJ$\"A\u000f(\u0011\u0007m*\u0005J\u0004\u0002=\u0005:\u0011Q\bQ\u0007\u0002})\u0011qhJ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005\u000bQa]2bY\u0006L!a\u0011#\u0002\u000fA\f7m[1hK*\t\u0011)\u0003\u0002G\u000f\n\u00191+Z9\u000b\u0005\r#\u0005CA%M\u001b\u0005Q%BA&E\u0003\rAX\u000e\\\u0005\u0003\u001b*\u0013AAT8eK\")q\n\u0002a\u0001!\u00069!/Z9vKN$\bCA)Y\u001b\u0005\u0011&BA*U\u0003\u0011AG\u000f\u001e9\u000b\u0005U3\u0016aB:feZdW\r\u001e\u0006\u0002/\u00069!.Y6beR\f\u0017BA-S\u0005IAE\u000f\u001e9TKJ4H.\u001a;SKF,Xm\u001d;\u0002\u0011I$G\rV1cY\u0016$2A\u000f/^\u0011\u0015yU\u00011\u0001Q\u0011\u0015qV\u00011\u0001`\u0003\u0011\u0011H\rZ:\u0011\u0007m*\u0005\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006\u0011a/\r\u0006\u0003K:\n1!\u00199j\u0013\t9'M\u0001\bS\t\u0012\u001bFo\u001c:bO\u0016LeNZ8\u0002\u0013I$G\rS3bI\u0016\u0014X#\u00016\u0011\u0007-\u0004\u0018/D\u0001m\u0015\tig.A\u0005j[6,H/\u00192mK*\u0011q\u000eR\u0001\u000bG>dG.Z2uS>t\u0017B\u0001$m!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0003mC:<'\"\u0001<\u0002\t)\fg/Y\u0005\u0003qN\u0014aa\u0015;sS:<\u0017A\u0003:eI\"+\u0017\rZ3sA\u0005AAo\\8mi&\u00048/F\u0001}!\rY\u0007/ \t\u0004}~\fX\"\u0001#\n\u0007\u0005\u0005AI\u0001\u0004PaRLwN\\\u0001\ni>|G\u000e^5qg\u0002\naA\u001d3e%><H#\u0002\u001e\u0002\n\u0005-\u0001\"B(\u000b\u0001\u0004\u0001\u0006BBA\u0007\u0015\u0001\u0007\u0001-A\u0002sI\u0012\f1C]3dK&4XM\u001d\"m_\u000e\\G+\u00192mKN$2AOA\n\u0011\u001d\t)b\u0003a\u0001\u0003/\taA\u00197pG.\u001c\b\u0003B\u001eF\u00033\u00012!LA\u000e\u0013\r\tiB\f\u0002\u0010'R\u0014X-Y7CY>\u001c7\u000eR1uC\u0006!R\r_3dkR|'/T3ue&\u001c7\u000fV1cY\u0016$2AOA\u0012\u0011\u001d\t)\u0002\u0004a\u0001\u0003/\t!$\u001a=fGV$xN]'fiJL7m\u001d+bE2,\u0007*Z1eKJ\f1$\u001a=fGV$xN]'fiJL7m\u001d+bE2,\u0007*Z1eKJ\u0004\u0013aF3yK\u000e,Ho\u001c:NKR\u0014\u0018nY:UC\ndWMU8x)\rQ\u0014Q\u0006\u0005\u0007_=\u0001\r!a\f\u0011\u0007U\n\t$C\u0002\u00024]\u0011Q#\u0012=fGV$xN]*ue\u0016\fWnU;n[\u0006\u0014\u00180\u0001\ttiJ,\u0017-\u001c\"m_\u000e\\G+\u00192mKR\u0019!(!\u000f\t\u000f\u0005U\u0001\u00031\u0001\u0002<A!1(RA\u001f!\u001dq\u0018qHA\"\u0003/I1!!\u0011E\u0005\u0019!V\u000f\u001d7feA!\u0011QIA'\u001d\u0011\t9%!\u0013\u0011\u0005u\"\u0015bAA&\t\u00061\u0001K]3eK\u001aL1\u0001_A(\u0015\r\tY\u0005R\u0001\u0017gR\u0014X-Y7CY>\u001c7\u000eV1cY\u0016DU-\u00193fe\u000692\u000f\u001e:fC6\u0014En\\2l)\u0006\u0014G.\u001a%fC\u0012,'\u000fI\u0001\u0014gR\u0014X-Y7CY>\u001c7\u000eV1cY\u0016\u0014vn\u001e\u000b\u0004u\u0005e\u0003bBA.'\u0001\u0007\u0011QH\u0001\u0006E2|7m[\u0001\u0017gR\u0014X-Y7CY>\u001c7\u000eV1cY\u0016\u001cVO\u0019:poRI!(!\u0019\u0002f\u0005\u001d\u0014\u0011\u000f\u0005\b\u0003G\"\u0002\u0019AA\"\u0003\u001d\u0011Gn\\2l\u0013\u0012Dq!a\u0017\u0015\u0001\u0004\tI\u0002C\u0004\u0002jQ\u0001\r!a\u001b\u0002\u0017I,\u0007\u000f\\5dCRLwN\u001c\t\u0004}\u00065\u0014bAA8\t\n\u0019\u0011J\u001c;\t\u000f\u0005MD\u00031\u0001\u0002v\u0005Ya-\u001b:tiN+(M]8x!\rq\u0018qO\u0005\u0004\u0003s\"%a\u0002\"p_2,\u0017M\\\u0001*gR\u0014X-Y7CY>\u001c7n\u0015;pe\u0006<W\rT3wK2$Um]2sSB$\u0018n\u001c8B]\u0012\u001c\u0016N_3\u0015\t\u0005}\u0014q\u0011\t\b}\u0006}\u00121IAA!\rq\u00181Q\u0005\u0004\u0003\u000b#%\u0001\u0002'p]\u001eDq!a\u0017\u0016\u0001\u0004\tI\u0002")
public class StoragePage
extends WebUIPage {
    private final SparkUITab parent;
    private final AppStatusStore store;
    private final scala.collection.immutable.Seq<String> rddHeader;
    private final scala.collection.immutable.Seq<Option<String>> tooltips;
    private final scala.collection.immutable.Seq<String> executorMetricsTableHeader;
    private final scala.collection.immutable.Seq<String> streamBlockTableHeader;

    @Override
    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        scala.collection.immutable.Seq content = (scala.collection.immutable.Seq)this.rddTable(request, this.store.rddList(this.store.rddList$default$1())).$plus$plus(this.receiverBlockTables(this.store.streamBlocksList()));
        return UIUtils$.MODULE$.headerSparkPage(request, "Storage", (Function0<scala.collection.immutable.Seq<Node>>)(Function0 & Serializable)() -> content, this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    public scala.collection.immutable.Seq<Node> rddTable(HttpServletRequest request, scala.collection.immutable.Seq<RDDStorageInfo> rdds) {
        if (rdds.isEmpty()) {
            return Nil$.MODULE$;
        }
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-rdds','aggregated-rdds')"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-rdds collapse-table"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md2);
        $buf3.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("RDDs ("));
        $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)rdds.length()));
        $buf4.$amp$plus((Object)new Text(")"));
        $buf3.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-rdds collapsible-table"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        scala.collection.immutable.Seq<String> x$12 = this.rddHeader();
        Function1 & Serializable x$2 = (Function1 & Serializable)x$1 -> this.rddRow(request, (RDDStorageInfo)x$1);
        scala.collection.immutable.Seq<RDDStorageInfo> x$3 = rdds;
        Some x$4 = new Some((Object)"storage-by-rdd-table");
        scala.collection.immutable.Seq<Option<String>> x$5 = this.tooltips();
        boolean x$6 = UIUtils$.MODULE$.listingTable$default$4();
        scala.collection.immutable.Seq<String> x$7 = UIUtils$.MODULE$.listingTable$default$6();
        boolean x$8 = UIUtils$.MODULE$.listingTable$default$7();
        boolean x$9 = UIUtils$.MODULE$.listingTable$default$8();
        $buf5.$amp$plus(UIUtils$.MODULE$.listingTable(x$12, x$2, x$3, x$6, (Option<String>)x$4, x$7, x$8, x$9, x$5));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    private scala.collection.immutable.Seq<String> rddHeader() {
        return this.rddHeader;
    }

    public scala.collection.immutable.Seq<Option<String>> tooltips() {
        return this.tooltips;
    }

    private scala.collection.immutable.Seq<Node> rddRow(HttpServletRequest request, RDDStorageInfo rdd) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)rdd.id()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s/storage/rdd/?id=%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), BoxesRunTime.boxToInteger((int)rdd.id())})), (MetaData)$md);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)rdd.name());
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)rdd.storageLevel());
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)Integer.toString(rdd.numCachedPartitions()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)rdd.numCachedPartitions() * 100.0 / (double)rdd.numPartitions()))})));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("sorttable_customkey", Long.toString(rdd.memoryUsed()), (MetaData)$md2);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)Utils$.MODULE$.bytesToString(rdd.memoryUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("sorttable_customkey", Long.toString(rdd.diskUsed()), (MetaData)$md3);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)Utils$.MODULE$.bytesToString(rdd.diskUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    public scala.collection.immutable.Seq<Node> receiverBlockTables(scala.collection.immutable.Seq<StreamBlockData> blocks) {
        if (blocks.isEmpty()) {
            return Nil$.MODULE$;
        }
        scala.collection.immutable.Seq sorted = (scala.collection.immutable.Seq)blocks.groupBy((Function1 & Serializable)x$2 -> x$2.name()).toSeq().sortBy((Function1 & Serializable)x$3 -> (String)x$3._1(), (Ordering)Ordering.String$.MODULE$);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Receiver Blocks"));
        $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus(this.executorMetricsTable(blocks));
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus(this.streamBlockTable((scala.collection.immutable.Seq<Tuple2<String, scala.collection.immutable.Seq<StreamBlockData>>>)sorted));
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    private scala.collection.immutable.Seq<Node> executorMetricsTable(scala.collection.immutable.Seq<StreamBlockData> blocks) {
        Iterable blockManagers = (Iterable)((IterableOps)SortedMap$.MODULE$.apply(blocks.groupBy((Function1 & Serializable)x$4 -> x$4.executorId()).toSeq(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                scala.collection.immutable.Seq blocks = (scala.collection.immutable.Seq)tuple2._2();
                return new ExecutorStreamSummary((scala.collection.immutable.Seq<StreamBlockData>)blocks);
            }
            throw new MatchError((Object)tuple2);
        });
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Aggregated Block Metrics by Executor"));
        $buf.$amp$plus((Object)new Elem(null, "h5", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        scala.collection.immutable.Seq<String> x$1 = this.executorMetricsTableHeader();
        Function1 & Serializable x$2 = (Function1 & Serializable)status -> this.executorMetricsTableRow((ExecutorStreamSummary)status);
        Iterable x$3 = blockManagers;
        Some x$42 = new Some((Object)"storage-by-executor-stream-blocks");
        boolean x$5 = UIUtils$.MODULE$.listingTable$default$4();
        scala.collection.immutable.Seq<String> x$6 = UIUtils$.MODULE$.listingTable$default$6();
        boolean x$7 = UIUtils$.MODULE$.listingTable$default$7();
        boolean x$8 = UIUtils$.MODULE$.listingTable$default$8();
        scala.collection.immutable.Seq<Option<String>> x$9 = UIUtils$.MODULE$.listingTable$default$9();
        $buf.$amp$plus(UIUtils$.MODULE$.listingTable(x$1, x$2, x$3, x$5, (Option<String>)x$42, x$6, x$7, x$8, x$9));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    private scala.collection.immutable.Seq<String> executorMetricsTableHeader() {
        return this.executorMetricsTableHeader;
    }

    private scala.collection.immutable.Seq<Node> executorMetricsTableRow(ExecutorStreamSummary status) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)status.executorId());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)status.location());
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", Long.toString(status.totalMemSize()), (MetaData)$md);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(status.totalMemSize()));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("sorttable_customkey", Long.toString(status.totalDiskSize()), (MetaData)$md2);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)Utils$.MODULE$.bytesToString(status.totalDiskSize()));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)Integer.toString(status.numStreamBlocks()));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    private scala.collection.immutable.Seq<Node> streamBlockTable(scala.collection.immutable.Seq<Tuple2<String, scala.collection.immutable.Seq<StreamBlockData>>> blocks) {
        if (blocks.isEmpty()) {
            return Nil$.MODULE$;
        }
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Blocks"));
        $buf.$amp$plus((Object)new Elem(null, "h5", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n        "));
        scala.collection.immutable.Seq<String> x$1 = this.streamBlockTableHeader();
        Function1 & Serializable x$2 = (Function1 & Serializable)block -> this.streamBlockTableRow((Tuple2<String, scala.collection.immutable.Seq<StreamBlockData>>)block);
        scala.collection.immutable.Seq<Tuple2<String, scala.collection.immutable.Seq<StreamBlockData>>> x$3 = blocks;
        Some x$4 = new Some((Object)"storage-by-block-table");
        boolean x$5 = false;
        boolean x$6 = UIUtils$.MODULE$.listingTable$default$4();
        scala.collection.immutable.Seq<String> x$7 = UIUtils$.MODULE$.listingTable$default$6();
        boolean x$8 = UIUtils$.MODULE$.listingTable$default$7();
        scala.collection.immutable.Seq<Option<String>> x$9 = UIUtils$.MODULE$.listingTable$default$9();
        $buf.$amp$plus(UIUtils$.MODULE$.listingTable(x$1, x$2, x$3, x$6, (Option<String>)x$4, x$7, x$8, false, x$9));
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    private scala.collection.immutable.Seq<String> streamBlockTableHeader() {
        return this.streamBlockTableHeader;
    }

    private scala.collection.immutable.Seq<Node> streamBlockTableRow(Tuple2<String, scala.collection.immutable.Seq<StreamBlockData>> block) {
        scala.collection.immutable.Seq replications = (scala.collection.immutable.Seq)block._2();
        Predef$.MODULE$.assert(replications.nonEmpty());
        if (replications.size() == 1) {
            return this.streamBlockTableSubrow((String)block._1(), (StreamBlockData)replications.head(), replications.size(), true);
        }
        return (scala.collection.immutable.Seq)this.streamBlockTableSubrow((String)block._1(), (StreamBlockData)replications.head(), replications.size(), true).$plus$plus((IterableOnce)((IterableOps)replications.tail()).flatMap((Function1 & Serializable)x$5 -> this.streamBlockTableSubrow((String)block._1(), (StreamBlockData)x$5, replications.size(), false)));
    }

    private scala.collection.immutable.Seq<Node> streamBlockTableSubrow(String blockId, StreamBlockData block, int replication, boolean firstSubrow) {
        BoxedUnit boxedUnit;
        Tuple2<String, Object> tuple2 = this.streamBlockStorageLevelDescriptionAndSize(block);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String storageLevel = (String)tuple2._1();
        long size = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)storageLevel, (Object)BoxesRunTime.boxToLong((long)size));
        String storageLevel2 = (String)tuple22._1();
        long size2 = tuple22._2$mcJ$sp();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        if (firstSubrow) {
            NodeBuffer $buf2 = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", Integer.toString(replication), (MetaData)$md);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)block.name());
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("rowspan", Integer.toString(replication), (MetaData)$md2);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            "));
            $buf4.$amp$plus((Object)Integer.toString(replication));
            $buf4.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
            boxedUnit = $buf2;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $buf.$amp$plus((Object)boxedUnit);
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)block.hostPort());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)storageLevel2);
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)Utils$.MODULE$.bytesToString(size2));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    public Tuple2<String, Object> streamBlockStorageLevelDescriptionAndSize(StreamBlockData block) {
        if (block.useDisk()) {
            return new Tuple2((Object)"Disk", (Object)BoxesRunTime.boxToLong((long)block.diskSize()));
        }
        if (block.useMemory() && block.deserialized()) {
            return new Tuple2((Object)"Memory", (Object)BoxesRunTime.boxToLong((long)block.memSize()));
        }
        if (block.useMemory() && !block.deserialized()) {
            return new Tuple2((Object)"Memory Serialized", (Object)BoxesRunTime.boxToLong((long)block.memSize()));
        }
        throw new IllegalStateException("Invalid Storage Level: " + block.storageLevel());
    }

    public StoragePage(SparkUITab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("");
        this.rddHeader = new .colon.colon((Object)"ID", (List)new .colon.colon((Object)"RDD Name", (List)new .colon.colon((Object)"Storage Level", (List)new .colon.colon((Object)"Cached Partitions", (List)new .colon.colon((Object)"Fraction Cached", (List)new .colon.colon((Object)"Size in Memory", (List)new .colon.colon((Object)"Size on Disk", (List)Nil$.MODULE$)))))));
        this.tooltips = new .colon.colon((Object)None$.MODULE$, (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.RDD_NAME()), (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.STORAGE_LEVEL()), (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.CACHED_PARTITIONS()), (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.FRACTION_CACHED()), (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.SIZE_IN_MEMORY()), (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.SIZE_ON_DISK()), (List)Nil$.MODULE$)))))));
        this.executorMetricsTableHeader = new .colon.colon((Object)"Executor ID", (List)new .colon.colon((Object)"Address", (List)new .colon.colon((Object)"Total Size in Memory", (List)new .colon.colon((Object)"Total Size on Disk", (List)new .colon.colon((Object)"Stream Blocks", (List)Nil$.MODULE$)))));
        this.streamBlockTableHeader = new .colon.colon((Object)"Block ID", (List)new .colon.colon((Object)"Replication Level", (List)new .colon.colon((Object)"Location", (List)new .colon.colon((Object)"Storage Level", (List)new .colon.colon((Object)"Size", (List)Nil$.MODULE$)))));
    }
}

