/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CommitLog$;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.CommitMetadata$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005%4A!\u0004\b\u00017!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011\u00151\u0004\u0001\"\u00018\u0011\u001dY\u0004A1A\u0005\nqBa!\u0011\u0001!\u0002\u0013i\u0004B\u0002\"\u0001\t#\u00122\t\u0003\u0004O\u0001\u0011E#cT\u0004\u00065:A\ta\u0017\u0004\u0006\u001b9A\t\u0001\u0018\u0005\u0006m%!\t\u0001\u0019\u0005\bC&\u0011\r\u0011\"\u0003c\u0011\u0019A\u0017\u0002)A\u0005G\nI1i\\7nSRdun\u001a\u0006\u0003\u001fA\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005E\u0011\u0012!C3yK\u000e,H/[8o\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0004E\u0002\u001e=\u0001j\u0011AD\u0005\u0003?9\u0011q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\t\u0003;\u0005J!A\t\b\u0003\u001d\r{W.\\5u\u001b\u0016$\u0018\rZ1uC\u0006a1\u000f]1sWN+7o]5p]B\u0011QEJ\u0007\u0002%%\u0011qE\u0005\u0002\r'B\f'o[*fgNLwN\\\u0001\u0005a\u0006$\b\u000e\u0005\u0002+g9\u00111&\r\t\u0003Y=j\u0011!\f\u0006\u0003]i\ta\u0001\u0010:p_Rt$\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!AM\u0018\u0002\rqJg.\u001b;?)\rA\u0014H\u000f\t\u0003;\u0001AQaI\u0002A\u0002\u0011BQ\u0001K\u0002A\u0002%\nqAV#S'&{e*F\u0001>!\tqt(D\u00010\u0013\t\u0001uFA\u0002J]R\f\u0001BV#S'&{e\nI\u0001\fI\u0016\u001cXM]5bY&TX\r\u0006\u0002!\t\")QI\u0002a\u0001\r\u0006\u0011\u0011N\u001c\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b!![8\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0013\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\u0005tKJL\u0017\r\\5{KR\u0019\u0001kU+\u0011\u0005y\n\u0016B\u0001*0\u0005\u0011)f.\u001b;\t\u000bQ;\u0001\u0019\u0001\u0011\u0002\u00115,G/\u00193bi\u0006DQAV\u0004A\u0002]\u000b1a\\;u!\t9\u0005,\u0003\u0002Z\u0011\naq*\u001e;qkR\u001cFO]3b[\u0006I1i\\7nSRdun\u001a\t\u0003;%\u0019\"!C/\u0011\u0005yr\u0016BA00\u0005\u0019\te.\u001f*fMR\t1,\u0001\u0006F\u001bB#\u0016l\u0018&T\u001f:+\u0012a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M*\u000bA\u0001\\1oO&\u0011A'Z\u0001\f\u000b6\u0003F+W0K'>s\u0005\u0005")
public class CommitLog
extends HDFSMetadataLog<CommitMetadata> {
    private final int VERSION;

    private int VERSION() {
        return this.VERSION;
    }

    @Override
    public CommitMetadata deserialize(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, StandardCharsets.UTF_8.name()).getLines();
        if (!lines.hasNext()) {
            throw new IllegalStateException("Incomplete log file in the offset commit log");
        }
        this.validateVersionExactMatch(((String)lines.next()).trim(), this.VERSION());
        String metadataJson = lines.hasNext() ? (String)lines.next() : CommitLog$.MODULE$.org$apache$spark$sql$execution$streaming$CommitLog$$EMPTY_JSON();
        return CommitMetadata$.MODULE$.apply(metadataJson);
    }

    @Override
    public void serialize(CommitMetadata metadata, OutputStream out) {
        out.write(("v" + this.VERSION()).getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.write(metadata.json().getBytes(StandardCharsets.UTF_8));
    }

    public CommitLog(SparkSession sparkSession, String path) {
        super(sparkSession, path, ClassTag$.MODULE$.apply(CommitMetadata.class));
        this.VERSION = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sparkSession.conf().get(SQLConf$.MODULE$.STATE_STORE_CHECKPOINT_FORMAT_VERSION().key())));
    }
}

