/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitLength$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bit length of string data or number of bits of binary data.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       72\n      > SELECT _FUNC_(x'537061726b2053514c');\n       72\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\u000e\u001d\u0001&B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\")Q\n\u0001C!\u001d\")!\u000b\u0001C!'\")!\f\u0001C!7\")!\r\u0001C)G\")\u0011\u000e\u0001C!U\")\u0001\u0010\u0001C!s\"9\u0011Q\u0001\u0001\u0005R\u0005\u001d\u0001\"CA\u0007\u0001\u0005\u0005I\u0011AA\b\u0011%\t\u0019\u0002AI\u0001\n\u0003\t)\u0002C\u0005\u0002,\u0001\t\t\u0011\"\u0011\u0002.!I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0011q\b\u0005\n\u0003\u000f\u0002\u0011\u0011!C\u0001\u0003\u0013B\u0011\"a\u0014\u0001\u0003\u0003%\t%!\u0015\t\u0013\u0005}\u0003!!A\u0005\u0002\u0005\u0005\u0004\"CA3\u0001\u0005\u0005I\u0011IA4\u0011%\tY\u0007AA\u0001\n\u0003\nigB\u0005\u0002\u0012r\t\t\u0011#\u0001\u0002\u0014\u001aA1\u0004HA\u0001\u0012\u0003\t)\n\u0003\u0004J+\u0011\u0005\u0011Q\u0016\u0005\n\u0003_+\u0012\u0011!C#\u0003cC\u0011\"a-\u0016\u0003\u0003%\t)!.\t\u0013\u0005eV#!A\u0005\u0002\u0006m\u0006\"CAd+\u0005\u0005I\u0011BAe\u0005%\u0011\u0015\u000e\u001e'f]\u001e$\bN\u0003\u0002\u001e=\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\ty\u0002%\u0001\u0005dCR\fG._:u\u0015\t\t#%A\u0002tc2T!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\u0002\u0001'\u0015\u0001!FL\u00198!\tYC&D\u0001\u001d\u0013\tiCDA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tYs&\u0003\u000219\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14GA\u0004Qe>$Wo\u0019;\u0011\u0005a\u0002eBA\u001d?\u001d\tQT(D\u0001<\u0015\ta\u0004&\u0001\u0004=e>|GOP\u0005\u0002i%\u0011qhM\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002@g\u0005)1\r[5mIV\tQ\t\u0005\u0002,\r&\u0011q\t\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u00172\u0003\"a\u000b\u0001\t\u000b\r\u001b\u0001\u0019A#\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\tq\n\u0005\u00023!&\u0011\u0011k\r\u0002\b\u0005>|G.Z1o\u0003!!\u0017\r^1UsB,W#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]\u0003\u0013!\u0002;za\u0016\u001c\u0018BA-W\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tA\fE\u00029;~K!A\u0018\"\u0003\u0007M+\u0017\u000f\u0005\u0002VA&\u0011\u0011M\u0016\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fAB\\;mYN\u000bg-Z#wC2$\"\u0001Z4\u0011\u0005I*\u0017B\u000144\u0005\r\te.\u001f\u0005\u0006Q\u001e\u0001\r\u0001Z\u0001\u0006m\u0006dW/Z\u0001\nI><UM\\\"pI\u0016$2a[9w!\taw.D\u0001n\u0015\tqG$A\u0004d_\u0012,w-\u001a8\n\u0005Al'\u0001C#yaJ\u001cu\u000eZ3\t\u000bID\u0001\u0019A:\u0002\u0007\r$\b\u0010\u0005\u0002mi&\u0011Q/\u001c\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u00159\b\u00021\u0001l\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u001f\t\u0003w~t!\u0001`?\u0011\u0005i\u001a\u0014B\u0001@4\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011AA\u0002\u0005\u0019\u0019FO]5oO*\u0011apM\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007-\u000bI\u0001\u0003\u0004\u0002\f)\u0001\r!R\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\rY\u0015\u0011\u0003\u0005\b\u0007.\u0001\n\u00111\u0001F\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0006+\u0007\u0015\u000bIb\u000b\u0002\u0002\u001cA!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012!C;oG\",7m[3e\u0015\r\t)cM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0015\u0003?\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0012\u0001\u00026bm\u0006LA!!\u0001\u00024\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\t\t\u0004e\u0005\r\u0013bAA#g\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A-a\u0013\t\u0013\u00055s\"!AA\u0002\u0005\u0005\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002TA)\u0011QKA.I6\u0011\u0011q\u000b\u0006\u0004\u00033\u001a\u0014AC2pY2,7\r^5p]&!\u0011QLA,\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007=\u000b\u0019\u0007\u0003\u0005\u0002NE\t\t\u00111\u0001e\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005=\u0012\u0011\u000e\u0005\n\u0003\u001b\u0012\u0012\u0011!a\u0001\u0003\u0003\na!Z9vC2\u001cHcA(\u0002p!A\u0011QJ\n\u0002\u0002\u0003\u0007A\rK\n\u0001\u0003g\nI(a\u001f\u0002\u0000\u0005\u0005\u0015QQAD\u0003\u0017\u000bi\tE\u0002,\u0003kJ1!a\u001e\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!! \u0002-~3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!E&$\b\u0005\\3oORD\u0007e\u001c4!gR\u0014\u0018N\\4!I\u0006$\u0018\rI8sA9,XNY3sA=4\u0007EY5ug\u0002zg\r\t2j]\u0006\u0014\u0018\u0010\t3bi\u0006t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0015a\u001e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6!'Fcu%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!oIR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006_\u00146g]\u0002d'M\u001c3m\t\u0014\u0004'N\u001a6cQ\u001aw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!oIR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0013\u000bQA\r\u00184]A\nQa\u001a:pkB\f#!a$\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0013\tKG\u000fT3oORD\u0007CA\u0016\u0016'\u0015)\u0012qSAR!\u0019\tI*a(F\u00176\u0011\u00111\u0014\u0006\u0004\u0003;\u001b\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003C\u000bYJA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!!*\u0002,6\u0011\u0011q\u0015\u0006\u0005\u0003S\u000b9$\u0001\u0002j_&\u0019\u0011)a*\u0015\u0005\u0005M\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005=\u0012!B1qa2LHcA&\u00028\")1\t\u0007a\u0001\u000b\u00069QO\\1qa2LH\u0003BA_\u0003\u0007\u0004BAMA`\u000b&\u0019\u0011\u0011Y\u001a\u0003\r=\u0003H/[8o\u0011!\t)-GA\u0001\u0002\u0004Y\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u001a\t\u0005\u0003c\ti-\u0003\u0003\u0002P\u0006M\"AB(cU\u0016\u001cG\u000f")
public class BitLength
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitLength x$0) {
        return BitLength$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitLength, A> g) {
        return BitLength$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, BitLength> compose(Function1<A$, Expression> g) {
        return BitLength$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), BinaryType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object value) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            return BoxesRunTime.boxToInteger((int)(((UTF8String)value).numBytes() * 8));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)(((byte[])value).length * 8));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").numBytes() * 8");
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").length * 8");
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public String prettyName() {
        return "bit_length";
    }

    @Override
    public BitLength withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitLength copy(Expression child) {
        return new BitLength(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitLength";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitLength;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitLength)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitLength bitLength = (BitLength)x$1;
        Expression expression = this.child();
        Expression expression2 = bitLength.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitLength.canEqual(this)) return false;
        return true;
    }

    public BitLength(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

