/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.xml;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Predef$;

public final class XmlUtils$ {
    public static final XmlUtils$ MODULE$ = new XmlUtils$();

    public Dataset<String> sample(Dataset<String> xml, XmlOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable)() -> "samplingRatio (" + options.samplingRatio() + ") should be greater than 0");
        if (options.samplingRatio() > 0.99) {
            return xml;
        }
        return xml.sample(false, options.samplingRatio(), 1L);
    }

    public RDD<PortableDataStream> sample(RDD<PortableDataStream> xml, XmlOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable)() -> "samplingRatio (" + options.samplingRatio() + ") should be greater than 0");
        if (options.samplingRatio() > 0.99) {
            return xml;
        }
        return xml.sample(false, options.samplingRatio(), 1L);
    }

    public void checkXmlSchema(DataType schema) {
        TypeCheckResult.DataTypeMismatch dataTypeMismatch;
        String string;
        TypeCheckResult typeCheckResult = ExprUtils$.MODULE$.checkXmlSchema(schema);
        if (typeCheckResult instanceof TypeCheckResult.DataTypeMismatch && "INVALID_XML_MAP_KEY_TYPE".equals(string = (dataTypeMismatch = (TypeCheckResult.DataTypeMismatch)typeCheckResult).errorSubClass())) {
            throw QueryCompilationErrors$.MODULE$.invalidXmlSchema(schema);
        }
        if (TypeCheckResult.TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            return;
        }
        throw SparkException$.MODULE$.internalError("Unknown type check result: " + typeCheckResult + ".");
    }

    private XmlUtils$() {
    }
}

