/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

public class BitmapExpressionUtils {
    public static final int NUM_BYTES = 4096;
    public static final int NUM_BITS = 32768;

    public static long bitmapBucketNumber(long value) {
        if (value > 0L) {
            return 1L + (value - 1L) / 32768L;
        }
        return value / 32768L;
    }

    public static long bitmapBitPosition(long value) {
        if (value > 0L) {
            return (value - 1L) % 32768L;
        }
        return -value % 32768L;
    }

    public static long bitmapCount(byte[] bitmap) {
        long count = 0L;
        for (byte b : bitmap) {
            count += (long)Integer.bitCount(b & 0xFF);
        }
        return count;
    }

    public static void bitmapMerge(byte[] bitmap1, byte[] bitmap2) {
        for (int i = 0; i < Math.min(bitmap1.length, bitmap2.length); ++i) {
            bitmap1[i] = (byte)(bitmap1[i] & 0xFF | bitmap2[i] & 0xFF);
        }
    }
}

