/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import java.net.URI;
import java.util.Objects;

final class DefaultClientBuilderParams
implements ClientBuilderParams {
    private final Scheme scheme;
    private final EndpointGroup endpointGroup;
    private final String absolutePathRef;
    private final URI uri;
    private final Class<?> type;
    private final ClientOptions options;

    DefaultClientBuilderParams(URI uri, Class<?> type, ClientOptions options) {
        ClientFactory factory = Objects.requireNonNull(options, "options").factory();
        this.uri = factory.validateUri(uri);
        this.type = Objects.requireNonNull(type, "type");
        this.options = options;
        this.scheme = factory.validateScheme(Scheme.parse(uri.getScheme()));
        this.endpointGroup = Endpoint.parse(uri.getRawAuthority());
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append(DefaultClientBuilderParams.nullOrEmptyToSlash(uri.getRawPath()));
            if (uri.getRawQuery() != null) {
                buf.append('?').append(uri.getRawQuery());
            }
            if (uri.getRawFragment() != null) {
                buf.append('#').append(uri.getRawFragment());
            }
            this.absolutePathRef = buf.toString();
        }
    }

    DefaultClientBuilderParams(Scheme scheme, EndpointGroup endpointGroup, @Nullable String absolutePathRef, Class<?> type, ClientOptions options) {
        ClientFactory factory = Objects.requireNonNull(options, "options").factory();
        this.scheme = factory.validateScheme(scheme);
        this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
        this.type = Objects.requireNonNull(type, "type");
        this.options = options;
        String schemeStr = scheme.serializationFormat() == SerializationFormat.NONE ? scheme.sessionProtocol().uriText() : scheme.uriText();
        String normalizedAbsolutePathRef = DefaultClientBuilderParams.nullOrEmptyToSlash(absolutePathRef);
        URI uri = endpointGroup instanceof Endpoint ? URI.create(schemeStr + "://" + ((Endpoint)endpointGroup).authority() + normalizedAbsolutePathRef) : URI.create(schemeStr + "://armeria-group-" + Integer.toHexString(System.identityHashCode(endpointGroup)) + ":1" + normalizedAbsolutePathRef);
        this.uri = factory.validateUri(uri);
        this.absolutePathRef = normalizedAbsolutePathRef;
    }

    private static String nullOrEmptyToSlash(@Nullable String absolutePathRef) {
        if (Strings.isNullOrEmpty(absolutePathRef)) {
            return "/";
        }
        Preconditions.checkArgument(absolutePathRef.charAt(0) == '/', "absolutePathRef: %s (must start with '/')", (Object)absolutePathRef);
        return absolutePathRef;
    }

    @Override
    public Scheme scheme() {
        return this.scheme;
    }

    @Override
    public EndpointGroup endpointGroup() {
        return this.endpointGroup;
    }

    @Override
    public String absolutePathRef() {
        return this.absolutePathRef;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Class<?> clientType() {
        return this.type;
    }

    @Override
    public ClientOptions options() {
        return this.options;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("scheme", this.scheme).add("endpointGroup", this.endpointGroup).add("absolutePathRef", this.absolutePathRef).add("type", this.type).add("options", this.options).toString();
    }
}

