/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.sql.DataSource;
import org.apache.sis.io.stream.InternalOptionKey;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.sql.DataAccess;
import org.apache.sis.storage.sql.ResourceDefinition;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.feature.SchemaModifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Version;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.iso.Names;
import org.opengis.metadata.Metadata;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public abstract class SQLStore
extends DataStore
implements Aggregate {
    private static final String[] TITLE_GETTERS = new String[]{"getApplicationName", "getDataSourceName", "getDatabaseName"};
    private static final String[] IDENTIFIER_GETTERS = new String[]{"getDatabaseName", "getDataSourceName"};
    private static final String[] DETAILS_GETTERS = new String[]{"getDescription"};
    protected final DataSource source;
    private final GenericName identifier;
    private final GeometryLibrary geomLibrary;
    private volatile Database<?> model;
    private GenericName[] tableNames;
    private ResourceDefinition[] queries;
    private Metadata metadata;
    protected final Locale contentLocale;
    private final SchemaModifier customizer;
    final ReadWriteLock transactionLocks;

    protected SQLStore(DataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.source = (DataSource)connector.commit(DataSource.class, "SQL");
        this.geomLibrary = (GeometryLibrary)connector.getOption(OptionKey.GEOMETRY_LIBRARY);
        this.contentLocale = (Locale)connector.getOption(OptionKey.LOCALE);
        this.customizer = (SchemaModifier)connector.getOption(SchemaModifier.OPTION_KEY);
        this.transactionLocks = (ReadWriteLock)connector.getOption((OptionKey)InternalOptionKey.LOCKS);
        this.identifier = this.getDataSourceProperty(IDENTIFIER_GETTERS).map(id -> Names.createLocalName(null, null, (CharSequence)id)).orElse(null);
    }

    final void setModelSources(ResourceDefinition[] resources) throws DataStoreException {
        Object[] tableNames = new GenericName[resources.length];
        int tableCount = 0;
        Object[] queries = new ResourceDefinition[resources.length];
        int queryCount = 0;
        for (int i = 0; i < resources.length; ++i) {
            ResourceDefinition resource = resources[i];
            ArgumentChecks.ensureNonNullElement((String)"resources", (int)i, (Object)resource);
            GenericName name = resource.getName();
            int depth = name.depth();
            if (depth < 1 || depth > 3) {
                throw new IllegalNameException(Resources.format((short)3, name));
            }
            if (resource.query == null) {
                tableNames[tableCount++] = name;
                continue;
            }
            queries[queryCount++] = resource;
        }
        this.tableNames = (GenericName[])ArraysExt.resize((Object[])tableNames, (int)tableCount);
        this.queries = (ResourceDefinition[])ArraysExt.resize((Object[])queries, (int)queryCount);
    }

    protected void initialize(Connection connection) throws DataStoreException, SQLException {
    }

    public DataSource getDataSource() {
        return this.source;
    }

    public Optional<ParameterValueGroup> getOpenParameters() {
        if (this.provider == null) {
            return Optional.empty();
        }
        ParameterValueGroup pg = this.provider.getOpenParameters().createValue();
        pg.parameter("location").setValue((Object)this.source);
        return Optional.of(pg);
    }

    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.ofNullable(this.identifier);
    }

    final GenericName[] tableNames() {
        return this.tableNames;
    }

    final ResourceDefinition[] queries() {
        return this.queries;
    }

    final void clearModel() {
        this.model = null;
        this.metadata = null;
    }

    final Database<?> modelOrNull() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Database<?> model() throws DataStoreException {
        Database<?> current = this.model;
        if (current == null) {
            SQLStore sQLStore = this;
            synchronized (sQLStore) {
                try (Connection c = this.source.getConnection();){
                    current = this.model(c);
                }
                catch (Exception e) {
                    throw SQLStore.cannotExecute(e);
                }
            }
        }
        return current;
    }

    final Database<?> model(Connection c) throws Exception {
        assert (Thread.holdsLock((Object)this));
        Database<?> current = this.model;
        if (current == null) {
            this.initialize(c);
            DatabaseMetaData md = c.getMetaData();
            Analyzer analyzer = new Analyzer(this.source, md, this.geomLibrary, this.contentLocale, this.listeners, this.transactionLocks);
            current = analyzer.database;
            try (InfoStatements spatialInformation = current.createInfoStatements(c);){
                if (this.tableNames == null) {
                    DataAccess dao = this.newDataAccess(false);
                    dao.setConnection(c, spatialInformation);
                    this.setModelSources(this.readResourceDefinitions(dao));
                }
                current.analyze(this, analyzer, this.tableNames, this.queries, this.customizer, spatialInformation);
            }
            this.model = current;
        }
        return current;
    }

    public Map<String, Version> getDatabaseSoftwareVersions() throws DataStoreException {
        return this.model().getDatabaseSoftwareVersions();
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            MetadataBuilder builder = new MetadataBuilder();
            builder.addIdentifier(this.identifier, MetadataBuilder.Scope.RESOURCE);
            this.getDataSourceProperty(TITLE_GETTERS).ifPresent(arg_0 -> ((MetadataBuilder)builder).addTitle(arg_0));
            this.getDataSourceProperty(DETAILS_GETTERS).ifPresent(arg_0 -> ((MetadataBuilder)builder).addOtherCitationDetails(arg_0));
            try (Connection c = this.source.getConnection();){
                this.model(c).metadata(c.getMetaData(), builder);
            }
            catch (Exception e) {
                throw SQLStore.cannotExecute(e);
            }
            this.metadata = builder.buildAndFreeze();
        }
        return this.metadata;
    }

    private Optional<String> getDataSourceProperty(String[] methodNames) throws DataStoreException {
        for (String c : methodNames) {
            try {
                String name;
                Method method = this.source.getClass().getMethod(c, new Class[0]);
                if (method.getReturnType() != String.class || (name = Strings.trimOrNull((String)((String)method.invoke((Object)this.source, new Object[0])))) == null) continue;
                return Optional.of(name);
            }
            catch (NoSuchMethodException | SecurityException method) {
            }
            catch (ReflectiveOperationException e) {
                throw SQLStore.cannotExecute(e);
            }
        }
        return Optional.empty();
    }

    public Collection<? extends Resource> components() throws DataStoreException {
        return this.model().tables();
    }

    public Resource findResource(String identifier) throws DataStoreException {
        return this.model().findTable(this, identifier);
    }

    protected abstract ResourceDefinition[] readResourceDefinitions(DataAccess var1) throws DataStoreException;

    public DataAccess newDataAccess(boolean write) {
        return new DataAccess(this, write);
    }

    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    static DataStoreException cannotExecute(Exception cause) {
        Exception unwrap = Exceptions.unwrap((Exception)cause);
        if (unwrap instanceof DataStoreException) {
            return (DataStoreException)unwrap;
        }
        return new DataStoreException(cause.getMessage(), (Throwable)unwrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vacuum() throws DataStoreException {
        block19: {
            try (Connection c = this.source.getConnection();){
                String[] keywords = (String[])CharSequences.split((CharSequence)c.getMetaData().getSQLKeywords(), (char)',');
                if (!ArraysExt.containsIgnoreCase((String[])keywords, (String)"VACUUM")) break block19;
                Lock lock = null;
                if (this.transactionLocks != null) {
                    lock = this.transactionLocks.writeLock();
                    lock.lock();
                }
                try (Statement stmt = c.createStatement();){
                    stmt.executeUpdate("VACUUM");
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }
            catch (Exception e) {
                throw SQLStore.cannotExecute(e);
            }
        }
    }

    public synchronized void refresh() {
        this.clearModel();
        this.queries = null;
        this.tableNames = null;
    }

    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        this.clearModel();
    }
}

