/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.resilience4j.build;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.rule.Resilience4JHandle;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.resilience4j.conf.Resilience4JConf;

public final class Resilience4JBuilder {
    private Resilience4JBuilder() {
    }

    public static Resilience4JConf build(RuleData ruleData) {
        Resilience4JHandle handle = (Resilience4JHandle)GsonUtils.getGson().fromJson(ruleData.getHandle(), Resilience4JHandle.class);
        handle.checkData(handle);
        CircuitBreakerConfig circuitBreakerConfig = null;
        if (handle.getCircuitEnable() == 1) {
            circuitBreakerConfig = CircuitBreakerConfig.custom().recordExceptions(new Class[]{Throwable.class, Exception.class}).failureRateThreshold(handle.getFailureRateThreshold()).automaticTransitionFromOpenToHalfOpenEnabled(handle.getAutomaticTransitionFromOpenToHalfOpenEnabled().booleanValue()).slidingWindow(handle.getSlidingWindowSize(), handle.getMinimumNumberOfCalls(), handle.getSlidingWindowType() == 0 ? CircuitBreakerConfig.SlidingWindowType.COUNT_BASED : CircuitBreakerConfig.SlidingWindowType.TIME_BASED).waitIntervalFunctionInOpenState(IntervalFunction.of((Duration)Duration.ofMillis(handle.getWaitIntervalFunctionInOpenState()))).permittedNumberOfCallsInHalfOpenState(handle.getPermittedNumberOfCallsInHalfOpenState()).build();
        }
        TimeLimiterConfig timeLimiterConfig = TimeLimiterConfig.custom().timeoutDuration(Duration.ofMillis(handle.getTimeoutDuration())).build();
        RateLimiterConfig rateLimiterConfig = RateLimiterConfig.custom().limitForPeriod(handle.getLimitForPeriod()).timeoutDuration(Duration.ofMillis(handle.getTimeoutDurationRate())).limitRefreshPeriod(Duration.ofMillis(handle.getLimitRefreshPeriod())).build();
        return new Resilience4JConf(CacheKeyUtils.INST.getKey(ruleData), handle.getFallbackUri(), rateLimiterConfig, timeLimiterConfig, circuitBreakerConfig);
    }
}

