/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import java.util.List;
import org.apache.shenyu.admin.model.entity.RoleDO;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.role.BatchRoleDeletedEvent;
import org.apache.shenyu.admin.model.event.role.RoleCreatedEvent;
import org.apache.shenyu.admin.model.event.role.RoleUpdatedEvent;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class RoleEventPublisher
implements AdminDataModelChangedEventPublisher<RoleDO> {
    private final ApplicationEventPublisher publisher;

    public RoleEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void onCreated(RoleDO rule) {
        this.publish(new RoleCreatedEvent(rule, SessionUtil.visitorName()));
    }

    public void onUpdated(RoleDO rule, RoleDO before, List<String> permission) {
        this.publish(new RoleUpdatedEvent(rule, before, SessionUtil.visitorName(), permission));
    }

    @Override
    public void onDeleted(Collection<RoleDO> roles) {
        this.publish(new BatchRoleDeletedEvent(roles, SessionUtil.visitorName()));
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

