/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugin.router.canary;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.plugins.router.common.AbstractServiceRouter;
import java.util.List;
import java.util.stream.Collectors;

public class CanaryRouter
extends AbstractServiceRouter {
    private static final String canaryMetadataEnable = "internal-canary";

    @Override
    public RouteResult router(RouteInfo routeInfo, ServiceInstances instances) throws PolarisException {
        String canaryValue = routeInfo.getCanary();
        List<Instance> instanceList = !StringUtils.isBlank(canaryValue) ? instances.getInstances().stream().filter(instance -> MapUtils.isNotEmpty(instance.getMetadata()) && StringUtils.equals(canaryValue, instance.getMetadata().get("canary"))).collect(Collectors.toList()) : instances.getInstances().stream().filter(instance -> MapUtils.isEmpty(instance.getMetadata()) || !StringUtils.equals(canaryValue, instance.getMetadata().get("canary"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(instanceList)) {
            return new RouteResult(instances.getInstances(), RouteResult.State.Next);
        }
        return new RouteResult(instanceList, RouteResult.State.Next);
    }

    @Override
    public PluginType getType() {
        return PluginTypes.SERVICE_ROUTER.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
    }

    @Override
    public String getName() {
        return "canaryRouter";
    }

    @Override
    public ServiceRouter.Aspect getAspect() {
        return ServiceRouter.Aspect.MIDDLE;
    }

    @Override
    public boolean enable(RouteInfo routeInfo, ServiceMetadata dstSvcInfo) {
        if (!super.enable(routeInfo, dstSvcInfo)) {
            return false;
        }
        if (!dstSvcInfo.getMetadata().containsKey(canaryMetadataEnable)) {
            return false;
        }
        return Boolean.parseBoolean(dstSvcInfo.getMetadata().get(canaryMetadataEnable));
    }
}

