/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.netty;

import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.AbstractChannel;
import com.alipay.sofa.rpc.transport.netty.NettyBatchWriteQueue;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;

public class NettyChannel
extends AbstractChannel<ChannelHandlerContext, Channel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyChannel.class);
    private ChannelHandlerContext context;
    private Channel channel;
    private NettyBatchWriteQueue writeQueue;

    public NettyChannel(Channel channel) {
        this.channel = channel;
        this.writeQueue = NettyBatchWriteQueue.createWriteQueue(channel);
    }

    public NettyChannel(ChannelHandlerContext context) {
        this.context = context;
        this.channel = context.channel();
    }

    @Override
    public ChannelHandlerContext channelContext() {
        return this.context;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public void writeAndFlush(Object obj) {
        ChannelFuture future = this.writeQueue.enqueue(obj);
        future.addListener((GenericFutureListener)((FutureListener)future1 -> {
            if (!future1.isSuccess()) {
                Throwable throwable = future1.cause();
                LOGGER.error("Failed to send to " + NetUtils.channelToString(this.localAddress(), this.remoteAddress()) + " for msg : " + obj + ", Cause by:", throwable);
            }
        }));
    }

    @Override
    public boolean isAvailable() {
        return this.channel.isOpen() && this.channel.isActive();
    }

    @Deprecated
    public void setWriteQueue(NettyBatchWriteQueue writeQueue) {
        this.writeQueue = writeQueue;
    }
}

