/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul;

import com.alipay.sofa.rpc.registry.consul.ConsulConstants;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class ConsulRegistryProperties {
    private final Map<String, String> registryParameters;

    public ConsulRegistryProperties(Map<String, String> registryParameters) {
        if (registryParameters == null) {
            registryParameters = Collections.emptyMap();
        }
        this.registryParameters = registryParameters;
    }

    public int getHeartbeatInterval() {
        return this.getInt("heartbeat.interval", 3000);
    }

    public int getHeartbeatCoreSize() {
        return this.getInt("heartbeat.coreSize", 1);
    }

    public int getLookupInterval() {
        return this.getInt("lookup.interval", 1000);
    }

    public int getWatchTimeout() {
        return this.getInt("watch.timeout", 5);
    }

    public HealthCheckType getHealthCheckType() {
        return this.get("healthCheck.type", s -> HealthCheckType.valueOf(s.toUpperCase()), ConsulConstants.DEFAULT_HEALTH_CHECK_TYPE);
    }

    public String getHealthCheckTTL() {
        return this.getString("healthCheck.ttl", "10s");
    }

    public String getHealthCheckHost(String host) {
        return this.getString("healthCheck.host", host);
    }

    public int getHealthCheckPort(int port) {
        return this.getInt("healthCheck.port", port);
    }

    public String getHealthCheckTimeout() {
        return this.getString("healthCheck.timeout", "1s");
    }

    public String getHealthCheckInterval() {
        return this.getString("healthCheck.interval", "5s");
    }

    public String getHealthCheckProtocol() {
        return this.getString("healthCheck.protocol", "http");
    }

    public String getHealthCheckPath() {
        return this.getString("healthCheck.path", "/health");
    }

    public String getHealthCheckMethod() {
        return this.getString("healthCheck.method", "GET");
    }

    public String getToken() {
        return this.getString("token", "");
    }

    private int getInt(String key, int defaultValue) {
        return this.get(key, Integer::parseInt, defaultValue);
    }

    private String getString(String key, String defaultValue) {
        return this.get(key, Function.identity(), defaultValue);
    }

    private <T> T get(String key, Function<String, T> transform, T defaultValue) {
        String value = this.registryParameters.get(key);
        if (value != null) {
            return transform.apply(value);
        }
        return defaultValue;
    }

    public static enum HealthCheckType {
        TTL,
        TCP,
        HTTP;

    }
}

