/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.proxy.jdk;

import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.proxy.Proxy;
import com.alipay.sofa.rpc.proxy.jdk.JDKInvocationHandler;
import java.lang.reflect.InvocationHandler;

@Extension(value="jdk")
public class JDKProxy
implements Proxy {
    @Override
    public <T> T getProxy(Class<T> interfaceClass, Invoker proxyInvoker) {
        JDKInvocationHandler handler = new JDKInvocationHandler(interfaceClass, proxyInvoker);
        ClassLoader classLoader = ClassLoaderUtils.getCurrentClassLoader();
        Object result = java.lang.reflect.Proxy.newProxyInstance(classLoader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        return (T)result;
    }

    @Override
    public Invoker getInvoker(Object proxyObject) {
        return JDKProxy.parseInvoker(proxyObject);
    }

    public static Invoker parseInvoker(Object proxyObject) {
        InvocationHandler handler = java.lang.reflect.Proxy.getInvocationHandler(proxyObject);
        if (handler instanceof JDKInvocationHandler) {
            return ((JDKInvocationHandler)handler).getProxyInvoker();
        }
        return null;
    }
}

