/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.lb;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AbstractLoadBalancer;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.struct.PositiveAtomicCounter;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Extension(value="roundRobin")
public class RoundRobinLoadBalancer
extends AbstractLoadBalancer {
    private final ConcurrentMap<String, PositiveAtomicCounter> sequences = new ConcurrentHashMap<String, PositiveAtomicCounter>();

    public RoundRobinLoadBalancer(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    public ProviderInfo doSelect(SofaRequest request, List<ProviderInfo> providerInfos) {
        String key = this.getServiceKey(request);
        int length = providerInfos.size();
        PositiveAtomicCounter sequence = (PositiveAtomicCounter)this.sequences.get(key);
        if (sequence == null) {
            this.sequences.putIfAbsent(key, new PositiveAtomicCounter());
            sequence = (PositiveAtomicCounter)this.sequences.get(key);
        }
        return providerInfos.get(sequence.getAndIncrement() % length);
    }

    private String getServiceKey(SofaRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getTargetAppName()).append("#").append(request.getMethodName());
        return builder.toString();
    }
}

