/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.infra.redis;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.shenyu.common.enums.RedisModeEnum;
import org.apache.shenyu.infra.redis.RedisConfigProperties;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisConnectionFactory {
    private final LettuceConnectionFactory lettuceConnectionFactory;

    public RedisConnectionFactory(RedisConfigProperties redisConfigProperties) {
        this.lettuceConnectionFactory = this.createLettuceConnectionFactory(redisConfigProperties);
        this.lettuceConnectionFactory.afterPropertiesSet();
    }

    public LettuceConnectionFactory getLettuceConnectionFactory() {
        return this.lettuceConnectionFactory;
    }

    private LettuceConnectionFactory createLettuceConnectionFactory(RedisConfigProperties redisConfigProperties) {
        LettuceClientConfiguration lettuceClientConfiguration = this.getLettuceClientConfiguration(redisConfigProperties);
        if (RedisModeEnum.SENTINEL.getName().equals(redisConfigProperties.getMode())) {
            return new LettuceConnectionFactory(this.redisSentinelConfiguration(redisConfigProperties), lettuceClientConfiguration);
        }
        if (RedisModeEnum.CLUSTER.getName().equals(redisConfigProperties.getMode())) {
            return new LettuceConnectionFactory(this.redisClusterConfiguration(redisConfigProperties), lettuceClientConfiguration);
        }
        return new LettuceConnectionFactory(this.redisStandaloneConfiguration(redisConfigProperties), lettuceClientConfiguration);
    }

    private LettuceClientConfiguration getLettuceClientConfiguration(RedisConfigProperties redisConfigProperties) {
        return LettucePoolingClientConfiguration.builder().poolConfig(this.getPoolConfig(redisConfigProperties)).build();
    }

    private GenericObjectPoolConfig<?> getPoolConfig(RedisConfigProperties redisConfigProperties) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(redisConfigProperties.getMaxActive().intValue());
        config.setMaxIdle(redisConfigProperties.getMaxIdle());
        config.setMinIdle(redisConfigProperties.getMinIdle().intValue());
        if (Objects.nonNull(redisConfigProperties.getMaxWait())) {
            config.setMaxWait(Duration.ofMillis(redisConfigProperties.getMaxWait().toMillis()));
        }
        return config;
    }

    protected final RedisStandaloneConfiguration redisStandaloneConfiguration(RedisConfigProperties redisConfigProperties) {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        String[] parts = StringUtils.split((String)redisConfigProperties.getUrl(), (String)":");
        Objects.requireNonNull(parts);
        config.setHostName(parts[0]);
        config.setPort(Integer.parseInt(parts[1]));
        if (Objects.nonNull(redisConfigProperties.getPassword())) {
            config.setPassword(RedisPassword.of((String)redisConfigProperties.getPassword()));
        }
        config.setDatabase(redisConfigProperties.getDatabase().intValue());
        return config;
    }

    private RedisClusterConfiguration redisClusterConfiguration(RedisConfigProperties redisConfigProperties) {
        RedisClusterConfiguration config = new RedisClusterConfiguration();
        config.setClusterNodes(this.createRedisNode(redisConfigProperties.getUrl()));
        if (Objects.nonNull(redisConfigProperties.getPassword())) {
            config.setPassword(RedisPassword.of((String)redisConfigProperties.getPassword()));
        }
        return config;
    }

    private RedisSentinelConfiguration redisSentinelConfiguration(RedisConfigProperties redisConfigProperties) {
        RedisSentinelConfiguration config = new RedisSentinelConfiguration();
        config.master(redisConfigProperties.getMaster());
        config.setSentinels(this.createRedisNode(redisConfigProperties.getUrl()));
        if (Objects.nonNull(redisConfigProperties.getPassword())) {
            config.setPassword(RedisPassword.of((String)redisConfigProperties.getPassword()));
        }
        config.setDatabase(redisConfigProperties.getDatabase().intValue());
        return config;
    }

    private List<RedisNode> createRedisNode(String url) {
        ArrayList<RedisNode> redisNodes = new ArrayList<RedisNode>();
        ArrayList nodes = Lists.newArrayList((Iterable)Splitter.on((String)";").split((CharSequence)url));
        for (String node : nodes) {
            String[] parts = StringUtils.split((String)node, (String)":");
            Assert.state((Objects.requireNonNull(parts).length == 2 ? 1 : 0) != 0, (String)"Must be defined as 'host:port'");
            redisNodes.add(new RedisNode(parts[0], Integer.parseInt(parts[1])));
        }
        return redisNodes;
    }
}

