/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.security.cert;

import java.nio.charset.StandardCharsets;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.ssl.AuthPolicy;
import org.apache.dubbo.common.ssl.Cert;
import org.apache.dubbo.common.ssl.CertProvider;
import org.apache.dubbo.common.ssl.ProviderCert;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.security.cert.CertPair;
import org.apache.dubbo.security.cert.DubboCertManager;

@Activate
public class DubboCertProvider
implements CertProvider {
    private final DubboCertManager dubboCertManager;

    public DubboCertProvider(FrameworkModel frameworkModel) {
        this.dubboCertManager = frameworkModel.getBeanFactory().getBean(DubboCertManager.class);
    }

    @Override
    public boolean isSupport(URL address) {
        return this.dubboCertManager != null && this.dubboCertManager.isConnected();
    }

    @Override
    public ProviderCert getProviderConnectionConfig(URL localAddress) {
        CertPair certPair = this.dubboCertManager.generateCert();
        if (certPair == null) {
            return null;
        }
        return new ProviderCert(certPair.getCertificate().getBytes(StandardCharsets.UTF_8), certPair.getPrivateKey().getBytes(StandardCharsets.UTF_8), certPair.getTrustCerts().getBytes(StandardCharsets.UTF_8), AuthPolicy.NONE);
    }

    @Override
    public Cert getConsumerConnectionConfig(URL remoteAddress) {
        CertPair certPair = this.dubboCertManager.generateCert();
        if (certPair == null) {
            return null;
        }
        return new Cert(certPair.getCertificate().getBytes(StandardCharsets.UTF_8), certPair.getPrivateKey().getBytes(StandardCharsets.UTF_8), certPair.getTrustCerts().getBytes(StandardCharsets.UTF_8));
    }
}

