/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.configurator.parser.model;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.cluster.configurator.parser.model.ParamMatch;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.AddressMatch;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.ListStringMatch;

public class ConditionMatch {
    private AddressMatch address;
    private AddressMatch providerAddress;
    private ListStringMatch service;
    private ListStringMatch app;
    private List<ParamMatch> param;

    public AddressMatch getAddress() {
        return this.address;
    }

    public void setAddress(AddressMatch address) {
        this.address = address;
    }

    public AddressMatch getProviderAddress() {
        return this.providerAddress;
    }

    public void setProviderAddress(AddressMatch providerAddress) {
        this.providerAddress = providerAddress;
    }

    public ListStringMatch getService() {
        return this.service;
    }

    public void setService(ListStringMatch service) {
        this.service = service;
    }

    public ListStringMatch getApp() {
        return this.app;
    }

    public void setApp(ListStringMatch app) {
        this.app = app;
    }

    public List<ParamMatch> getParam() {
        return this.param;
    }

    public void setParam(List<ParamMatch> param) {
        this.param = param;
    }

    public boolean isMatch(String host, URL url) {
        if (this.getAddress() != null && !this.getAddress().isMatch(host)) {
            return false;
        }
        if (this.getProviderAddress() != null && !this.getProviderAddress().isMatch(url.getAddress())) {
            return false;
        }
        if (this.getService() != null && !this.getService().isMatch(url.getServiceKey())) {
            return false;
        }
        if (this.getApp() != null && !this.getApp().isMatch(url.getParameter("application"))) {
            return false;
        }
        if (this.getParam() != null) {
            for (ParamMatch match : this.param) {
                if (match.isMatch(url)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "ConditionMatch{address='" + this.address + '\'' + "providerAddress='" + this.providerAddress + '\'' + ", service='" + this.service + '\'' + ", app='" + this.app + '\'' + ", param='" + this.param + '\'' + '}';
    }
}

