/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AnnotationUtils {
    public static final String ANNOTATED_ELEMENT_UTILS_CLASS_NAME = "org.springframework.core.annotation.AnnotatedElementUtils";
    private static final Map<Integer, Boolean> annotatedElementUtilsPresentCache = new ConcurrentHashMap<Integer, Boolean>();

    public static Map<String, Object> getAttributes(Annotation annotation, PropertyResolver propertyResolver, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAttributes(annotation, propertyResolver, false, false, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static Map<String, Object> getAttributes(Map<String, Object> annotationAttributes, PropertyResolver propertyResolver, String ... ignoreAttributeNames) {
        HashSet<String> ignoreAttributeNamesSet = new HashSet<String>(Arrays.asList(ignoreAttributeNames));
        LinkedHashMap<String, Object> actualAttributes = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> annotationAttribute : annotationAttributes.entrySet()) {
            String attributeName = annotationAttribute.getKey();
            String[] attributeValue = annotationAttribute.getValue();
            if (ignoreAttributeNamesSet.contains(attributeName)) continue;
            if (attributeValue instanceof String) {
                attributeValue = AnnotationUtils.resolvePlaceholders(String.valueOf(attributeValue), propertyResolver);
            } else if (attributeValue instanceof String[]) {
                String[] values = attributeValue;
                for (int i = 0; i < values.length; ++i) {
                    values[i] = AnnotationUtils.resolvePlaceholders(values[i], propertyResolver);
                }
                attributeValue = values;
            }
            actualAttributes.put(attributeName, attributeValue);
        }
        return actualAttributes;
    }

    public static Map<String, Object> getAttributes(Annotation annotation, PropertyResolver propertyResolver, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        AnnotationAttributes annotationAttributes = org.springframework.core.annotation.AnnotationUtils.getAnnotationAttributes((Annotation)annotation, (boolean)classValuesAsString, (boolean)nestedAnnotationsAsMap);
        String[] actualIgnoreAttributeNames = ignoreAttributeNames;
        if (ignoreDefaultValue && !CollectionUtils.isEmpty((Map)annotationAttributes)) {
            LinkedList<String> attributeNamesToIgnore = new LinkedList<String>(Arrays.asList(ignoreAttributeNames));
            for (Map.Entry annotationAttribute : annotationAttributes.entrySet()) {
                String attributeName = (String)annotationAttribute.getKey();
                Object attributeValue = annotationAttribute.getValue();
                if (!ObjectUtils.nullSafeEquals(attributeValue, (Object)org.springframework.core.annotation.AnnotationUtils.getDefaultValue((Annotation)annotation, (String)attributeName))) continue;
                attributeNamesToIgnore.add(attributeName);
            }
            actualIgnoreAttributeNames = attributeNamesToIgnore.toArray(new String[attributeNamesToIgnore.size()]);
        }
        return AnnotationUtils.getAttributes((Map<String, Object>)annotationAttributes, propertyResolver, actualIgnoreAttributeNames);
    }

    private static String resolvePlaceholders(String attributeValue, PropertyResolver propertyResolver) {
        String resolvedValue = attributeValue;
        if (propertyResolver != null) {
            resolvedValue = propertyResolver.resolvePlaceholders(resolvedValue);
            resolvedValue = StringUtils.trimWhitespace((String)resolvedValue);
        }
        return resolvedValue;
    }

    public static <T> T getAttribute(Map<String, Object> attributes, String attributeName) {
        return AnnotationUtils.getAttribute(attributes, attributeName, false);
    }

    public static <T> T getAttribute(Map<String, Object> attributes, String attributeName, boolean required) {
        T value = AnnotationUtils.getAttribute(attributes, attributeName, null);
        if (required && value == null) {
            throw new IllegalStateException("The attribute['" + attributeName + "] is required!");
        }
        return value;
    }

    public static <T> T getAttribute(Map<String, Object> attributes, String attributeName, T defaultValue) {
        Object value = attributes.get(attributeName);
        return (T)(value == null ? defaultValue : value);
    }

    public static <T> T getRequiredAttribute(Map<String, Object> attributes, String attributeName) {
        return AnnotationUtils.getAttribute(attributes, attributeName, true);
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAnnotationAttributes(annotation, null, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation, PropertyResolver propertyResolver, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationAttributes.fromMap(AnnotationUtils.getAttributes(annotation, propertyResolver, classValuesAsString, nestedAnnotationsAsMap, ignoreDefaultValue, ignoreAttributeNames));
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation, PropertyResolver propertyResolver, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAnnotationAttributes(annotation, propertyResolver, false, false, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        Annotation annotation = annotatedElement.getAnnotation(annotationType);
        return annotation == null ? null : AnnotationUtils.getAnnotationAttributes(annotation, propertyResolver, classValuesAsString, nestedAnnotationsAsMap, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean ignoreDefaultValue, boolean tryMergedAnnotation, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAnnotationAttributes(annotatedElement, annotationType, propertyResolver, false, false, ignoreDefaultValue, tryMergedAnnotation, ignoreAttributeNames);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean ignoreDefaultValue, boolean tryMergedAnnotation, String ... ignoreAttributeNames) {
        AnnotationAttributes attributes = null;
        if (tryMergedAnnotation) {
            attributes = AnnotationUtils.tryGetMergedAnnotationAttributes(annotatedElement, annotationType, propertyResolver, classValuesAsString, nestedAnnotationsAsMap, ignoreDefaultValue, ignoreAttributeNames);
        }
        if (attributes == null) {
            attributes = AnnotationUtils.getAnnotationAttributes(annotatedElement, annotationType, propertyResolver, classValuesAsString, nestedAnnotationsAsMap, ignoreDefaultValue, ignoreAttributeNames);
        }
        return attributes;
    }

    public static Annotation tryGetMergedAnnotation(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        Annotation mergedAnnotation = null;
        ClassLoader classLoader = annotationType.getClassLoader();
        if (annotatedElementUtilsPresentCache.computeIfAbsent(System.identityHashCode(classLoader), _k -> ClassUtils.isPresent((String)ANNOTATED_ELEMENT_UTILS_CLASS_NAME, (ClassLoader)classLoader)).booleanValue()) {
            Class annotatedElementUtilsClass = ClassUtils.resolveClassName((String)ANNOTATED_ELEMENT_UTILS_CLASS_NAME, (ClassLoader)classLoader);
            Method getMergedAnnotationMethod = ReflectionUtils.findMethod((Class)annotatedElementUtilsClass, (String)"getMergedAnnotation", (Class[])new Class[]{AnnotatedElement.class, Class.class});
            if (getMergedAnnotationMethod != null) {
                mergedAnnotation = (Annotation)ReflectionUtils.invokeMethod((Method)getMergedAnnotationMethod, null, (Object[])new Object[]{annotatedElement, annotationType});
            }
        }
        return mergedAnnotation;
    }

    public static AnnotationAttributes tryGetMergedAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        Annotation annotation = AnnotationUtils.tryGetMergedAnnotation(annotatedElement, annotationType, classValuesAsString, nestedAnnotationsAsMap);
        return annotation == null ? null : AnnotationUtils.getAnnotationAttributes(annotation, propertyResolver, classValuesAsString, nestedAnnotationsAsMap, ignoreDefaultValue, ignoreAttributeNames);
    }
}

