/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.healthy;

import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.InstanceResource;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.circuitbreak.api.flow.CircuitBreakerFlow;
import com.tencent.polaris.circuitbreak.api.pojo.CheckResult;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.plugins.router.common.AbstractServiceRouter;
import com.tencent.polaris.plugins.router.healthy.RecoverRouterConfig;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RecoverRouter
extends AbstractServiceRouter
implements PluginConfigProvider {
    private RecoverRouterConfig recoverRouterConfig;

    @Override
    public RouteResult router(final RouteInfo routeInfo, ServiceInstances instances) throws PolarisException {
        List<Instance> healthyInstance = this.isExcludeCircuitBreakInstances(routeInfo) ? instances.getInstances().stream().filter(new Predicate<Instance>(){

            @Override
            public boolean test(Instance instance) {
                if (!Utils.isHealthyInstance(instance)) {
                    return false;
                }
                return RecoverRouter.this.checkCircuitBreakerPassing(routeInfo, instance);
            }
        }).collect(Collectors.toList()) : instances.getInstances().stream().filter(Utils::isHealthyInstance).collect(Collectors.toList());
        int healthyInstanceCount = healthyInstance.size();
        if (healthyInstanceCount == 0) {
            return new RouteResult(instances.getInstances(), RouteResult.State.Next);
        }
        return new RouteResult(healthyInstance, RouteResult.State.Next);
    }

    private boolean isExcludeCircuitBreakInstances(RouteInfo routeInfo) {
        if (routeInfo.isIncludeCircuitBreakInstances()) {
            return false;
        }
        return this.recoverRouterConfig.isExcludeCircuitBreakInstances();
    }

    @Override
    public PluginType getType() {
        return PluginTypes.SERVICE_ROUTER.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
        this.recoverRouterConfig = ctx.getConfig().getConsumer().getServiceRouter().getPluginConfig(this.getName(), RecoverRouterConfig.class);
    }

    @Override
    public Class<? extends Verifier> getPluginConfigClazz() {
        return RecoverRouterConfig.class;
    }

    @Override
    public String getName() {
        return "recoverRouter";
    }

    @Override
    public ServiceRouter.Aspect getAspect() {
        return ServiceRouter.Aspect.AFTER;
    }

    @Override
    public boolean enable(RouteInfo routeInfo, ServiceMetadata dstSvcInfo) {
        return true;
    }

    private boolean checkCircuitBreakerPassing(RouteInfo routeInfo, Instance instance) {
        CircuitBreakerStatus circuitBreakerStatus = instance.getCircuitBreakerStatus();
        if (null != circuitBreakerStatus) {
            return circuitBreakerStatus.getStatus() != CircuitBreakerStatus.Status.OPEN;
        }
        ServiceKey sourceService = null;
        if (null != routeInfo.getSourceService()) {
            sourceService = routeInfo.getSourceService().getServiceKey();
        }
        InstanceResource resource = new InstanceResource(new ServiceKey(instance.getNamespace(), instance.getService()), instance.getHost(), instance.getPort(), sourceService);
        CircuitBreakerFlow circuitBreakerFlow = (CircuitBreakerFlow)this.extensions.getValueContext().getValue(CircuitBreakerFlow.class.getCanonicalName());
        if (null != circuitBreakerFlow) {
            CheckResult check2 = circuitBreakerFlow.check(resource);
            return check2.isPass();
        }
        return true;
    }
}

