/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.netty;

import java.security.Security;
import java.util.Optional;
import org.apache.pulsar.shade.io.netty.resolver.dns.DnsNameResolverBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsResolverUtil {
    private static final Logger log = LoggerFactory.getLogger(DnsResolverUtil.class);
    private static final String CACHE_POLICY_PROP = "networkaddress.cache.ttl";
    private static final String CACHE_POLICY_PROP_FALLBACK = "sun.net.inetaddr.ttl";
    private static final String NEGATIVE_CACHE_POLICY_PROP = "networkaddress.cache.negative.ttl";
    private static final String NEGATIVE_CACHE_POLICY_PROP_FALLBACK = "sun.net.inetaddr.negative.ttl";
    private static final int JDK_DEFAULT_TTL = 30;
    private static final int MIN_TTL = 0;
    private static final int TTL;
    private static final int NEGATIVE_TTL;
    private static final int DEFAULT_TTL = 60;
    private static final int DEFAULT_NEGATIVE_TTL = 10;

    private DnsResolverUtil() {
    }

    public static void applyJdkDnsCacheSettings(DnsNameResolverBuilder dnsNameResolverBuilder) {
        dnsNameResolverBuilder.ttl(0, TTL);
        dnsNameResolverBuilder.negativeTtl(NEGATIVE_TTL);
    }

    static {
        int ttl = 60;
        int negativeTtl = 10;
        try {
            String negativeTtlStr;
            String ttlStr = Security.getProperty(CACHE_POLICY_PROP);
            if (ttlStr == null) {
                ttlStr = System.getProperty(CACHE_POLICY_PROP_FALLBACK);
            }
            if ((negativeTtlStr = Security.getProperty(NEGATIVE_CACHE_POLICY_PROP)) == null) {
                negativeTtlStr = System.getProperty(NEGATIVE_CACHE_POLICY_PROP_FALLBACK);
            }
            ttl = Optional.ofNullable(ttlStr).map(Integer::decode).filter(i -> i > 0).orElseGet(() -> {
                if (System.getSecurityManager() == null) {
                    return 30;
                }
                return 60;
            });
            negativeTtl = Optional.ofNullable(negativeTtlStr).map(Integer::decode).filter(i -> i >= 0).orElse(10);
        }
        catch (NumberFormatException e) {
            log.warn("Cannot get DNS TTL settings", (Throwable)e);
        }
        TTL = ttl;
        NEGATIVE_TTL = negativeTtl;
    }
}

