/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.MessageIdAdvUtils;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroQueueConsumerImpl<T>
extends ConsumerImpl<T> {
    private static final Logger log = LoggerFactory.getLogger(ZeroQueueConsumerImpl.class);
    private final Lock zeroQueueLock = new ReentrantLock();
    private volatile boolean waitingOnReceiveForZeroQueueSize = false;
    private volatile boolean waitingOnListenerForZeroQueueSize = false;

    public ZeroQueueConsumerImpl(PulsarClientImpl client, String topic, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, int partitionIndex, boolean hasParentConsumer, CompletableFuture<Consumer<T>> subscribeFuture, MessageId startMessageId, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        super(client, topic, conf, executorProvider, partitionIndex, hasParentConsumer, false, subscribeFuture, startMessageId, 0L, schema, interceptors, createTopicIfDoesNotExist);
    }

    @Override
    public int minReceiverQueueSize() {
        return 0;
    }

    @Override
    public void initReceiverQueueSize() {
        if (this.conf.isAutoScaledReceiverQueueSizeEnabled()) {
            throw new NotImplementedException("AutoScaledReceiverQueueSize is not supported in ZeroQueueConsumerImpl");
        }
        CURRENT_RECEIVER_QUEUE_SIZE_UPDATER.set(this, 0);
    }

    @Override
    protected Message<T> internalReceive() throws PulsarClientException {
        this.zeroQueueLock.lock();
        try {
            Message<T> msg = this.fetchSingleMessageFromBroker();
            this.trackMessage(msg);
            Message<T> message = this.beforeConsume(msg);
            return message;
        }
        finally {
            this.zeroQueueLock.unlock();
        }
    }

    @Override
    protected CompletableFuture<Message<T>> internalReceiveAsync() {
        CompletableFuture future = super.internalReceiveAsync();
        if (!future.isDone()) {
            this.increaseAvailablePermits(this.cnx());
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message<T> fetchSingleMessageFromBroker() throws PulsarClientException {
        if (this.incomingMessages.size() > 0) {
            log.error("The incoming message queue should never be greater than 0 when Queue size is 0");
            this.incomingMessages.forEach(Message::release);
            this.incomingMessages.clear();
        }
        try {
            ClientCnx msgCnx;
            Message message;
            this.waitingOnReceiveForZeroQueueSize = true;
            ZeroQueueConsumerImpl zeroQueueConsumerImpl = this;
            synchronized (zeroQueueConsumerImpl) {
                if (this.isConnected()) {
                    this.increaseAvailablePermits(this.cnx());
                }
            }
            while (true) {
                message = (Message)this.incomingMessages.take();
                this.lastDequeuedMessageId = message.getMessageId();
                msgCnx = ((MessageImpl)message).getCnx();
                ZeroQueueConsumerImpl zeroQueueConsumerImpl2 = this;
                synchronized (zeroQueueConsumerImpl2) {
                    if (msgCnx == this.cnx()) {
                        this.waitingOnReceiveForZeroQueueSize = false;
                        break;
                    }
                }
            }
            this.stats.updateNumMsgsReceived(message);
            msgCnx = message;
            return msgCnx;
        }
        catch (InterruptedException e) {
            this.stats.incrementNumReceiveFailed();
            throw PulsarClientException.unwrap((Throwable)e);
        }
        finally {
            this.waitingOnReceiveForZeroQueueSize = false;
            this.incomingMessages.clear();
        }
    }

    @Override
    protected void consumerIsReconnectedToBroker(ClientCnx cnx, int currentQueueSize) {
        super.consumerIsReconnectedToBroker(cnx, currentQueueSize);
        if (this.waitingOnReceiveForZeroQueueSize || currentQueueSize > 0 || this.listener != null && !this.waitingOnListenerForZeroQueueSize) {
            this.increaseAvailablePermits(cnx);
        }
    }

    @Override
    protected boolean canEnqueueMessage(Message<T> message) {
        if (this.listener != null) {
            this.triggerZeroQueueSizeListener(message);
            return false;
        }
        return true;
    }

    private void triggerZeroQueueSizeListener(Message<T> message) {
        Objects.requireNonNull(this.listener, "listener can't be null");
        Objects.requireNonNull(message, "unqueued message can't be null");
        this.externalPinnedExecutor.execute(() -> {
            this.stats.updateNumMsgsReceived(message);
            try {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Calling message listener for unqueued message {}", new Object[]{this.topic, this.subscription, message.getMessageId()});
                }
                this.waitingOnListenerForZeroQueueSize = true;
                this.trackMessage(message);
                this.unAckedMessageTracker.add(MessageIdAdvUtils.discardBatch(message.getMessageId()), message.getRedeliveryCount());
                this.listener.received((Consumer)this, this.beforeConsume(message));
            }
            catch (Throwable t2) {
                log.error("[{}][{}] Message listener error in processing unqueued message: {}", new Object[]{this.topic, this.subscription, message.getMessageId(), t2});
            }
            this.increaseAvailablePermits(this.cnx());
            this.waitingOnListenerForZeroQueueSize = false;
        });
    }

    @Override
    protected void tryTriggerListener() {
    }

    @Override
    void receiveIndividualMessagesFromBatch(BrokerEntryMetadata brokerEntryMetadata, MessageMetadata msgMetadata, int redeliveryCount, List<Long> ackSet, ByteBuf uncompressedPayload, MessageIdData messageId, ClientCnx cnx, long consumerEpoch) {
        log.warn("Closing consumer [{}]-[{}] due to unsupported received batch-message with zero receiver queue size", (Object)this.subscription, (Object)this.consumerName);
        this.closeAsync().handle((ok, e) -> {
            this.notifyPendingReceivedCallback(null, (Exception)new PulsarClientException.InvalidMessageException(String.format("Unsupported Batch message with 0 size receiver queue for [%s]-[%s] ", this.subscription, this.consumerName)));
            return null;
        });
    }

    @Override
    protected void setCurrentReceiverQueueSize(int newSize) {
        throw new NotImplementedException("Receiver queue size can't be changed in ZeroQueueConsumerImpl");
    }
}

