/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.global;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.context.ShenyuContextBuilder;
import org.apache.shenyu.plugin.api.context.ShenyuContextDecorator;
import org.apache.shenyu.plugin.base.cache.CommonDiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.plugin.base.cache.CommonProxySelectorDataSubscriber;
import org.apache.shenyu.plugin.base.handler.DiscoveryUpstreamDataHandler;
import org.apache.shenyu.plugin.base.handler.ProxySelectorDataHandler;
import org.apache.shenyu.plugin.global.DefaultShenyuContextBuilder;
import org.apache.shenyu.plugin.global.GlobalPlugin;
import org.apache.shenyu.plugin.global.subsciber.MetaDataCacheSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={GlobalPlugin.class})
public class GlobalPluginConfiguration {
    @Bean
    public ShenyuPlugin globalPlugin(ShenyuContextBuilder shenyuContextBuilder) {
        return new GlobalPlugin(shenyuContextBuilder);
    }

    @Bean
    @ConditionalOnMissingBean(value={ShenyuContextBuilder.class}, search=SearchStrategy.ALL)
    public ShenyuContextBuilder shenyuContextBuilder(ObjectProvider<List<ShenyuContextDecorator>> decorators) {
        List decoratorList = (List)decorators.getIfAvailable(Collections::emptyList);
        Map<String, ShenyuContextDecorator> decoratorMap = decoratorList.stream().collect(Collectors.toMap(ShenyuContextDecorator::rpcType, e -> e));
        return new DefaultShenyuContextBuilder(decoratorMap);
    }

    @Bean
    public MetaDataSubscriber metaDataCacheSubscriber() {
        return new MetaDataCacheSubscriber();
    }

    @Bean
    public ProxySelectorDataSubscriber proxySelectorDataSubscriber(ObjectProvider<List<ProxySelectorDataHandler>> proxySelectorDataHandlers) {
        List proxySelectorDataHandlerList = (List)proxySelectorDataHandlers.getIfAvailable(Collections::emptyList);
        return new CommonProxySelectorDataSubscriber(proxySelectorDataHandlerList);
    }

    @Bean
    public DiscoveryUpstreamDataSubscriber discoveryUpstreamDataHandler(ObjectProvider<List<DiscoveryUpstreamDataHandler>> discoveryUpstreamDataHandlers) {
        List proxySelectorDataHandlerList = (List)discoveryUpstreamDataHandlers.getIfAvailable(Collections::emptyList);
        return new CommonDiscoveryUpstreamDataSubscriber(proxySelectorDataHandlerList);
    }
}

