/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.grpc.message;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ExtensionRegistryLite;
import io.grpc.MethodDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.ParamCheckUtils;
import org.apache.shenyu.protocol.grpc.constant.GrpcConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMessage {
    private static final Logger LOG = LoggerFactory.getLogger(JsonMessage.class);
    private static final Map<String, MethodDescriptor<DynamicMessage, DynamicMessage>> METHOD_DESCRIPTOR_CACHE = Maps.newConcurrentMap();

    private static Descriptors.Descriptor buildJsonMarshallerDescriptor() {
        DescriptorProtos.DescriptorProto.Builder jsonMarshaller = DescriptorProtos.DescriptorProto.newBuilder();
        jsonMarshaller.setName("JsonMessage");
        jsonMarshaller.addFieldBuilder().setName("data").setNumber(1).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        DescriptorProtos.FileDescriptorProto.Builder fileDescriptorProtoBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
        fileDescriptorProtoBuilder.addMessageType(jsonMarshaller);
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = fileDescriptorProtoBuilder.build();
        try {
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
            return fileDescriptor.findMessageTypeByName("JsonMessage");
        }
        catch (Descriptors.DescriptorValidationException e) {
            LOG.error("dynamic build JsonMarshaller descriptor is fail: {}", (Object)e.getMessage());
            throw new RuntimeException("dynamic build JsonMarshaller descriptor is fail", e);
        }
    }

    public static List<DynamicMessage> buildJsonMessageList(Map<String, Object> jsonParamMap) {
        ParamCheckUtils.checkParamsLength((Integer)jsonParamMap.size(), (Integer)GrpcConstants.JSON_DESCRIPTOR_PROTO_FIELD_NUM);
        JsonArray jsonParams = (JsonArray)jsonParamMap.get("data");
        ArrayList<DynamicMessage> jsonMessageList = new ArrayList<DynamicMessage>(jsonParams.size());
        jsonParams.forEach(jsonParam -> {
            DynamicMessage jsonMessage = JsonMessage.buildJsonMessage(GsonUtils.getInstance().toJson(jsonParam));
            jsonMessageList.add(jsonMessage);
        });
        return jsonMessageList;
    }

    public static DynamicMessage buildJsonMessage(String jsonParam) {
        Descriptors.Descriptor jsonDescriptor = JsonMessage.buildJsonMarshallerDescriptor();
        DynamicMessage.Builder jsonDynamicMessage = DynamicMessage.newBuilder((Descriptors.Descriptor)jsonDescriptor);
        jsonDynamicMessage.setField(jsonDescriptor.findFieldByName("data"), (Object)jsonParam);
        return jsonDynamicMessage.build();
    }

    public static DynamicMessage buildJsonMessage() {
        Descriptors.Descriptor jsonDescriptor = JsonMessage.buildJsonMarshallerDescriptor();
        DynamicMessage.Builder jsonDynamicMessage = DynamicMessage.newBuilder((Descriptors.Descriptor)jsonDescriptor);
        return jsonDynamicMessage.build();
    }

    public static String getDataFromDynamicMessage(DynamicMessage message) {
        for (Map.Entry entry : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor key = (Descriptors.FieldDescriptor)entry.getKey();
            Object value = entry.getValue();
            String jsonMessageFullName = "JsonMessage.data";
            String fullName = key.getFullName();
            if (!jsonMessageFullName.equals(fullName)) continue;
            return (String)value;
        }
        return "";
    }

    public static MethodDescriptor<DynamicMessage, DynamicMessage> createJsonMarshallerMethodDescriptor(String serviceName, String methodName, MethodDescriptor.MethodType methodType, DynamicMessage request, DynamicMessage response) {
        MethodDescriptor methodDescriptor = METHOD_DESCRIPTOR_CACHE.get(serviceName + "JSON" + methodName);
        if (Objects.isNull(methodDescriptor)) {
            methodDescriptor = MethodDescriptor.newBuilder().setType(JsonMessage.getMethodType(methodType)).setFullMethodName(MethodDescriptor.generateFullMethodName((String)(serviceName + "JSON"), (String)methodName)).setRequestMarshaller((MethodDescriptor.Marshaller)new DynamicMessageMarshaller(request.getDescriptorForType())).setResponseMarshaller((MethodDescriptor.Marshaller)new DynamicMessageMarshaller(response.getDescriptorForType())).build();
            METHOD_DESCRIPTOR_CACHE.put(serviceName + "JSON" + methodName, (MethodDescriptor<DynamicMessage, DynamicMessage>)methodDescriptor);
        }
        return methodDescriptor;
    }

    private static MethodDescriptor.MethodType getMethodType(MethodDescriptor.MethodType methodType) {
        return switch (methodType) {
            case MethodDescriptor.MethodType.UNARY -> MethodDescriptor.MethodType.UNARY;
            case MethodDescriptor.MethodType.CLIENT_STREAMING -> MethodDescriptor.MethodType.CLIENT_STREAMING;
            case MethodDescriptor.MethodType.SERVER_STREAMING -> MethodDescriptor.MethodType.SERVER_STREAMING;
            case MethodDescriptor.MethodType.BIDI_STREAMING -> MethodDescriptor.MethodType.BIDI_STREAMING;
            default -> MethodDescriptor.MethodType.UNKNOWN;
        };
    }

    private static final class DynamicMessageMarshaller
    implements MethodDescriptor.Marshaller<DynamicMessage> {
        private final Descriptors.Descriptor messageDescriptor;

        private DynamicMessageMarshaller(Descriptors.Descriptor messageDescriptor) {
            this.messageDescriptor = messageDescriptor;
        }

        public DynamicMessage parse(InputStream inputStream) {
            try {
                return ((DynamicMessage.Builder)DynamicMessage.newBuilder((Descriptors.Descriptor)this.messageDescriptor).mergeFrom(inputStream, ExtensionRegistryLite.getEmptyRegistry())).build();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to merge from the supplied input stream", e);
            }
        }

        public InputStream stream(DynamicMessage abstractMessage) {
            return abstractMessage.toByteString().newInput();
        }
    }
}

