/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.selector;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.integration.core.MessageSelector;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class MessageSelectorChain
implements MessageSelector {
    private final Lock lock = new ReentrantLock();
    private volatile VotingStrategy votingStrategy = VotingStrategy.ALL;
    private final List<MessageSelector> selectors = new CopyOnWriteArrayList<MessageSelector>();

    public void setVotingStrategy(VotingStrategy votingStrategy) {
        Assert.notNull((Object)((Object)votingStrategy), (String)"votingStrategy must not be null");
        this.votingStrategy = votingStrategy;
    }

    public void add(MessageSelector selector) {
        this.selectors.add(selector);
    }

    public void add(int index, MessageSelector selector) {
        this.selectors.add(index, selector);
    }

    public void setSelectors(List<MessageSelector> selectors) {
        Assert.notEmpty(selectors, (String)"selectors must not be empty");
        this.lock.lock();
        try {
            this.selectors.clear();
            this.selectors.addAll(selectors);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final boolean accept(Message<?> message) {
        int count = 0;
        int accepted = 0;
        for (MessageSelector next : this.selectors) {
            ++count;
            if (next.accept(message)) {
                if (this.votingStrategy.equals((Object)VotingStrategy.ANY)) {
                    return true;
                }
                ++accepted;
                continue;
            }
            if (!this.votingStrategy.equals((Object)VotingStrategy.ALL)) continue;
            return false;
        }
        return this.decide(accepted, count);
    }

    private boolean decide(int accepted, int total) {
        if (accepted == 0) {
            return false;
        }
        return switch (this.votingStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case VotingStrategy.ANY -> true;
            case VotingStrategy.ALL -> {
                if (accepted == total) {
                    yield true;
                }
                yield false;
            }
            case VotingStrategy.MAJORITY -> {
                if (2 * accepted > total) {
                    yield true;
                }
                yield false;
            }
            case VotingStrategy.MAJORITY_OR_TIE -> 2 * accepted >= total;
        };
    }

    public static enum VotingStrategy {
        ALL,
        ANY,
        MAJORITY,
        MAJORITY_OR_TIE;

    }
}

