/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import io.swagger.models.Swagger;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.VendorExtensions;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperation;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaMeta.class);
    private final MicroserviceMeta microserviceMeta;
    private final Swagger swagger;
    private final String schemaId;
    private final String microserviceQualifiedName;
    private final Map<String, OperationMeta> operations = new HashMap<String, OperationMeta>();
    private final VendorExtensions vendorExtensions = new VendorExtensions();

    public SchemaMeta(MicroserviceMeta microserviceMeta, String schemaId, Swagger swagger) {
        this.microserviceMeta = microserviceMeta;
        this.schemaId = schemaId;
        this.swagger = swagger;
        this.microserviceQualifiedName = microserviceMeta.getMicroserviceName() + "." + schemaId;
        try {
            this.initOperationMetas();
        }
        catch (Throwable e) {
            LOGGER.error("Unhandled exception to {}.", (Object)this.microserviceQualifiedName, (Object)e);
            throw e;
        }
    }

    private SchemaMeta initOperationMetas() {
        SwaggerOperations swaggerOperations = new SwaggerOperations(this.swagger);
        for (SwaggerOperation swaggerOperation : swaggerOperations.getOperations().values()) {
            this.operations.put(swaggerOperation.getOperationId(), new OperationMeta().init(this, swaggerOperation));
        }
        return this;
    }

    public MicroserviceMeta getMicroserviceMeta() {
        return this.microserviceMeta;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public String getAppId() {
        return this.microserviceMeta.getAppId();
    }

    public String getMicroserviceName() {
        return this.microserviceMeta.getMicroserviceName();
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public String getMicroserviceQualifiedName() {
        return this.microserviceQualifiedName;
    }

    public Map<String, OperationMeta> getOperations() {
        return this.operations;
    }

    public void putExtData(String key, Object data) {
        this.vendorExtensions.put((Object)key, data);
    }

    public <T> T getExtData(String key) {
        return (T)this.vendorExtensions.get((Object)key);
    }

    public OperationMeta findOperation(String operationId) {
        return this.operations.get(operationId);
    }

    public OperationMeta ensureFindOperation(String operationId) {
        OperationMeta value = this.operations.get(operationId);
        if (value == null) {
            throw new IllegalStateException(String.format("Can not find OperationMeta, microserviceName=%s, schemaId=%s, operationId=%s.", this.getMicroserviceName(), this.getSchemaId(), operationId));
        }
        return value;
    }
}

