/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.extensions;

import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExtensionsConfiguration {
    private ConfigurationPathResolver configResolver;
    private Map<String, List<String>> extensionMappings;

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
    }

    public Map<String, List<String>> getExtensionMappings() {
        if (this.extensionMappings == null) {
            this.extensionMappings = new LinkedHashMap<String, List<String>>();
        }
        return this.extensionMappings;
    }

    public void setExtensionMappings(Map<String, List<String>> extensionMappings) {
        this.extensionMappings = extensionMappings;
    }

    public String[] getExtension() {
        if (this.extensionMappings != null) {
            return this.extensionMappings.keySet().toArray(new String[0]);
        }
        return null;
    }

    public void cfgExtension(ConfigurationValue cfgval, List<String> args) throws ConfigurationException {
        if (args == null) {
            throw new ConfigurationException.CannotOpen(null, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        if (this.configResolver == null) {
            throw new ConfigurationException.CannotOpen(null, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        Iterator<String> iterator = args.iterator();
        String extension = iterator.next();
        File file = new File(extension);
        if (!file.exists()) {
            throw new ConfigurationException.NotAFile(extension, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        ArrayList<String> parameters = new ArrayList<String>();
        while (iterator.hasNext()) {
            parameters.add(iterator.next());
        }
        this.getExtensionMappings().put(file.getAbsolutePath(), parameters);
    }

    public static ConfigurationInfo getExtensionInfo() {
        return new ConfigurationInfo(-1, new String[]{"extension", "parameters"}){

            @Override
            public boolean allowMultiple() {
                return true;
            }
        };
    }
}

