/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.abc.ABCConstants;
import org.apache.royale.abc.semantics.Label;

public abstract class Instruction {
    private static Map<String, Integer> opcodeNameToOpcode = new HashMap<String, Integer>();
    private static Map<Integer, String> opcodeToOpcodeName = new HashMap<Integer, String>();
    protected int opcode;

    public static int decodeOpcodeName(String opcodeName) {
        String opcodeKey = opcodeName.toLowerCase();
        if (opcodeNameToOpcode.size() == 0) {
            Instruction.loadOpcodes();
        }
        if (opcodeNameToOpcode.containsKey(opcodeKey)) {
            return opcodeNameToOpcode.get(opcodeKey);
        }
        return -1;
    }

    public static String decodeOp(int opcode) {
        if (opcodeToOpcodeName.containsKey(opcode)) {
            return opcodeToOpcodeName.get(opcode);
        }
        return "OP_" + Integer.toHexString(opcode);
    }

    private static void loadOpcodes() {
        for (Field f : ABCConstants.class.getFields()) {
            String field_name = f.getName();
            if (!field_name.startsWith("OP_")) continue;
            String opcode = field_name.substring(3);
            try {
                int field_value = f.getInt(null);
                opcodeNameToOpcode.put(opcode, field_value);
                opcodeToOpcodeName.put(field_value, opcode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Instruction(int opcode) {
        this.opcode = opcode;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public boolean isImmediate() {
        return false;
    }

    public int getImmediate() {
        this.unsupported("%s has no immediate operand.");
        return -1;
    }

    public Label getTarget() {
        return null;
    }

    public void setTarget(Label target) {
        this.unsupported("Cannot set target on %s");
    }

    public Object getOperand(int index) {
        this.unsupported("%s has no operands");
        return null;
    }

    public int getOperandCount() {
        return 0;
    }

    public boolean hasOperands() {
        return false;
    }

    public void setOperands(Object[] operands) {
        this.unsupported("%s has no operands");
    }

    public boolean isBranch() {
        return 27 == this.getOpcode() || this.getTarget() != null;
    }

    public boolean isReturn() {
        int opcode = this.getOpcode();
        return 72 == opcode || 71 == opcode;
    }

    public boolean isTransferOfControl() {
        return this.isBranch() || this.isReturn() || 3 == this.opcode;
    }

    public void setImmediate(int immediate) {
        this.unsupported("%s has no immediate operand.");
    }

    public void setTempRegisters(Object[] tempregs) {
        this.unsupported("cannot set temp registers of %s");
    }

    public boolean isExecutable() {
        return this.opcode != 240 && this.opcode != 241;
    }

    public boolean isTargetableInstruction() {
        switch (this.opcode) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return Instruction.decodeOp(this.opcode);
    }

    protected void unsupported(String diagnostic) {
        throw new UnsupportedOperationException(String.format(diagnostic, this.toString()));
    }

    static {
        Instruction.loadOpcodes();
    }
}

