/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.queue.DispatchEntry;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueTable;
import org.apache.rocketmq.store.queue.offset.OffsetEntry;
import org.apache.rocketmq.store.queue.offset.OffsetEntryType;
import org.apache.rocketmq.store.rocksdb.ConsumeQueueRocksDBStorage;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;

public class RocksDBConsumeQueueOffsetTable {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger ERROR_LOG = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final Logger ROCKSDB_LOG = LoggerFactory.getLogger((String)"RocketmqRocksDB");
    private static final byte[] MAX_BYTES = "max".getBytes(StandardCharsets.UTF_8);
    private static final byte[] MIN_BYTES = "min".getBytes(StandardCharsets.UTF_8);
    static final int OFFSET_PHY_OFFSET = 0;
    static final int OFFSET_CQ_OFFSET = 8;
    public static final int OFFSET_KEY_LENGTH_WITHOUT_TOPIC_BYTES = 14;
    private static final int OFFSET_VALUE_LENGTH = 16;
    public static final int OFFSET_KEY_LENGTH_WITHOUT_TOPIC_QUEUE_ID_BYTES = 10;
    private static final String MAX_PHYSICAL_OFFSET_CHECKPOINT = "CHECKPOINT_TOPIC";
    private static final byte[] MAX_PHYSICAL_OFFSET_CHECKPOINT_BYTES = "CHECKPOINT_TOPIC".getBytes(StandardCharsets.UTF_8);
    private static final int INNER_CHECKPOINT_TOPIC_LEN = 14 + MAX_PHYSICAL_OFFSET_CHECKPOINT_BYTES.length;
    private static final ByteBuffer INNER_CHECKPOINT_TOPIC = ByteBuffer.allocateDirect(INNER_CHECKPOINT_TOPIC_LEN);
    private static final byte[] MAX_PHYSICAL_OFFSET_CHECKPOINT_KEY = new byte[INNER_CHECKPOINT_TOPIC_LEN];
    private final ByteBuffer maxPhyOffsetBB;
    private final RocksDBConsumeQueueTable rocksDBConsumeQueueTable;
    private final ConsumeQueueRocksDBStorage rocksDBStorage;
    private final DefaultMessageStore messageStore;
    private ColumnFamilyHandle offsetCFH;
    private final ConcurrentMap<String, PhyAndCQOffset> topicQueueMinOffset;
    private final ConcurrentMap<String, Long> topicQueueMaxCqOffset;

    public RocksDBConsumeQueueOffsetTable(RocksDBConsumeQueueTable rocksDBConsumeQueueTable, ConsumeQueueRocksDBStorage rocksDBStorage, DefaultMessageStore messageStore) {
        this.rocksDBConsumeQueueTable = rocksDBConsumeQueueTable;
        this.rocksDBStorage = rocksDBStorage;
        this.messageStore = messageStore;
        this.topicQueueMinOffset = new ConcurrentHashMap<String, PhyAndCQOffset>(1024);
        this.topicQueueMaxCqOffset = new ConcurrentHashMap<String, Long>(1024);
        this.maxPhyOffsetBB = ByteBuffer.allocateDirect(8);
    }

    public void load() {
        this.offsetCFH = this.rocksDBStorage.getOffsetCFHandle();
        this.loadMaxConsumeQueueOffsets();
    }

    public Set<Integer> scanAllQueueIdInTopic(String topic) throws RocksDBException {
        HashSet<Integer> queueIdSet = new HashSet<Integer>();
        byte[] topicBytes = topic.getBytes(StandardCharsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(10 + topicBytes.length);
        byteBuffer.putInt(topicBytes.length).put((byte)1).put(topicBytes).put((byte)1).put(MAX_BYTES).put((byte)1);
        byteBuffer.flip();
        byte[] prefix = byteBuffer.array();
        this.rocksDBStorage.iterate(this.offsetCFH, prefix, (keyBytes, unused) -> {
            ByteBuffer keyBuffer = ByteBuffer.wrap(keyBytes);
            keyBuffer.position(prefix.length);
            int queueId = keyBuffer.getInt();
            queueIdSet.add(queueId);
        });
        return queueIdSet;
    }

    private void loadMaxConsumeQueueOffsets() {
        Function<OffsetEntry, Boolean> predicate = entry -> entry.type == OffsetEntryType.MAXIMUM;
        Consumer<OffsetEntry> fn = entry -> {
            this.topicQueueMaxCqOffset.putIfAbsent(entry.topic + "-" + entry.queueId, entry.offset);
            log.info("LoadMaxConsumeQueueOffsets Max {}:{} --> {}|{}", new Object[]{entry.topic, entry.queueId, entry.offset, entry.commitLogOffset});
        };
        try {
            this.forEach(predicate, fn);
        }
        catch (RocksDBException e) {
            log.error("Failed to maximum consume queue offset", (Throwable)e);
        }
    }

    public void forEach(Function<OffsetEntry, Boolean> predicate, Consumer<OffsetEntry> fn) throws RocksDBException {
        try (RocksIterator iterator = this.rocksDBStorage.seekOffsetCF();){
            if (null == iterator) {
                return;
            }
            int keyBufferCapacity = 256;
            iterator.seekToFirst();
            ByteBuffer keyBuffer = ByteBuffer.allocateDirect(keyBufferCapacity);
            ByteBuffer valueBuffer = ByteBuffer.allocateDirect(16);
            while (iterator.isValid()) {
                keyBuffer.clear();
                int total = iterator.key(keyBuffer);
                if (total > keyBufferCapacity) {
                    keyBufferCapacity = total;
                    PlatformDependent.freeDirectBuffer((ByteBuffer)keyBuffer);
                    keyBuffer = ByteBuffer.allocateDirect(keyBufferCapacity);
                    continue;
                }
                if (keyBuffer.remaining() <= 14) {
                    iterator.next();
                    ROCKSDB_LOG.warn("Malformed Key/Value pair");
                    continue;
                }
                int topicLength = keyBuffer.getInt();
                byte ctrl1 = keyBuffer.get();
                assert (ctrl1 == 1);
                byte[] topicBytes = new byte[topicLength];
                keyBuffer.get(topicBytes);
                ctrl1 = keyBuffer.get();
                assert (ctrl1 == 1);
                String topic = new String(topicBytes, StandardCharsets.UTF_8);
                byte[] minMax = new byte[3];
                keyBuffer.get(minMax);
                OffsetEntryType entryType = Arrays.equals(minMax, MAX_BYTES) ? OffsetEntryType.MAXIMUM : OffsetEntryType.MINIMUM;
                ctrl1 = keyBuffer.get();
                assert (ctrl1 == 1);
                assert (keyBuffer.remaining() == 4);
                int queueId = keyBuffer.getInt();
                valueBuffer.clear();
                total = iterator.value(valueBuffer);
                if (total != 16) {
                    iterator.next();
                    continue;
                }
                long commitLogOffset = valueBuffer.getLong();
                long consumeOffset = valueBuffer.getLong();
                OffsetEntry entry = new OffsetEntry();
                entry.topic = topic;
                entry.queueId = queueId;
                entry.type = entryType;
                entry.offset = consumeOffset;
                entry.commitLogOffset = commitLogOffset;
                if (predicate.apply(entry).booleanValue()) {
                    fn.accept(entry);
                }
                iterator.next();
            }
            PlatformDependent.freeDirectBuffer((ByteBuffer)keyBuffer);
            PlatformDependent.freeDirectBuffer((ByteBuffer)valueBuffer);
        }
    }

    public void putMaxPhyAndCqOffset(Map<ByteBuffer, Pair<ByteBuffer, DispatchEntry>> tempTopicQueueMaxOffsetMap, WriteBatch writeBatch, long maxPhyOffset) throws RocksDBException {
        for (Map.Entry<ByteBuffer, Pair<ByteBuffer, DispatchEntry>> entry : tempTopicQueueMaxOffsetMap.entrySet()) {
            writeBatch.put(this.offsetCFH, entry.getKey(), (ByteBuffer)entry.getValue().getObject1());
        }
        this.appendMaxPhyOffset(writeBatch, maxPhyOffset);
    }

    public void putHeapMaxCqOffset(Map<ByteBuffer, Pair<ByteBuffer, DispatchEntry>> tempTopicQueueMaxOffsetMap) {
        for (Map.Entry<ByteBuffer, Pair<ByteBuffer, DispatchEntry>> entry : tempTopicQueueMaxOffsetMap.entrySet()) {
            DispatchEntry dispatchEntry = (DispatchEntry)entry.getValue().getObject2();
            String topic = new String(dispatchEntry.topic, StandardCharsets.UTF_8);
            this.putHeapMaxCqOffset(topic, dispatchEntry.queueId, dispatchEntry.queueOffset);
        }
    }

    public void destroyOffset(String topic, int queueId, WriteBatch writeBatch) throws RocksDBException {
        byte[] topicBytes = topic.getBytes(StandardCharsets.UTF_8);
        ByteBuffer minOffsetKey = RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer(topicBytes, queueId, false);
        byte[] minOffsetBytes = this.rocksDBStorage.getOffset(minOffsetKey.array());
        Long startCQOffset = minOffsetBytes != null ? Long.valueOf(ByteBuffer.wrap(minOffsetBytes).getLong(8)) : null;
        ByteBuffer maxOffsetKey = RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer(topicBytes, queueId, true);
        byte[] maxOffsetBytes = this.rocksDBStorage.getOffset(maxOffsetKey.array());
        Long endCQOffset = maxOffsetBytes != null ? Long.valueOf(ByteBuffer.wrap(maxOffsetBytes).getLong(8)) : null;
        writeBatch.delete(this.offsetCFH, minOffsetKey.array());
        writeBatch.delete(this.offsetCFH, maxOffsetKey.array());
        String topicQueueId = this.buildTopicQueueId(topic, queueId);
        this.removeHeapMinCqOffset(topicQueueId);
        this.removeHeapMaxCqOffset(topicQueueId);
        log.info("RocksDB offset table delete topic: {}, queueId: {}, minOffset: {}, maxOffset: {}", new Object[]{topic, queueId, startCQOffset, endCQOffset});
    }

    private void appendMaxPhyOffset(WriteBatch writeBatch, long maxPhyOffset) throws RocksDBException {
        ByteBuffer maxPhyOffsetBB = this.maxPhyOffsetBB;
        maxPhyOffsetBB.position(0).limit(8);
        maxPhyOffsetBB.putLong(maxPhyOffset);
        maxPhyOffsetBB.flip();
        INNER_CHECKPOINT_TOPIC.position(0).limit(INNER_CHECKPOINT_TOPIC_LEN);
        writeBatch.put(this.offsetCFH, INNER_CHECKPOINT_TOPIC, maxPhyOffsetBB);
    }

    public long getMaxPhyOffset() throws RocksDBException {
        byte[] valueBytes = this.rocksDBStorage.getOffset(MAX_PHYSICAL_OFFSET_CHECKPOINT_KEY);
        if (valueBytes == null) {
            return 0L;
        }
        ByteBuffer valueBB = ByteBuffer.wrap(valueBytes);
        return valueBB.getLong(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Set<Integer>> iterateOffsetTable2FindDirty(Set<String> existTopicSet) {
        HashMap<String, Set<Integer>> topicQueueIdToBeDeletedMap = new HashMap<String, Set<Integer>>();
        try (RocksIterator iterator = this.rocksDBStorage.seekOffsetCF();){
            if (iterator == null) {
                HashMap<String, Set<Integer>> hashMap = topicQueueIdToBeDeletedMap;
                return hashMap;
            }
            iterator.seekToFirst();
            while (iterator.isValid()) {
                byte[] key = iterator.key();
                byte[] value = iterator.value();
                if (key != null && key.length > 14 && value != null && value.length == 16) {
                    ByteBuffer keyBB = ByteBuffer.wrap(key);
                    int topicLen = keyBB.getInt(0);
                    byte[] topicBytes = new byte[topicLen];
                    keyBB.position(5);
                    keyBB.get(topicBytes);
                    String topic = new String(topicBytes, StandardCharsets.UTF_8);
                    if (!TopicValidator.isSystemTopic((String)topic) && !MixAll.isLmq((String)topic)) {
                        int queueId = keyBB.getInt(5 + topicLen + 1 + 3 + 1);
                        if (!existTopicSet.contains(topic)) {
                            ByteBuffer valueBB = ByteBuffer.wrap(value);
                            long cqOffset = valueBB.getLong(8);
                            Set topicQueueIdSet = (Set)topicQueueIdToBeDeletedMap.get(topic);
                            if (topicQueueIdSet == null) {
                                HashSet<Integer> newSet = new HashSet<Integer>();
                                newSet.add(queueId);
                                topicQueueIdToBeDeletedMap.put(topic, newSet);
                            } else {
                                topicQueueIdSet.add(queueId);
                            }
                            ERROR_LOG.info("RocksDBConsumeQueueOffsetTable has dirty cqOffset. topic: {}, queueId: {}, cqOffset: {}", new Object[]{topic, queueId, cqOffset});
                        }
                    }
                }
                iterator.next();
            }
            return topicQueueIdToBeDeletedMap;
        }
        catch (Exception e) {
            ERROR_LOG.error("iterateOffsetTable2MarkDirtyCQ Failed.", (Throwable)e);
        }
        return topicQueueIdToBeDeletedMap;
    }

    public Long getMaxCqOffset(String topic, int queueId) throws RocksDBException {
        Long maxCqOffset = this.getHeapMaxCqOffset(topic, queueId);
        if (maxCqOffset == null) {
            long offset;
            ByteBuffer byteBuffer = this.getMaxPhyAndCqOffsetInKV(topic, queueId);
            maxCqOffset = byteBuffer != null ? Long.valueOf(byteBuffer.getLong(8)) : null;
            String topicQueueId = this.buildTopicQueueId(topic, queueId);
            Long prev = this.topicQueueMaxCqOffset.putIfAbsent(topicQueueId, offset = maxCqOffset != null ? maxCqOffset : -1L);
            if (null == prev) {
                ROCKSDB_LOG.info("Max offset of {} is initialized to {} according to RocksDB", (Object)topicQueueId, (Object)offset);
            }
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("updateMaxOffsetInQueue. {}, {}", (Object)topicQueueId, (Object)offset);
            }
        }
        return maxCqOffset;
    }

    public void truncateDirty(long offsetToTruncate) throws RocksDBException {
        this.correctMaxPyhOffset(offsetToTruncate);
        Function<OffsetEntry, Boolean> predicate = entry -> {
            if (entry.type == OffsetEntryType.MINIMUM) {
                return false;
            }
            return entry.commitLogOffset >= offsetToTruncate;
        };
        Consumer<OffsetEntry> fn = entry -> {
            try {
                this.truncateDirtyOffset(entry.topic, entry.queueId);
            }
            catch (RocksDBException e) {
                log.error("Failed to truncate maximum offset of consume queue[topic={}, queue-id={}]", new Object[]{entry.topic, entry.queueId, e});
            }
        };
        this.forEach(predicate, fn);
    }

    private Pair<Boolean, Long> isMinOffsetOk(String topic, int queueId, long minPhyOffset) throws RocksDBException {
        PhyAndCQOffset phyAndCQOffset = this.getHeapMinOffset(topic, queueId);
        if (phyAndCQOffset != null) {
            long phyOffset = phyAndCQOffset.getPhyOffset();
            long cqOffset = phyAndCQOffset.getCqOffset();
            return phyOffset >= minPhyOffset ? new Pair((Object)true, (Object)cqOffset) : new Pair((Object)false, (Object)cqOffset);
        }
        ByteBuffer byteBuffer = this.getMinPhyAndCqOffsetInKV(topic, queueId);
        if (byteBuffer == null) {
            return new Pair((Object)false, (Object)0L);
        }
        long phyOffset = byteBuffer.getLong(0);
        long cqOffset = byteBuffer.getLong(8);
        if (phyOffset >= minPhyOffset) {
            String topicQueueId = this.buildTopicQueueId(topic, queueId);
            PhyAndCQOffset newPhyAndCQOffset = new PhyAndCQOffset(phyOffset, cqOffset);
            this.topicQueueMinOffset.putIfAbsent(topicQueueId, newPhyAndCQOffset);
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("updateMinOffsetInQueue. {}, {}", (Object)topicQueueId, (Object)newPhyAndCQOffset);
            }
            return new Pair((Object)true, (Object)cqOffset);
        }
        return new Pair((Object)false, (Object)cqOffset);
    }

    private void truncateDirtyOffset(String topic, int queueId) throws RocksDBException {
        ByteBuffer byteBuffer = this.getMaxPhyAndCqOffsetInKV(topic, queueId);
        if (byteBuffer == null) {
            return;
        }
        long maxPhyOffset = byteBuffer.getLong(0);
        long maxCqOffset = byteBuffer.getLong(8);
        long maxPhyOffsetInCQ = this.getMaxPhyOffset();
        if (maxPhyOffset >= maxPhyOffsetInCQ) {
            this.correctMaxCqOffset(topic, queueId, maxCqOffset, maxPhyOffsetInCQ);
            Long newMaxCqOffset = this.getHeapMaxCqOffset(topic, queueId);
            ROCKSDB_LOG.warn("truncateDirtyLogicFile topic: {}, queueId: {} from {} to {}", new Object[]{topic, queueId, maxPhyOffset, newMaxCqOffset});
        }
    }

    private void correctMaxPyhOffset(long maxPhyOffset) throws RocksDBException {
        if (!this.rocksDBStorage.hold()) {
            return;
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            long oldMaxPhyOffset = this.getMaxPhyOffset();
            if (oldMaxPhyOffset <= maxPhyOffset) {
                return;
            }
            log.info("correctMaxPyhOffset, oldMaxPhyOffset={}, newMaxPhyOffset={}", (Object)oldMaxPhyOffset, (Object)maxPhyOffset);
            this.appendMaxPhyOffset(writeBatch, maxPhyOffset);
            this.rocksDBStorage.batchPut(writeBatch);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("correctMaxPyhOffset Failed.", (Throwable)e);
            throw e;
        }
        finally {
            this.rocksDBStorage.release();
        }
    }

    public long getMinCqOffset(String topic, int queueId) throws RocksDBException {
        PhyAndCQOffset phyAndCQOffset;
        long minPhyOffset = this.messageStore.getMinPhyOffset();
        Pair<Boolean, Long> pair = this.isMinOffsetOk(topic, queueId, minPhyOffset);
        long cqOffset = (Long)pair.getObject2();
        if (!((Boolean)pair.getObject1()).booleanValue() && this.correctMinCqOffset(topic, queueId, cqOffset, minPhyOffset) && (phyAndCQOffset = this.getHeapMinOffset(topic, queueId)) != null) {
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("getMinOffsetInQueue miss heap. topic: {}, queueId: {}, old: {}, new: {}", new Object[]{topic, queueId, cqOffset, phyAndCQOffset});
            }
            return phyAndCQOffset.getCqOffset();
        }
        return cqOffset;
    }

    public Long getMaxPhyOffset(String topic, int queueId) {
        try {
            ByteBuffer byteBuffer = this.getMaxPhyAndCqOffsetInKV(topic, queueId);
            if (byteBuffer != null) {
                return byteBuffer.getLong(0);
            }
        }
        catch (Exception e) {
            ERROR_LOG.info("getMaxPhyOffset error. topic: {}, queueId: {}", (Object)topic, (Object)queueId);
        }
        return null;
    }

    private ByteBuffer getMinPhyAndCqOffsetInKV(String topic, int queueId) throws RocksDBException {
        return this.getPhyAndCqOffsetInKV(topic, queueId, false);
    }

    private ByteBuffer getMaxPhyAndCqOffsetInKV(String topic, int queueId) throws RocksDBException {
        return this.getPhyAndCqOffsetInKV(topic, queueId, true);
    }

    private ByteBuffer getPhyAndCqOffsetInKV(String topic, int queueId, boolean max) throws RocksDBException {
        byte[] topicBytes = topic.getBytes(StandardCharsets.UTF_8);
        ByteBuffer keyBB = RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer(topicBytes, queueId, max);
        byte[] value = this.rocksDBStorage.getOffset(keyBB.array());
        return value != null ? ByteBuffer.wrap(value) : null;
    }

    private String buildTopicQueueId(String topic, int queueId) {
        return topic + "-" + queueId;
    }

    private void putHeapMinCqOffset(String topic, int queueId, long minPhyOffset, long minCQOffset) {
        String topicQueueId = this.buildTopicQueueId(topic, queueId);
        PhyAndCQOffset phyAndCQOffset = new PhyAndCQOffset(minPhyOffset, minCQOffset);
        this.topicQueueMinOffset.put(topicQueueId, phyAndCQOffset);
    }

    private void putHeapMaxCqOffset(String topic, int queueId, long maxOffset) {
        String topicQueueId = this.buildTopicQueueId(topic, queueId);
        Long prev = this.topicQueueMaxCqOffset.put(topicQueueId, maxOffset);
        if (prev != null && prev > maxOffset) {
            ERROR_LOG.error("Max offset of consume-queue[topic={}, queue-id={}] regressed. prev-max={}, current-max={}", new Object[]{topic, queueId, prev, maxOffset});
        }
    }

    private PhyAndCQOffset getHeapMinOffset(String topic, int queueId) {
        return (PhyAndCQOffset)this.topicQueueMinOffset.get(this.buildTopicQueueId(topic, queueId));
    }

    private Long getHeapMaxCqOffset(String topic, int queueId) {
        String topicQueueId = this.buildTopicQueueId(topic, queueId);
        return (Long)this.topicQueueMaxCqOffset.get(topicQueueId);
    }

    private PhyAndCQOffset removeHeapMinCqOffset(String topicQueueId) {
        return (PhyAndCQOffset)this.topicQueueMinOffset.remove(topicQueueId);
    }

    private Long removeHeapMaxCqOffset(String topicQueueId) {
        return (Long)this.topicQueueMaxCqOffset.remove(topicQueueId);
    }

    public void updateCqOffset(String topic, int queueId, long phyOffset, long cqOffset, boolean max) throws RocksDBException {
        if (!this.rocksDBStorage.hold()) {
            return;
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            byte[] topicBytes = topic.getBytes(StandardCharsets.UTF_8);
            ByteBuffer offsetKey = RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer(topicBytes, queueId, max);
            ByteBuffer offsetValue = RocksDBConsumeQueueOffsetTable.buildOffsetValueByteBuffer(phyOffset, cqOffset);
            writeBatch.put(this.offsetCFH, offsetKey.array(), offsetValue.array());
            this.rocksDBStorage.batchPut(writeBatch);
            if (max) {
                this.putHeapMaxCqOffset(topic, queueId, cqOffset);
            } else {
                this.putHeapMinCqOffset(topic, queueId, phyOffset, cqOffset);
            }
        }
        catch (RocksDBException e) {
            try {
                ERROR_LOG.error("updateCqOffset({}) failed.", (Object)(max ? "max" : "min"), (Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.rocksDBStorage.release();
                if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                    ROCKSDB_LOG.warn("updateCqOffset({}). topic: {}, queueId: {}, phyOffset: {}, cqOffset: {}", new Object[]{max ? "max" : "min", topic, queueId, phyOffset, cqOffset});
                }
                throw throwable;
            }
        }
        this.rocksDBStorage.release();
        if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
            ROCKSDB_LOG.warn("updateCqOffset({}). topic: {}, queueId: {}, phyOffset: {}, cqOffset: {}", new Object[]{max ? "max" : "min", topic, queueId, phyOffset, cqOffset});
        }
    }

    private boolean correctMaxCqOffset(String topic, int queueId, long maxCQOffset, long maxPhyOffsetInCQ) throws RocksDBException {
        long minCQOffset = this.getMinCqOffset(topic, queueId);
        PhyAndCQOffset minPhyAndCQOffset = this.getHeapMinOffset(topic, queueId);
        if (minPhyAndCQOffset == null || minPhyAndCQOffset.getCqOffset() != minCQOffset || minPhyAndCQOffset.getPhyOffset() > maxPhyOffsetInCQ) {
            ROCKSDB_LOG.info("[BUG] correctMaxCqOffset error! topic: {}, queueId: {}, maxPhyOffsetInCQ: {}, minCqOffset: {}, phyAndCQOffset: {}", new Object[]{topic, queueId, maxPhyOffsetInCQ, minCQOffset, minPhyAndCQOffset});
            throw new RocksDBException("correctMaxCqOffset error");
        }
        PhyAndCQOffset targetPhyAndCQOffset = this.rocksDBConsumeQueueTable.binarySearchInCQ(topic, queueId, maxCQOffset, minCQOffset, maxPhyOffsetInCQ, false);
        long targetCQOffset = targetPhyAndCQOffset.getCqOffset();
        long targetPhyOffset = targetPhyAndCQOffset.getPhyOffset();
        if (targetCQOffset == -1L) {
            if (maxCQOffset != minCQOffset) {
                this.updateCqOffset(topic, queueId, minPhyAndCQOffset.getPhyOffset(), minCQOffset, true);
            }
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("correct error. {}, {}, {}, {}, {}", new Object[]{topic, queueId, minCQOffset, maxCQOffset, minPhyAndCQOffset.getPhyOffset()});
            }
            return false;
        }
        this.updateCqOffset(topic, queueId, targetPhyOffset, targetCQOffset, true);
        return true;
    }

    private boolean correctMinCqOffset(String topic, int queueId, long minCQOffset, long minPhyOffset) throws RocksDBException {
        ByteBuffer maxBB = this.getMaxPhyAndCqOffsetInKV(topic, queueId);
        if (maxBB == null) {
            this.updateCqOffset(topic, queueId, minPhyOffset, 0L, false);
            return true;
        }
        long maxPhyOffset = maxBB.getLong(0);
        long maxCQOffset = maxBB.getLong(8);
        if (maxPhyOffset < minPhyOffset) {
            this.updateCqOffset(topic, queueId, minPhyOffset, maxCQOffset + 1L, false);
            return true;
        }
        PhyAndCQOffset phyAndCQOffset = this.rocksDBConsumeQueueTable.binarySearchInCQ(topic, queueId, maxCQOffset, minCQOffset, minPhyOffset, true);
        long targetCQOffset = phyAndCQOffset.getCqOffset();
        long targetPhyOffset = phyAndCQOffset.getPhyOffset();
        if (targetCQOffset == -1L) {
            if (maxCQOffset != minCQOffset) {
                this.updateCqOffset(topic, queueId, maxPhyOffset, maxCQOffset, false);
            }
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("correct error. {}, {}, {}, {}, {}", new Object[]{topic, queueId, minCQOffset, maxCQOffset, minPhyOffset});
            }
            return false;
        }
        this.updateCqOffset(topic, queueId, targetPhyOffset, targetCQOffset, false);
        return true;
    }

    public static Pair<ByteBuffer, ByteBuffer> getOffsetByteBufferPair() {
        ByteBuffer offsetKey = ByteBuffer.allocateDirect(300);
        ByteBuffer offsetValue = ByteBuffer.allocateDirect(16);
        return new Pair((Object)offsetKey, (Object)offsetValue);
    }

    static void buildOffsetKeyAndValueByteBuffer(Pair<ByteBuffer, ByteBuffer> offsetBBPair, DispatchEntry entry) {
        ByteBuffer offsetKey = (ByteBuffer)offsetBBPair.getObject1();
        RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer(offsetKey, entry.topic, entry.queueId, true);
        ByteBuffer offsetValue = (ByteBuffer)offsetBBPair.getObject2();
        RocksDBConsumeQueueOffsetTable.buildOffsetValueByteBuffer(offsetValue, entry.commitLogOffset, entry.queueOffset);
    }

    private static ByteBuffer buildOffsetKeyByteBuffer(byte[] topicBytes, int queueId, boolean max) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(14 + topicBytes.length);
        RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer0(byteBuffer, topicBytes, queueId, max);
        return byteBuffer;
    }

    public static void buildOffsetKeyByteBuffer(ByteBuffer byteBuffer, byte[] topicBytes, int queueId, boolean max) {
        byteBuffer.position(0).limit(14 + topicBytes.length);
        RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer0(byteBuffer, topicBytes, queueId, max);
    }

    private static void buildOffsetKeyByteBuffer0(ByteBuffer byteBuffer, byte[] topicBytes, int queueId, boolean max) {
        byteBuffer.putInt(topicBytes.length).put((byte)1).put(topicBytes).put((byte)1);
        if (max) {
            byteBuffer.put(MAX_BYTES);
        } else {
            byteBuffer.put(MIN_BYTES);
        }
        byteBuffer.put((byte)1).putInt(queueId);
        byteBuffer.flip();
    }

    private static void buildOffsetValueByteBuffer(ByteBuffer byteBuffer, long phyOffset, long cqOffset) {
        byteBuffer.position(0).limit(16);
        RocksDBConsumeQueueOffsetTable.buildOffsetValueByteBuffer0(byteBuffer, phyOffset, cqOffset);
    }

    private static ByteBuffer buildOffsetValueByteBuffer(long phyOffset, long cqOffset) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        RocksDBConsumeQueueOffsetTable.buildOffsetValueByteBuffer0(byteBuffer, phyOffset, cqOffset);
        return byteBuffer;
    }

    private static void buildOffsetValueByteBuffer0(ByteBuffer byteBuffer, long phyOffset, long cqOffset) {
        byteBuffer.putLong(phyOffset).putLong(cqOffset);
        byteBuffer.flip();
    }

    static {
        RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer0(INNER_CHECKPOINT_TOPIC, MAX_PHYSICAL_OFFSET_CHECKPOINT_BYTES, 0, true);
        INNER_CHECKPOINT_TOPIC.position(0).limit(INNER_CHECKPOINT_TOPIC_LEN);
        INNER_CHECKPOINT_TOPIC.get(MAX_PHYSICAL_OFFSET_CHECKPOINT_KEY);
    }

    static class PhyAndCQOffset {
        private final long phyOffset;
        private final long cqOffset;

        public PhyAndCQOffset(long phyOffset, long cqOffset) {
            this.phyOffset = phyOffset;
            this.cqOffset = cqOffset;
        }

        public long getPhyOffset() {
            return this.phyOffset;
        }

        public long getCqOffset() {
            return this.cqOffset;
        }

        public String toString() {
            return "[cqOffset=" + this.cqOffset + ", phyOffset=" + this.phyOffset + "]";
        }
    }
}

