/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.kv;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class CompactionPositionMgr
extends ConfigManager {
    public static final String CHECKPOINT_FILE = "position-checkpoint";
    private transient String compactionPath;
    private transient String checkpointFileName;
    private ConcurrentHashMap<String, Long> queueOffsetMap = new ConcurrentHashMap();

    private CompactionPositionMgr() {
    }

    public CompactionPositionMgr(String compactionPath) {
        this.compactionPath = compactionPath;
        this.checkpointFileName = compactionPath + File.separator + CHECKPOINT_FILE;
        this.load();
    }

    public void setOffset(String topic, int queueId, long offset) {
        this.queueOffsetMap.put(topic + "_" + queueId, offset);
    }

    public long getOffset(String topic, int queueId) {
        return this.queueOffsetMap.getOrDefault(topic + "_" + queueId, -1L);
    }

    public boolean isEmpty() {
        return this.queueOffsetMap.isEmpty();
    }

    public boolean isCompaction(String topic, int queueId, long offset) {
        return this.getOffset(topic, queueId) > offset;
    }

    public String configFilePath() {
        return this.checkpointFileName;
    }

    public String encode() {
        return this.encode(false);
    }

    public String encode(boolean prettyFormat) {
        return RemotingSerializable.toJson((Object)((Object)this), (boolean)prettyFormat);
    }

    public void decode(String jsonString) {
        CompactionPositionMgr obj;
        if (jsonString != null && (obj = (CompactionPositionMgr)((Object)RemotingSerializable.fromJson((String)jsonString, CompactionPositionMgr.class))) != null) {
            this.queueOffsetMap = obj.queueOffsetMap;
        }
    }

    public ConcurrentHashMap<String, Long> getQueueOffsetMap() {
        return this.queueOffsetMap;
    }

    public void setQueueOffsetMap(ConcurrentHashMap<String, Long> queueOffsetMap) {
        this.queueOffsetMap = queueOffsetMap;
    }
}

