/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.qpid.protonj2.client.impl.ClientConstants;
import org.apache.qpid.protonj2.types.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientRedirect {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRedirect.class);
    private final Map<Symbol, Object> redirect;
    private URI cachedURI;

    ClientRedirect(Map<Symbol, Object> redirect) {
        this.redirect = redirect;
    }

    public ClientRedirect validate() throws Exception {
        int networkPort;
        String networkHost = (String)this.redirect.get(ClientConstants.NETWORK_HOST);
        if (networkHost == null || networkHost.isEmpty()) {
            throw new IOException("Redirection information not set, missing network host.");
        }
        try {
            networkPort = Integer.parseInt(this.redirect.get(ClientConstants.PORT).toString());
        }
        catch (Exception ex) {
            throw new IOException("Redirection information contained invalid port.");
        }
        LOG.trace("Redirect issued host and port as follows: {}:{}", (Object)networkHost, (Object)networkPort);
        this.cachedURI = this.toURI();
        return this;
    }

    public Map<Symbol, Object> getRedirectMap() {
        return this.redirect;
    }

    public String getHostname() {
        return (String)this.redirect.get(ClientConstants.OPEN_HOSTNAME);
    }

    public String getNetworkHost() {
        return (String)this.redirect.get(ClientConstants.NETWORK_HOST);
    }

    public int getPort() {
        return Integer.parseInt(this.redirect.get(ClientConstants.PORT).toString());
    }

    public String getScheme() {
        return (String)this.redirect.get(ClientConstants.SCHEME);
    }

    public String getPath() {
        return (String)this.redirect.get(ClientConstants.PATH);
    }

    public String getAddress() {
        return (String)this.redirect.get(ClientConstants.ADDRESS);
    }

    public URI toURI() throws Exception {
        if (this.cachedURI != null) {
            return this.cachedURI;
        }
        this.cachedURI = new URI(this.getScheme(), null, this.getNetworkHost(), this.getPort(), this.getPath(), null, null);
        return this.cachedURI;
    }

    public String toString() {
        try {
            return this.toURI().toString();
        }
        catch (Exception ex) {
            return "<Invalid-Redirect-Value>";
        }
    }
}

