/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.Writable;

public final class OrcStruct
implements Writable {
    private Object[] fields;

    OrcStruct(int children) {
        this.fields = new Object[children];
    }

    Object getFieldValue(int fieldIndex) {
        return this.fields[fieldIndex];
    }

    void setFieldValue(int fieldIndex, Object value) {
        this.fields[fieldIndex] = value;
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public void setNumFields(int numFields) {
        if (this.fields.length != numFields) {
            Object[] oldFields = this.fields;
            this.fields = new Object[numFields];
            System.arraycopy(oldFields, 0, this.fields, 0, Math.min(oldFields.length, numFields));
        }
    }

    void linkFields(OrcStruct other) {
        this.fields = other.fields;
    }

    public void write(DataOutput dataOutput) throws IOException {
        throw new UnsupportedOperationException("write unsupported");
    }

    public void readFields(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException("readFields unsupported");
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != OrcStruct.class) {
            return false;
        }
        OrcStruct oth = (OrcStruct)other;
        if (this.fields.length != oth.fields.length) {
            return false;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (!(this.fields[i] == null ? oth.fields[i] != null : !this.fields[i].equals(oth.fields[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.fields.length;
        for (Object field : this.fields) {
            if (field == null) continue;
            result ^= field.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.fields[i]);
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static ObjectInspector createObjectInspector(TypeInfo info) {
        switch (info.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveTypeInfo)info).getPrimitiveCategory()) {
                    case FLOAT: {
                        return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
                    }
                    case DOUBLE: {
                        return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
                    }
                    case BOOLEAN: {
                        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
                    }
                    case BYTE: {
                        return PrimitiveObjectInspectorFactory.writableByteObjectInspector;
                    }
                    case SHORT: {
                        return PrimitiveObjectInspectorFactory.writableShortObjectInspector;
                    }
                    case INT: {
                        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
                    }
                    case LONG: {
                        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
                    }
                    case BINARY: {
                        return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
                    }
                    case STRING: {
                        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
                    }
                    case CHAR: {
                        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)info));
                    }
                    case VARCHAR: {
                        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)info));
                    }
                    case TIMESTAMP: {
                        return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
                    }
                    case DATE: {
                        return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
                    }
                    case DECIMAL: {
                        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)info));
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type " + ((PrimitiveTypeInfo)info).getPrimitiveCategory());
            }
            case STRUCT: {
                return new OrcStructInspector((StructTypeInfo)info);
            }
            case UNION: {
                return new OrcUnion.OrcUnionObjectInspector((UnionTypeInfo)info);
            }
            case MAP: {
                return new OrcMapObjectInspector((MapTypeInfo)info);
            }
            case LIST: {
                return new OrcListObjectInspector((ListTypeInfo)info);
            }
        }
        throw new IllegalArgumentException("Unknown type " + info.getCategory());
    }

    static ObjectInspector createObjectInspector(int columnId, List<OrcProto.Type> types) {
        OrcProto.Type type = types.get(columnId);
        switch (type.getKind()) {
            case FLOAT: {
                return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
            }
            case DOUBLE: {
                return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
            }
            case BOOLEAN: {
                return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
            }
            case BYTE: {
                return PrimitiveObjectInspectorFactory.writableByteObjectInspector;
            }
            case SHORT: {
                return PrimitiveObjectInspectorFactory.writableShortObjectInspector;
            }
            case INT: {
                return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
            }
            case LONG: {
                return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
            }
            case BINARY: {
                return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
            }
            case STRING: {
                return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
            }
            case CHAR: {
                if (!type.hasMaximumLength()) {
                    throw new UnsupportedOperationException("Illegal use of char type without length in ORC type definition.");
                }
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getCharTypeInfo((int)type.getMaximumLength()));
            }
            case VARCHAR: {
                if (!type.hasMaximumLength()) {
                    throw new UnsupportedOperationException("Illegal use of varchar type without length in ORC type definition.");
                }
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getVarcharTypeInfo((int)type.getMaximumLength()));
            }
            case TIMESTAMP: {
                return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
            }
            case DATE: {
                return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
            }
            case DECIMAL: {
                int precision = type.hasPrecision() ? type.getPrecision() : 38;
                int scale = type.hasScale() ? type.getScale() : 18;
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)precision, (int)scale));
            }
            case STRUCT: {
                return new OrcStructInspector(columnId, types);
            }
            case UNION: {
                return new OrcUnion.OrcUnionObjectInspector(columnId, types);
            }
            case MAP: {
                return new OrcMapObjectInspector(columnId, types);
            }
            case LIST: {
                return new OrcListObjectInspector(columnId, types);
            }
        }
        throw new UnsupportedOperationException("Unknown type " + (Object)((Object)type.getKind()));
    }

    static class OrcListObjectInspector
    implements ListObjectInspector,
    SettableListObjectInspector {
        private ObjectInspector child;

        private OrcListObjectInspector() {
        }

        OrcListObjectInspector(ListTypeInfo info) {
            this.child = OrcStruct.createObjectInspector(info.getListElementTypeInfo());
        }

        OrcListObjectInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            this.child = OrcStruct.createObjectInspector(type.getSubtypes(0), types);
        }

        public ObjectInspector getListElementObjectInspector() {
            return this.child;
        }

        public Object getListElement(Object list, int i) {
            if (list == null) {
                return null;
            }
            return ((List)list).get(i);
        }

        public int getListLength(Object list) {
            if (list == null) {
                return -1;
            }
            return ((List)list).size();
        }

        public List<?> getList(Object list) {
            if (list == null) {
                return null;
            }
            return (List)list;
        }

        public String getTypeName() {
            return "array<" + this.child.getTypeName() + ">";
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.LIST;
        }

        public Object create(int size) {
            ArrayList<Object> result = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                result.add(null);
            }
            return result;
        }

        public Object set(Object list, int index, Object element) {
            List l = (List)list;
            for (int i = l.size(); i < index + 1; ++i) {
                l.add(null);
            }
            l.set(index, element);
            return list;
        }

        public Object resize(Object list, int newSize) {
            ((ArrayList)list).ensureCapacity(newSize);
            return list;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ObjectInspector other = ((OrcListObjectInspector)o).child;
            return other.equals(this.child);
        }
    }

    static class OrcMapObjectInspector
    implements MapObjectInspector,
    SettableMapObjectInspector {
        private ObjectInspector key;
        private ObjectInspector value;

        private OrcMapObjectInspector() {
        }

        OrcMapObjectInspector(MapTypeInfo info) {
            this.key = OrcStruct.createObjectInspector(info.getMapKeyTypeInfo());
            this.value = OrcStruct.createObjectInspector(info.getMapValueTypeInfo());
        }

        OrcMapObjectInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            this.key = OrcStruct.createObjectInspector(type.getSubtypes(0), types);
            this.value = OrcStruct.createObjectInspector(type.getSubtypes(1), types);
        }

        public ObjectInspector getMapKeyObjectInspector() {
            return this.key;
        }

        public ObjectInspector getMapValueObjectInspector() {
            return this.value;
        }

        public Object getMapValueElement(Object map, Object key) {
            return map == null || key == null ? null : ((Map)map).get(key);
        }

        public Map<Object, Object> getMap(Object map) {
            if (map == null) {
                return null;
            }
            return (Map)map;
        }

        public int getMapSize(Object map) {
            if (map == null) {
                return -1;
            }
            return ((Map)map).size();
        }

        public String getTypeName() {
            return "map<" + this.key.getTypeName() + "," + this.value.getTypeName() + ">";
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.MAP;
        }

        public Object create() {
            return new HashMap();
        }

        public Object put(Object map, Object key, Object value) {
            ((Map)map).put(key, value);
            return map;
        }

        public Object remove(Object map, Object key) {
            ((Map)map).remove(key);
            return map;
        }

        public Object clear(Object map) {
            ((Map)map).clear();
            return map;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            OrcMapObjectInspector other = (OrcMapObjectInspector)o;
            return other.key.equals(this.key) && other.value.equals(this.value);
        }
    }

    static class OrcStructInspector
    extends SettableStructObjectInspector {
        private List<StructField> fields;

        protected OrcStructInspector() {
        }

        OrcStructInspector(List<StructField> fields) {
            this.fields = fields;
        }

        OrcStructInspector(StructTypeInfo info) {
            ArrayList fieldNames = info.getAllStructFieldNames();
            ArrayList fieldTypes = info.getAllStructFieldTypeInfos();
            this.fields = new ArrayList<StructField>(fieldNames.size());
            for (int i = 0; i < fieldNames.size(); ++i) {
                this.fields.add(new Field((String)fieldNames.get(i), OrcStruct.createObjectInspector((TypeInfo)fieldTypes.get(i)), i));
            }
        }

        OrcStructInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getSubtypesCount();
            this.fields = new ArrayList<StructField>(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                int fieldType = type.getSubtypes(i);
                this.fields.add(new Field(type.getFieldNames(i), OrcStruct.createObjectInspector(fieldType, types), i));
            }
        }

        public List<StructField> getAllStructFieldRefs() {
            return this.fields;
        }

        public StructField getStructFieldRef(String s) {
            for (StructField field : this.fields) {
                if (!field.getFieldName().equalsIgnoreCase(s)) continue;
                return field;
            }
            return null;
        }

        public Object getStructFieldData(Object object, StructField field) {
            OrcStruct struct;
            if (object == null) {
                return null;
            }
            int offset = ((Field)field).offset;
            if (offset >= (struct = (OrcStruct)object).fields.length) {
                return null;
            }
            return struct.fields[offset];
        }

        public List<Object> getStructFieldsDataAsList(Object object) {
            if (object == null) {
                return null;
            }
            OrcStruct struct = (OrcStruct)object;
            ArrayList<Object> result = new ArrayList<Object>(struct.fields.length);
            for (Object child : struct.fields) {
                result.add(child);
            }
            return result;
        }

        public String getTypeName() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("struct<");
            for (int i = 0; i < this.fields.size(); ++i) {
                StructField field = this.fields.get(i);
                if (i != 0) {
                    buffer.append(",");
                }
                buffer.append(field.getFieldName());
                buffer.append(":");
                buffer.append(field.getFieldObjectInspector().getTypeName());
            }
            buffer.append(">");
            return buffer.toString();
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.STRUCT;
        }

        public Object create() {
            return new OrcStruct(0);
        }

        public Object setStructFieldData(Object struct, StructField field, Object fieldValue) {
            OrcStruct orcStruct = (OrcStruct)struct;
            int offset = ((Field)field).offset;
            if (orcStruct.getNumFields() <= offset) {
                orcStruct.setNumFields(offset + 1);
            }
            orcStruct.setFieldValue(offset, fieldValue);
            return struct;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            List<StructField> other = ((OrcStructInspector)((Object)o)).fields;
            if (other.size() != this.fields.size()) {
                return false;
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                StructField left = other.get(i);
                StructField right = this.fields.get(i);
                if (left.getFieldName().equalsIgnoreCase(right.getFieldName()) && left.getFieldObjectInspector().equals(right.getFieldObjectInspector())) continue;
                return false;
            }
            return true;
        }
    }

    static class Field
    implements StructField {
        private final String name;
        private final ObjectInspector inspector;
        private final int offset;

        Field(String name, ObjectInspector inspector, int offset) {
            this.name = name;
            this.inspector = inspector;
            this.offset = offset;
        }

        public String getFieldName() {
            return this.name;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.inspector;
        }

        public int getFieldID() {
            return this.offset;
        }

        public String getFieldComment() {
            return null;
        }
    }
}

