/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.math.BigInteger;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class DecimalColumnVector
extends ColumnVector {
    public HiveDecimalWritable[] vector;
    public short scale;
    public short precision;
    private final HiveDecimalWritable writableObj = new HiveDecimalWritable();

    public DecimalColumnVector(int precision, int scale) {
        this(1024, precision, scale);
    }

    public DecimalColumnVector(int size, int precision, int scale) {
        super(size);
        this.precision = (short)precision;
        this.scale = (short)scale;
        int len = size;
        this.vector = new HiveDecimalWritable[len];
        for (int i = 0; i < len; ++i) {
            this.vector[i] = new HiveDecimalWritable(HiveDecimal.ZERO);
        }
    }

    @Override
    public Writable getWritableObject(int index) {
        if (this.isRepeating) {
            index = 0;
        }
        if (!this.noNulls && this.isNull[index]) {
            return NullWritable.get();
        }
        this.writableObj.set(this.vector[index]);
        return this.writableObj;
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        HiveDecimal hiveDec = ((DecimalColumnVector)inputVector).vector[inputElementNum].getHiveDecimal((int)this.precision, (int)this.scale);
        if (hiveDec == null) {
            this.noNulls = false;
            this.isNull[outElementNum] = true;
        } else {
            this.vector[outElementNum].set(hiveDec);
        }
    }

    public void set(int elementNum, HiveDecimalWritable writeable) {
        HiveDecimal hiveDec = writeable.getHiveDecimal((int)this.precision, (int)this.scale);
        if (hiveDec == null) {
            this.noNulls = false;
            this.isNull[elementNum] = true;
        } else {
            this.vector[elementNum].set(hiveDec);
        }
    }

    public void set(int elementNum, HiveDecimal hiveDec) {
        HiveDecimal checkedDec = HiveDecimal.enforcePrecisionScale((HiveDecimal)hiveDec, (int)this.precision, (int)this.scale);
        if (checkedDec == null) {
            this.noNulls = false;
            this.isNull[elementNum] = true;
        } else {
            this.vector[elementNum].set(checkedDec);
        }
    }

    public void setNullDataValue(int elementNum) {
        HiveDecimal minimumNonZeroValue = HiveDecimal.create((BigInteger)BigInteger.ONE, (int)this.scale);
        this.vector[elementNum].set(minimumNonZeroValue);
    }
}

