/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.net.InetSocketAddress;
import org.apache.hadoop.io.Text;
import org.apache.thrift.transport.TSocket;

public class AddressUtil {
    public static InetSocketAddress parseAddress(String address, int defaultPort) throws NumberFormatException {
        String[] parts = address.split(":", 2);
        if (address.contains("+")) {
            parts = address.split("\\+", 2);
        }
        if (parts.length == 2) {
            if (parts[1].isEmpty()) {
                return new InetSocketAddress(parts[0], defaultPort);
            }
            return new InetSocketAddress(parts[0], Integer.parseInt(parts[1]));
        }
        return new InetSocketAddress(address, defaultPort);
    }

    public static InetSocketAddress parseAddress(Text address, int defaultPort) {
        return AddressUtil.parseAddress(address.toString(), defaultPort);
    }

    public static TSocket createTSocket(String address, int defaultPort) {
        InetSocketAddress addr = AddressUtil.parseAddress(address, defaultPort);
        return new TSocket(addr.getHostName(), addr.getPort());
    }

    public static String toString(InetSocketAddress addr) {
        return addr.getAddress().getHostAddress() + ":" + addr.getPort();
    }
}

