/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import java.io.IOException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.commons.collections.buffer.PriorityBuffer;

public abstract class HeapIterator
implements SortedKeyValueIterator<Key, Value> {
    private PriorityBuffer heap;
    private SortedKeyValueIterator<Key, Value> currentIter;

    protected HeapIterator() {
        this.heap = null;
    }

    protected HeapIterator(int maxSize) {
        this.createHeap(maxSize);
    }

    protected void createHeap(int maxSize) {
        if (this.heap != null) {
            throw new IllegalStateException("heap already exist");
        }
        this.heap = new PriorityBuffer(maxSize == 0 ? 1 : maxSize);
    }

    @Override
    public final Key getTopKey() {
        return this.currentIter.getTopKey();
    }

    @Override
    public final Value getTopValue() {
        return this.currentIter.getTopValue();
    }

    @Override
    public final boolean hasTop() {
        return this.heap.size() > 0;
    }

    @Override
    public final void next() throws IOException {
        switch (this.heap.size()) {
            case 0: {
                throw new IllegalStateException("Called next() when there is no top");
            }
            case 1: {
                this.currentIter.next();
                if (this.currentIter.hasTop()) break;
                this.heap.remove();
                this.currentIter = null;
                break;
            }
            default: {
                Index idx = (Index)this.heap.remove();
                idx.iter.next();
                if (idx.iter.hasTop()) {
                    this.heap.add((Object)idx);
                }
                this.currentIter = ((Index)this.heap.get()).iter;
            }
        }
    }

    protected final void clear() {
        this.heap.clear();
        this.currentIter = null;
    }

    protected final void addSource(SortedKeyValueIterator<Key, Value> source) {
        if (source.hasTop()) {
            this.heap.add((Object)new Index(source));
        }
        this.currentIter = this.heap.size() > 0 ? ((Index)this.heap.get()).iter : null;
    }

    private static class Index
    implements Comparable<Index> {
        SortedKeyValueIterator<Key, Value> iter;

        public Index(SortedKeyValueIterator<Key, Value> iter) {
            this.iter = iter;
        }

        @Override
        public int compareTo(Index o) {
            return this.iter.getTopKey().compareTo(o.iter.getTopKey());
        }
    }
}

