/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class PODemux
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    private static int idxPart = 127;
    private static Result empty = new Result(1, null);
    private static Result eop = new Result(3, null);
    private ArrayList<PhysicalPlan> myPlans = new ArrayList();
    private boolean getNext = true;
    private boolean inpEOP = false;
    private PhysicalOperator curLeaf = null;
    private PhysicalPlan curPlan = null;
    private boolean inCombiner = false;
    BitSet processedSet = new BitSet();

    public PODemux(OperatorKey k) {
        this(k, -1, null);
    }

    public PODemux(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public PODemux(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public PODemux(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitDemux(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Demux [" + this.myPlans.size() + "] " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    public List<PhysicalPlan> getPlans() {
        return this.myPlans;
    }

    public void addPlan(PhysicalPlan inPlan) {
        this.myPlans.add(inPlan);
        this.processedSet.set(this.myPlans.size() - 1);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (!this.inCombiner && this.parentPlan.endOfAllInput) {
            return this.getStreamCloseResult();
        }
        if (this.getNext) {
            if (this.curPlan != null) {
                this.curPlan.detachInput();
            }
            Result inp = this.processInput();
            if (inp.returnStatus == 3) {
                return inp;
            }
            this.curLeaf = this.attachInputWithIndex((Tuple)inp.result);
            this.getNext = false;
        }
        return this.runPipeline(this.curLeaf);
    }

    private Result runPipeline(PhysicalOperator leaf) throws ExecException {
        Result res = null;
        while (true) {
            res = leaf.getNextTuple();
            if (res.returnStatus == 0 || res.returnStatus == 3 || res.returnStatus == 2) break;
            if (res.returnStatus != 1) continue;
        }
        if (res.returnStatus == 3) {
            this.getNext = true;
        }
        return res.returnStatus == 0 || res.returnStatus == 2 ? res : empty;
    }

    private Result getStreamCloseResult() throws ExecException {
        Result res = null;
        while (true) {
            if (this.processedSet.cardinality() == this.myPlans.size()) {
                this.curLeaf = null;
                if (this.curPlan != null) {
                    this.curPlan.detachInput();
                }
                Result inp = this.processInput();
                if (inp.returnStatus == 0) {
                    this.attachInputWithIndex((Tuple)inp.result);
                    this.inpEOP = false;
                } else if (inp.returnStatus == 3) {
                    this.inpEOP = true;
                } else if (inp.returnStatus == 1) {
                    this.inpEOP = false;
                } else if (inp.returnStatus == 2) {
                    return inp;
                }
                this.processedSet.clear();
            }
            int idx = this.processedSet.nextClearBit(0);
            PhysicalOperator leaf = (PhysicalOperator)this.myPlans.get(idx).getLeaves().get(0);
            if (this.curLeaf != null && leaf.getOperatorKey().equals(this.curLeaf.getOperatorKey())) {
                this.processedSet.set(idx++);
                if (idx < this.myPlans.size()) continue;
                res = eop;
            } else {
                this.curLeaf = leaf;
                while (true) {
                    res = leaf.getNextTuple();
                    if (res.returnStatus == 0 || res.returnStatus == 3 || res.returnStatus == 2) break;
                    if (res.returnStatus != 1) continue;
                }
                if (res.returnStatus != 3) break;
                this.processedSet.set(idx++);
                if (idx < this.myPlans.size()) continue;
            }
            if (this.inpEOP || res.returnStatus != 3) break;
        }
        return res;
    }

    private PhysicalOperator attachInputWithIndex(Tuple res) throws ExecException {
        PigNullableWritable fld = (PigNullableWritable)res.get(0);
        int index = fld.getIndex();
        this.curPlan = this.myPlans.get(index &= idxPart);
        if (!(this.curPlan.getRoots().get(0) instanceof PODemux)) {
            res.set(0, fld.getValueAsPigType());
        }
        this.curPlan.attachInput(res);
        return (PhysicalOperator)this.curPlan.getLeaves().get(0);
    }

    public void setInCombiner(boolean inCombiner) {
        this.inCombiner = inCombiner;
    }

    public boolean isInCombiner() {
        return this.inCombiner;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }
}

