/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.MapreduceTestingShim;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableRecordReaderImpl;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={LargeTests.class})
public class TestTableInputFormat {
    private static final Log LOG = LogFactory.getLog(TestTableInputFormat.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[][] columns = new byte[][]{FAMILY};

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.setJobWithoutMRCluster();
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        LOG.info((Object)"before");
        UTIL.ensureSomeRegionServersAvailable(1);
        LOG.info((Object)"before done");
    }

    public static Table createTable(byte[] tableName) throws IOException {
        return TestTableInputFormat.createTable(tableName, new byte[][]{FAMILY});
    }

    public static Table createTable(byte[] tableName, byte[][] families) throws IOException {
        HTable table = UTIL.createTable(TableName.valueOf((byte[])tableName), families);
        Put p = new Put("aaa".getBytes());
        for (byte[] family : families) {
            p.add(family, null, "value aaa".getBytes());
        }
        table.put(p);
        p = new Put("bbb".getBytes());
        for (byte[] family : families) {
            p.add(family, null, "value bbb".getBytes());
        }
        table.put(p);
        return table;
    }

    static boolean checkResult(Result r, ImmutableBytesWritable key, byte[] expectedKey, byte[] expectedValue) {
        Assert.assertEquals((long)0L, (long)key.compareTo(expectedKey));
        NavigableMap vals = r.getFamilyMap(FAMILY);
        byte[] value = (byte[])vals.values().iterator().next();
        Assert.assertTrue((boolean)Arrays.equals(value, expectedValue));
        return true;
    }

    static void runTestMapreduce(Table table) throws IOException, InterruptedException {
        TableRecordReaderImpl trr = new TableRecordReaderImpl();
        Scan s = new Scan();
        s.setStartRow("aaa".getBytes());
        s.setStopRow("zzz".getBytes());
        s.addFamily(FAMILY);
        trr.setScan(s);
        trr.setHTable(table);
        trr.initialize(null, null);
        Result r = new Result();
        ImmutableBytesWritable key = new ImmutableBytesWritable();
        boolean more = trr.nextKeyValue();
        Assert.assertTrue((boolean)more);
        key = trr.getCurrentKey();
        r = trr.getCurrentValue();
        TestTableInputFormat.checkResult(r, key, "aaa".getBytes(), "value aaa".getBytes());
        more = trr.nextKeyValue();
        Assert.assertTrue((boolean)more);
        key = trr.getCurrentKey();
        r = trr.getCurrentValue();
        TestTableInputFormat.checkResult(r, key, "bbb".getBytes(), "value bbb".getBytes());
        more = trr.nextKeyValue();
        Assert.assertFalse((boolean)more);
    }

    static Table createIOEScannerTable(byte[] name, final int failCnt) throws IOException {
        Answer<ResultScanner> a = new Answer<ResultScanner>(){
            int cnt = 0;

            public ResultScanner answer(InvocationOnMock invocation) throws Throwable {
                if (this.cnt++ < failCnt) {
                    Scan scan = (Scan)Mockito.mock(Scan.class);
                    ((Scan)Mockito.doReturn((Object)"bogus".getBytes()).when((Object)scan)).getStartRow();
                    ResultScanner scanner = (ResultScanner)Mockito.mock(ResultScanner.class);
                    ((ResultScanner)Mockito.doThrow((Throwable)new IOException("Injected exception")).when((Object)scanner)).next();
                    return scanner;
                }
                return (ResultScanner)invocation.callRealMethod();
            }
        };
        Table htable = (Table)Mockito.spy((Object)TestTableInputFormat.createTable(name));
        ((Table)Mockito.doAnswer((Answer)a).when((Object)htable)).getScanner((Scan)Matchers.anyObject());
        return htable;
    }

    static Table createDNRIOEScannerTable(byte[] name, final int failCnt) throws IOException {
        Answer<ResultScanner> a = new Answer<ResultScanner>(){
            int cnt = 0;

            public ResultScanner answer(InvocationOnMock invocation) throws Throwable {
                if (this.cnt++ < failCnt) {
                    Scan scan = (Scan)Mockito.mock(Scan.class);
                    ((Scan)Mockito.doReturn((Object)"bogus".getBytes()).when((Object)scan)).getStartRow();
                    ResultScanner scanner = (ResultScanner)Mockito.mock(ResultScanner.class);
                    invocation.callRealMethod();
                    ((ResultScanner)Mockito.doThrow((Throwable)new NotServingRegionException("Injected simulated TimeoutException")).when((Object)scanner)).next();
                    return scanner;
                }
                return (ResultScanner)invocation.callRealMethod();
            }
        };
        Table htable = (Table)Mockito.spy((Object)TestTableInputFormat.createTable(name));
        ((Table)Mockito.doAnswer((Answer)a).when((Object)htable)).getScanner((Scan)Matchers.anyObject());
        return htable;
    }

    @Test
    public void testTableRecordReaderMapreduce() throws IOException, InterruptedException {
        Table table = TestTableInputFormat.createTable("table1-mr".getBytes());
        TestTableInputFormat.runTestMapreduce(table);
    }

    @Test
    public void testTableRecordReaderScannerFailMapreduce() throws IOException, InterruptedException {
        Table htable = TestTableInputFormat.createIOEScannerTable("table2-mr".getBytes(), 1);
        TestTableInputFormat.runTestMapreduce(htable);
    }

    @Test(expected=IOException.class)
    public void testTableRecordReaderScannerFailMapreduceTwice() throws IOException, InterruptedException {
        Table htable = TestTableInputFormat.createIOEScannerTable("table3-mr".getBytes(), 2);
        TestTableInputFormat.runTestMapreduce(htable);
    }

    @Test
    public void testTableRecordReaderScannerTimeoutMapreduce() throws IOException, InterruptedException {
        Table htable = TestTableInputFormat.createDNRIOEScannerTable("table4-mr".getBytes(), 1);
        TestTableInputFormat.runTestMapreduce(htable);
    }

    @Test(expected=NotServingRegionException.class)
    public void testTableRecordReaderScannerTimeoutMapreduceTwice() throws IOException, InterruptedException {
        Table htable = TestTableInputFormat.createDNRIOEScannerTable("table5-mr".getBytes(), 2);
        TestTableInputFormat.runTestMapreduce(htable);
    }

    @Test
    public void testExtensionOfTableInputFormatBase() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"testing use of an InputFormat taht extends InputFormatBase");
        Table htable = TestTableInputFormat.createTable(Bytes.toBytes((String)"exampleTable"), new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")});
        this.testInputFormat(ExampleTIF.class);
    }

    @Test
    public void testJobConfigurableExtensionOfTableInputFormatBase() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"testing use of an InputFormat taht extends InputFormatBase, using JobConfigurable.");
        Table htable = TestTableInputFormat.createTable(Bytes.toBytes((String)"exampleJobConfigurableTable"), new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")});
        this.testInputFormat(ExampleJobConfigurableTIF.class);
    }

    @Test
    public void testDeprecatedExtensionOfTableInputFormatBase() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"testing use of an InputFormat taht extends InputFormatBase, using the approach documented in 0.98.");
        Table htable = TestTableInputFormat.createTable(Bytes.toBytes((String)"exampleDeprecatedTable"), new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")});
        this.testInputFormat(ExampleDeprecatedTIF.class);
    }

    void testInputFormat(Class<? extends InputFormat> clazz) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = MapreduceTestingShim.createJob(UTIL.getConfiguration());
        job.setInputFormatClass(clazz);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapperClass(ExampleVerifier.class);
        job.setNumReduceTasks(0);
        LOG.debug((Object)"submitting job.");
        Assert.assertTrue((String)"job failed!", (boolean)job.waitForCompletion(true));
        Assert.assertEquals((String)"Saw the wrong number of instances of the filtered-for row.", (long)2L, (long)job.getCounters().findCounter(TestTableInputFormat.class.getName() + ":row", "aaa").getValue());
        Assert.assertEquals((String)"Saw any instances of the filtered out row.", (long)0L, (long)job.getCounters().findCounter(TestTableInputFormat.class.getName() + ":row", "bbb").getValue());
        Assert.assertEquals((String)"Saw the wrong number of instances of columnA.", (long)1L, (long)job.getCounters().findCounter(TestTableInputFormat.class.getName() + ":family", "columnA").getValue());
        Assert.assertEquals((String)"Saw the wrong number of instances of columnB.", (long)1L, (long)job.getCounters().findCounter(TestTableInputFormat.class.getName() + ":family", "columnB").getValue());
        Assert.assertEquals((String)"Saw the wrong count of values for the filtered-for row.", (long)2L, (long)job.getCounters().findCounter(TestTableInputFormat.class.getName() + ":value", "value aaa").getValue());
        Assert.assertEquals((String)"Saw the wrong count of values for the filtered-out row.", (long)0L, (long)job.getCounters().findCounter(TestTableInputFormat.class.getName() + ":value", "value bbb").getValue());
    }

    public static class ExampleTIF
    extends TableInputFormatBase {
        protected void initialize(JobContext job) throws IOException {
            Connection connection = ConnectionFactory.createConnection((Configuration)HBaseConfiguration.create((Configuration)job.getConfiguration()));
            TableName tableName = TableName.valueOf((String)"exampleTable");
            this.initializeTable(connection, tableName);
            byte[][] inputColumns = new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")};
            Scan scan = new Scan();
            for (byte[] family : inputColumns) {
                scan.addFamily(family);
            }
            RowFilter exampleFilter = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator("aa.*"));
            scan.setFilter((Filter)exampleFilter);
            this.setScan(scan);
        }
    }

    public static class ExampleJobConfigurableTIF
    extends TableInputFormatBase
    implements JobConfigurable {
        public void configure(JobConf job) {
            try {
                Connection connection = ConnectionFactory.createConnection((Configuration)HBaseConfiguration.create((Configuration)job));
                TableName tableName = TableName.valueOf((String)"exampleJobConfigurableTable");
                this.initializeTable(connection, tableName);
                byte[][] inputColumns = new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")};
                Scan scan = new Scan();
                for (byte[] family : inputColumns) {
                    scan.addFamily(family);
                }
                RowFilter exampleFilter = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator("aa.*"));
                scan.setFilter((Filter)exampleFilter);
                this.setScan(scan);
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to initialize.", exception);
            }
        }
    }

    public static class ExampleDeprecatedTIF
    extends TableInputFormatBase
    implements JobConfigurable {
        public void configure(JobConf job) {
            try {
                HTable exampleTable = new HTable(HBaseConfiguration.create((Configuration)job), Bytes.toBytes((String)"exampleDeprecatedTable"));
                this.setHTable(exampleTable);
                byte[][] inputColumns = new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")};
                Scan scan = new Scan();
                for (byte[] family : inputColumns) {
                    scan.addFamily(family);
                }
                RowFilter exampleFilter = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator("aa.*"));
                scan.setFilter((Filter)exampleFilter);
                this.setScan(scan);
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to configure for job.", exception);
            }
        }
    }

    public static class ExampleVerifier
    extends TableMapper<NullWritable, NullWritable> {
        public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException {
            for (Cell cell : value.listCells()) {
                context.getCounter(TestTableInputFormat.class.getName() + ":row", Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength())).increment(1L);
                context.getCounter(TestTableInputFormat.class.getName() + ":family", Bytes.toString((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength())).increment(1L);
                context.getCounter(TestTableInputFormat.class.getName() + ":value", Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength())).increment(1L);
            }
        }
    }
}

