/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureRunnableSet;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterProcedureScheduler
implements ProcedureRunnableSet {
    private static final Log LOG = LogFactory.getLog(MasterProcedureScheduler.class);
    private final TableLockManager lockManager;
    private final ReentrantLock schedLock = new ReentrantLock();
    private final Condition schedWaitCond = this.schedLock.newCondition();
    private final FairQueue<ServerName> serverRunQueue = new FairQueue();
    private final FairQueue<TableName> tableRunQueue = new FairQueue();
    private int queueSize = 0;
    private final Object[] serverBuckets = new Object[128];
    private Queue<String> namespaceMap = null;
    private Queue<TableName> tableMap = null;
    private final int metaTablePriority;
    private final int userTablePriority;
    private final int sysTablePriority;
    private long pollCalls = 0L;
    private long nullPollCalls = 0L;

    public MasterProcedureScheduler(Configuration conf, TableLockManager lockManager) {
        this.lockManager = lockManager;
        this.metaTablePriority = conf.getInt("hbase.master.procedure.queue.meta.table.priority", 3);
        this.sysTablePriority = conf.getInt("hbase.master.procedure.queue.system.table.priority", 2);
        this.userTablePriority = conf.getInt("hbase.master.procedure.queue.user.table.priority", 1);
    }

    public void addFront(Procedure proc) {
        this.doAdd(proc, true);
    }

    public void addBack(Procedure proc) {
        this.doAdd(proc, false);
    }

    public void yield(Procedure proc) {
        this.doAdd(proc, MasterProcedureScheduler.isTableProcedure(proc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(Procedure proc, boolean addFront) {
        this.schedLock.lock();
        try {
            if (MasterProcedureScheduler.isTableProcedure(proc)) {
                this.doAdd(this.tableRunQueue, this.getTableQueue(MasterProcedureScheduler.getTableName(proc)), proc, addFront);
            } else if (MasterProcedureScheduler.isServerProcedure(proc)) {
                this.doAdd(this.serverRunQueue, this.getServerQueue(MasterProcedureScheduler.getServerName(proc)), proc, addFront);
            } else {
                throw new UnsupportedOperationException("RQs for non-table/non-server procedures are not implemented yet");
            }
            this.schedWaitCond.signal();
        }
        finally {
            this.schedLock.unlock();
        }
    }

    private <T extends Comparable<T>> void doAdd(FairQueue<T> fairq, Queue<T> queue, Procedure proc, boolean addFront) {
        queue.add(proc, addFront);
        if (!queue.isSuspended() && !queue.hasExclusiveLock()) {
            if (queue.size() == 1 && !IterableList.isLinked(queue)) {
                fairq.add(queue);
            }
            ++this.queueSize;
        }
    }

    public Procedure poll() {
        return this.poll(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"WA_AWAIT_NOT_IN_LOOP"})
    Procedure poll(long waitNsec) {
        Procedure pollResult = null;
        this.schedLock.lock();
        try {
            if (this.queueSize == 0) {
                if (waitNsec < 0L) {
                    this.schedWaitCond.await();
                } else {
                    this.schedWaitCond.awaitNanos(waitNsec);
                }
                if (this.queueSize == 0) {
                    Procedure procedure = null;
                    return procedure;
                }
            }
            if ((pollResult = this.doPoll(this.serverRunQueue)) == null) {
                pollResult = this.doPoll(this.tableRunQueue);
            }
            ++this.pollCalls;
            this.nullPollCalls += pollResult == null ? 1L : 0L;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.schedLock.unlock();
        }
        return pollResult;
    }

    private <T extends Comparable<T>> Procedure doPoll(FairQueue<T> fairq) {
        Queue<T> rq = fairq.poll();
        if (rq == null || !rq.isAvailable()) {
            return null;
        }
        assert (!rq.isSuspended()) : "rq=" + rq + " is suspended";
        Procedure pollResult = rq.poll();
        --this.queueSize;
        if (rq.isEmpty() || rq.requireExclusiveLock(pollResult)) {
            this.removeFromRunQueue(fairq, rq);
        }
        return pollResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.schedLock.lock();
        try {
            for (int i = 0; i < this.serverBuckets.length; ++i) {
                this.clear((ServerQueue)this.serverBuckets[i], this.serverRunQueue);
                this.serverBuckets[i] = null;
            }
            this.clear(this.tableMap, this.tableRunQueue);
            this.tableMap = null;
            assert (this.queueSize == 0) : "expected queue size to be 0, got " + this.queueSize;
        }
        finally {
            this.schedLock.unlock();
        }
    }

    private <T extends Comparable<T>> void clear(Queue<T> treeMap, FairQueue<T> fairq) {
        while (treeMap != null) {
            Queue<T> node = AvlTree.getFirst(treeMap);
            assert (!node.isSuspended()) : "can't clear suspended " + node.getKey();
            treeMap = AvlTree.remove(treeMap, node.getKey());
            this.removeFromRunQueue(fairq, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAll() {
        this.schedLock.lock();
        try {
            this.schedWaitCond.signalAll();
        }
        finally {
            this.schedLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.schedLock.lock();
        try {
            int n = this.queueSize;
            return n;
        }
        finally {
            this.schedLock.unlock();
        }
    }

    public void completionCleanup(Procedure proc) {
        if (proc instanceof TableProcedureInterface) {
            boolean tableDeleted;
            TableProcedureInterface iProcTable = (TableProcedureInterface)proc;
            if (proc.hasException()) {
                IOException procEx = proc.getException().unwrapRemoteException();
                tableDeleted = iProcTable.getTableOperationType() == TableProcedureInterface.TableOperationType.CREATE ? !(procEx instanceof TableExistsException) : procEx instanceof TableNotFoundException;
            } else {
                boolean bl = tableDeleted = iProcTable.getTableOperationType() == TableProcedureInterface.TableOperationType.DELETE;
            }
            if (tableDeleted) {
                this.markTableAsDeleted(iProcTable.getTableName());
                return;
            }
        } else {
            return;
        }
    }

    private <T extends Comparable<T>> void addToRunQueue(FairQueue<T> fairq, Queue<T> queue) {
        if (IterableList.isLinked(queue)) {
            return;
        }
        if (!queue.isEmpty()) {
            fairq.add(queue);
            this.queueSize += queue.size();
        }
    }

    private <T extends Comparable<T>> void removeFromRunQueue(FairQueue<T> fairq, Queue<T> queue) {
        if (!IterableList.isLinked(queue)) {
            return;
        }
        fairq.remove(queue);
        this.queueSize -= queue.size();
    }

    public long getPollCalls() {
        return this.pollCalls;
    }

    public long getNullPollCalls() {
        return this.nullPollCalls;
    }

    public boolean waitEvent(ProcedureEvent event, Procedure procedure) {
        return this.waitEvent(event, procedure, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitEvent(ProcedureEvent event, Procedure procedure, boolean suspendQueue) {
        ProcedureEvent procedureEvent = event;
        synchronized (procedureEvent) {
            if (event.isReady()) {
                return false;
            }
            if (!suspendQueue) {
                suspendQueue = true;
            }
            if (MasterProcedureScheduler.isTableProcedure(procedure)) {
                this.suspendTableQueue(event, MasterProcedureScheduler.getTableName(procedure));
            } else if (MasterProcedureScheduler.isServerProcedure(procedure)) {
                this.suspendServerQueue(event, MasterProcedureScheduler.getServerName(procedure));
            } else {
                throw new UnsupportedOperationException("RQs for non-table/non-server procedures are not implemented yet");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendTableQueue(ProcedureEvent event, TableName tableName) {
        this.schedLock.lock();
        try {
            TableQueue queue = this.getTableQueue(tableName);
            if (!queue.setSuspended(true)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Suspend table queue " + tableName));
            }
            this.removeFromRunQueue(this.tableRunQueue, queue);
            event.suspendTableQueue(queue);
        }
        finally {
            this.schedLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendServerQueue(ProcedureEvent event, ServerName serverName) {
        this.schedLock.lock();
        try {
            ServerQueue queue = this.getServerQueue(serverName);
            if (!queue.setSuspended(true)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Suspend server queue " + serverName));
            }
            this.removeFromRunQueue(this.serverRunQueue, queue);
            event.suspendServerQueue(queue);
        }
        finally {
            this.schedLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(ProcedureEvent event) {
        ProcedureEvent procedureEvent = event;
        synchronized (procedureEvent) {
            event.setReady(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Suspend event " + event));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake(ProcedureEvent event) {
        ProcedureEvent procedureEvent = event;
        synchronized (procedureEvent) {
            event.setReady(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Wake event " + event));
            }
            this.schedLock.lock();
            try {
                Queue queue;
                while (event.hasWaitingTables()) {
                    queue = event.popWaitingTable();
                    this.addToRunQueue(this.tableRunQueue, queue);
                }
                while (event.hasWaitingServers()) {
                    queue = event.popWaitingServer();
                    this.addToRunQueue(this.serverRunQueue, queue);
                }
                if (this.queueSize > 1) {
                    this.schedWaitCond.signalAll();
                } else if (this.queueSize > 0) {
                    this.schedWaitCond.signal();
                }
            }
            finally {
                this.schedLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableQueue getTableQueueWithLock(TableName tableName) {
        this.schedLock.lock();
        try {
            TableQueue tableQueue = this.getTableQueue(tableName);
            return tableQueue;
        }
        finally {
            this.schedLock.unlock();
        }
    }

    private TableQueue getTableQueue(TableName tableName) {
        TableQueue node = AvlTree.get(this.tableMap, tableName);
        if (node != null) {
            return node;
        }
        node = new TableQueue(tableName, this.getTablePriority(tableName));
        this.tableMap = AvlTree.insert(this.tableMap, node);
        return node;
    }

    private void removeTableQueue(TableName tableName) {
        this.tableMap = AvlTree.remove(this.tableMap, tableName);
    }

    private int getTablePriority(TableName tableName) {
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            return this.metaTablePriority;
        }
        if (tableName.isSystemTable()) {
            return this.sysTablePriority;
        }
        return this.userTablePriority;
    }

    private static boolean isTableProcedure(Procedure proc) {
        return proc instanceof TableProcedureInterface;
    }

    private static TableName getTableName(Procedure proc) {
        return ((TableProcedureInterface)proc).getTableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerQueue getServerQueueWithLock(ServerName serverName) {
        this.schedLock.lock();
        try {
            ServerQueue serverQueue = this.getServerQueue(serverName);
            return serverQueue;
        }
        finally {
            this.schedLock.unlock();
        }
    }

    private ServerQueue getServerQueue(ServerName serverName) {
        int index = MasterProcedureScheduler.getBucketIndex(this.serverBuckets, serverName.hashCode());
        Queue root = MasterProcedureScheduler.getTreeRoot(this.serverBuckets, index);
        ServerQueue node = AvlTree.get(root, serverName);
        if (node != null) {
            return node;
        }
        node = new ServerQueue(serverName);
        this.serverBuckets[index] = AvlTree.insert(root, node);
        return node;
    }

    private void removeServerQueue(ServerName serverName) {
        int index = MasterProcedureScheduler.getBucketIndex(this.serverBuckets, serverName.hashCode());
        this.serverBuckets[index] = AvlTree.remove((ServerQueue)this.serverBuckets[index], serverName);
    }

    private static <T extends Comparable<T>> Queue<T> getTreeRoot(Object[] buckets, int index) {
        return (Queue)buckets[index];
    }

    private static int getBucketIndex(Object[] buckets, int hashCode) {
        return Math.abs(hashCode) % buckets.length;
    }

    private static boolean isServerProcedure(Procedure proc) {
        return proc instanceof ServerProcedureInterface;
    }

    private static ServerName getServerName(Procedure proc) {
        return ((ServerProcedureInterface)proc).getServerName();
    }

    public boolean tryAcquireTableExclusiveLock(Procedure procedure, TableName table) {
        this.schedLock.lock();
        TableQueue queue = this.getTableQueue(table);
        if (!queue.tryExclusiveLock(procedure.getProcId())) {
            this.schedLock.unlock();
            return false;
        }
        this.removeFromRunQueue(this.tableRunQueue, queue);
        this.schedLock.unlock();
        boolean hasXLock = queue.tryZkExclusiveLock(this.lockManager, procedure.toString());
        if (!hasXLock) {
            this.schedLock.lock();
            queue.releaseExclusiveLock();
            this.addToRunQueue(this.tableRunQueue, queue);
            this.schedLock.unlock();
        }
        return hasXLock;
    }

    public void releaseTableExclusiveLock(Procedure procedure, TableName table) {
        this.schedLock.lock();
        TableQueue queue = this.getTableQueue(table);
        this.schedLock.unlock();
        queue.releaseZkExclusiveLock(this.lockManager);
        this.schedLock.lock();
        queue.releaseExclusiveLock();
        this.addToRunQueue(this.tableRunQueue, queue);
        this.schedLock.unlock();
    }

    public boolean tryAcquireTableSharedLock(Procedure procedure, TableName table) {
        return this.tryAcquireTableQueueSharedLock(procedure, table) != null;
    }

    private TableQueue tryAcquireTableQueueSharedLock(Procedure procedure, TableName table) {
        TableQueue queue = this.getTableQueueWithLock(table);
        if (!queue.trySharedLock(this.lockManager, procedure.toString())) {
            return null;
        }
        return queue;
    }

    public void releaseTableSharedLock(Procedure procedure, TableName table) {
        this.getTableQueueWithLock(table).releaseSharedLock(this.lockManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean markTableAsDeleted(TableName table) {
        block9: {
            ReentrantLock l = this.schedLock;
            l.lock();
            try {
                TableQueue queue = this.getTableQueue(table);
                if (queue == null) {
                    boolean bl = true;
                    return bl;
                }
                if (queue.isEmpty() && queue.tryExclusiveLock(0L)) {
                    if (IterableList.isLinked(queue)) {
                        this.tableRunQueue.remove(queue);
                    }
                    try {
                        this.lockManager.tableDeleted(table);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Received exception from TableLockManager.tableDeleted:", (Throwable)e);
                    }
                    this.removeTableQueue(table);
                    break block9;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquireServerExclusiveLock(Procedure procedure, ServerName serverName) {
        this.schedLock.lock();
        try {
            ServerQueue queue = this.getServerQueue(serverName);
            if (queue.tryExclusiveLock(procedure.getProcId())) {
                this.removeFromRunQueue(this.serverRunQueue, queue);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.schedLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseServerExclusiveLock(Procedure procedure, ServerName serverName) {
        this.schedLock.lock();
        try {
            ServerQueue queue = this.getServerQueue(serverName);
            queue.releaseExclusiveLock();
            this.addToRunQueue(this.serverRunQueue, queue);
        }
        finally {
            this.schedLock.unlock();
        }
    }

    public boolean tryAcquireServerSharedLock(Procedure procedure, ServerName serverName) {
        return this.getServerQueueWithLock(serverName).trySharedLock();
    }

    public void releaseServerSharedLock(Procedure procedure, ServerName serverName) {
        this.getServerQueueWithLock(serverName).releaseSharedLock();
    }

    private static class IterableList {
        private IterableList() {
        }

        public static <T extends Comparable<T>> Queue<T> prepend(Queue<T> head, Queue<T> node) {
            assert (!IterableList.isLinked(node)) : node + " is already linked";
            if (head != null) {
                Queue tail = ((Queue)head).iterPrev;
                tail.iterNext = (Queue)node;
                ((Queue)head).iterPrev = (Queue)node;
                ((Queue)node).iterNext = (Queue)head;
                ((Queue)node).iterPrev = tail;
            } else {
                ((Queue)node).iterNext = (Queue)node;
                ((Queue)node).iterPrev = (Queue)node;
            }
            return node;
        }

        public static <T extends Comparable<T>> Queue<T> append(Queue<T> head, Queue<T> node) {
            assert (!IterableList.isLinked(node)) : node + " is already linked";
            if (head != null) {
                Queue tail = ((Queue)head).iterPrev;
                tail.iterNext = (Queue)node;
                ((Queue)node).iterNext = (Queue)head;
                ((Queue)node).iterPrev = tail;
                ((Queue)head).iterPrev = (Queue)node;
                return head;
            }
            ((Queue)node).iterNext = (Queue)node;
            ((Queue)node).iterPrev = (Queue)node;
            return node;
        }

        public static <T extends Comparable<T>> Queue<T> appendList(Queue<T> head, Queue<T> otherHead) {
            if (head == null) {
                return otherHead;
            }
            if (otherHead == null) {
                return head;
            }
            Queue tail = ((Queue)head).iterPrev;
            Queue otherTail = ((Queue)otherHead).iterPrev;
            tail.iterNext = (Queue)otherHead;
            ((Queue)otherHead).iterPrev = tail;
            otherTail.iterNext = (Queue)head;
            ((Queue)head).iterPrev = otherTail;
            return head;
        }

        private static <T extends Comparable<T>> Queue<T> remove(Queue<T> head, Queue<T> node) {
            assert (IterableList.isLinked(node)) : node + " is not linked";
            if (node != ((Queue)node).iterNext) {
                ((Queue)node).iterPrev.iterNext = ((Queue)node).iterNext;
                ((Queue)node).iterNext.iterPrev = ((Queue)node).iterPrev;
                head = head == node ? ((Queue)node).iterNext : head;
            } else {
                head = null;
            }
            ((Queue)node).iterNext = null;
            ((Queue)node).iterPrev = null;
            return head;
        }

        private static <T extends Comparable<T>> boolean isLinked(Queue<T> node) {
            return ((Queue)node).iterPrev != null && ((Queue)node).iterNext != null;
        }
    }

    private static class AvlTree {
        private AvlTree() {
        }

        public static <T extends Comparable<T>> Queue<T> get(Queue<T> root, T key) {
            while (root != null) {
                int cmp = root.compareKey(key);
                if (cmp > 0) {
                    root = root.avlLeft;
                    continue;
                }
                if (cmp < 0) {
                    root = root.avlRight;
                    continue;
                }
                return root;
            }
            return null;
        }

        public static <T extends Comparable<T>> Queue<T> getFirst(Queue<T> root) {
            if (root != null) {
                while (root.avlLeft != null) {
                    root = root.avlLeft;
                }
            }
            return root;
        }

        public static <T extends Comparable<T>> Queue<T> getLast(Queue<T> root) {
            if (root != null) {
                while (root.avlRight != null) {
                    root = root.avlRight;
                }
            }
            return root;
        }

        public static <T extends Comparable<T>> Queue<T> insert(Queue<T> root, Queue<T> node) {
            if (root == null) {
                return node;
            }
            if (node.compareTo(root) < 0) {
                ((Queue)root).avlLeft = (Queue)AvlTree.insert(((Queue)root).avlLeft, node);
            } else {
                ((Queue)root).avlRight = (Queue)AvlTree.insert(((Queue)root).avlRight, node);
            }
            return AvlTree.balance(root);
        }

        private static <T extends Comparable<T>> Queue<T> removeMin(Queue<T> p) {
            if (((Queue)p).avlLeft == null) {
                return ((Queue)p).avlRight;
            }
            ((Queue)p).avlLeft = (Queue)AvlTree.removeMin(((Queue)p).avlLeft);
            return AvlTree.balance(p);
        }

        public static <T extends Comparable<T>> Queue<T> remove(Queue<T> root, T key) {
            if (root == null) {
                return null;
            }
            int cmp = root.compareKey(key);
            if (cmp == 0) {
                Queue q = ((Queue)root).avlLeft;
                Queue r = ((Queue)root).avlRight;
                if (r == null) {
                    return q;
                }
                Queue<T> min = AvlTree.getFirst(r);
                ((Queue)min).avlRight = (Queue)AvlTree.removeMin(r);
                ((Queue)min).avlLeft = q;
                return AvlTree.balance(min);
            }
            if (cmp > 0) {
                ((Queue)root).avlLeft = (Queue)AvlTree.remove(((Queue)root).avlLeft, key);
            } else {
                ((Queue)root).avlRight = (Queue)AvlTree.remove(((Queue)root).avlRight, key);
            }
            return AvlTree.balance(root);
        }

        private static <T extends Comparable<T>> Queue<T> balance(Queue<T> p) {
            AvlTree.fixHeight(p);
            int balance = AvlTree.balanceFactor(p);
            if (balance == 2) {
                if (AvlTree.balanceFactor(((Queue)p).avlRight) < 0) {
                    ((Queue)p).avlRight = (Queue)AvlTree.rotateRight(((Queue)p).avlRight);
                }
                return AvlTree.rotateLeft(p);
            }
            if (balance == -2) {
                if (AvlTree.balanceFactor(((Queue)p).avlLeft) > 0) {
                    ((Queue)p).avlLeft = (Queue)AvlTree.rotateLeft(((Queue)p).avlLeft);
                }
                return AvlTree.rotateRight(p);
            }
            return p;
        }

        private static <T extends Comparable<T>> Queue<T> rotateRight(Queue<T> p) {
            Queue q = ((Queue)p).avlLeft;
            ((Queue)p).avlLeft = q.avlRight;
            q.avlRight = (Queue)p;
            AvlTree.fixHeight(p);
            AvlTree.fixHeight(q);
            return q;
        }

        private static <T extends Comparable<T>> Queue<T> rotateLeft(Queue<T> q) {
            Queue p = ((Queue)q).avlRight;
            ((Queue)q).avlRight = p.avlLeft;
            p.avlLeft = (Queue)q;
            AvlTree.fixHeight(q);
            AvlTree.fixHeight(p);
            return p;
        }

        private static <T extends Comparable<T>> void fixHeight(Queue<T> node) {
            int heightLeft = AvlTree.height(((Queue)node).avlLeft);
            int heightRight = AvlTree.height(((Queue)node).avlRight);
            ((Queue)node).avlHeight = 1 + Math.max(heightLeft, heightRight);
        }

        private static <T extends Comparable<T>> int height(Queue<T> node) {
            return node != null ? ((Queue)node).avlHeight : 0;
        }

        private static <T extends Comparable<T>> int balanceFactor(Queue<T> node) {
            return AvlTree.height(((Queue)node).avlRight) - AvlTree.height(((Queue)node).avlLeft);
        }
    }

    private static class FairQueue<T extends Comparable<T>> {
        private final int quantum;
        private Queue<T> currentQueue = null;
        private Queue<T> queueHead = null;
        private int currentQuantum = 0;

        public FairQueue() {
            this(1);
        }

        public FairQueue(int quantum) {
            this.quantum = quantum;
        }

        public void add(Queue<T> queue) {
            this.queueHead = IterableList.append(this.queueHead, queue);
            if (this.currentQueue == null) {
                this.setNextQueue(this.queueHead);
            }
        }

        public void remove(Queue<T> queue) {
            Queue nextQueue = ((Queue)queue).iterNext;
            this.queueHead = IterableList.remove(this.queueHead, queue);
            if (this.currentQueue == queue) {
                this.setNextQueue(this.queueHead != null ? nextQueue : null);
            }
        }

        public Queue<T> poll() {
            if (this.currentQuantum == 0) {
                if (!this.nextQueue()) {
                    return null;
                }
                this.currentQuantum = this.calculateQuantum(this.currentQueue) - 1;
            } else {
                --this.currentQuantum;
            }
            if (!this.currentQueue.isAvailable()) {
                Queue<T> lastQueue = this.currentQueue;
                do {
                    if (this.nextQueue()) continue;
                    return null;
                } while (this.currentQueue != lastQueue && !this.currentQueue.isAvailable());
                this.currentQuantum = this.calculateQuantum(this.currentQueue) - 1;
            }
            return this.currentQueue;
        }

        private boolean nextQueue() {
            if (this.currentQueue == null) {
                return false;
            }
            this.currentQueue = ((Queue)this.currentQueue).iterNext;
            return this.currentQueue != null;
        }

        private void setNextQueue(Queue<T> queue) {
            this.currentQueue = queue;
            this.currentQuantum = queue != null ? this.calculateQuantum(this.currentQueue) : 0;
        }

        private int calculateQuantum(Queue queue) {
            return Math.max(1, queue.getPriority() * this.quantum);
        }
    }

    private static abstract class QueueImpl<TKey extends Comparable<TKey>>
    extends Queue<TKey> {
        private final ArrayDeque<Procedure> runnables = new ArrayDeque();

        public QueueImpl(TKey key) {
            super(key);
        }

        public QueueImpl(TKey key, int priority) {
            super(key, priority);
        }

        @Override
        public void add(Procedure proc, boolean addToFront) {
            if (addToFront) {
                this.addFront(proc);
            } else {
                this.addBack(proc);
            }
        }

        protected void addFront(Procedure proc) {
            this.runnables.addFirst(proc);
        }

        protected void addBack(Procedure proc) {
            this.runnables.addLast(proc);
        }

        @Override
        public Procedure peek() {
            return this.runnables.peek();
        }

        @Override
        public Procedure poll() {
            return this.runnables.poll();
        }

        @Override
        public boolean isEmpty() {
            return this.runnables.isEmpty();
        }

        @Override
        public int size() {
            return this.runnables.size();
        }
    }

    private static abstract class Queue<TKey extends Comparable<TKey>>
    implements QueueInterface {
        private Queue<TKey> avlRight = null;
        private Queue<TKey> avlLeft = null;
        private int avlHeight = 1;
        private Queue<TKey> iterNext = null;
        private Queue<TKey> iterPrev = null;
        private boolean suspended = false;
        private long exclusiveLockProcIdOwner = Long.MIN_VALUE;
        private int sharedLock = 0;
        private final TKey key;
        private final int priority;

        public Queue(TKey key) {
            this(key, 1);
        }

        public Queue(TKey key, int priority) {
            this.key = key;
            this.priority = priority;
        }

        protected TKey getKey() {
            return this.key;
        }

        protected int getPriority() {
            return this.priority;
        }

        @Override
        public boolean isSuspended() {
            return this.suspended;
        }

        protected boolean setSuspended(boolean isSuspended) {
            if (this.suspended == isSuspended) {
                return false;
            }
            this.suspended = isSuspended;
            return true;
        }

        public synchronized boolean isLocked() {
            return this.hasExclusiveLock() || this.sharedLock > 0;
        }

        public synchronized boolean hasExclusiveLock() {
            return this.exclusiveLockProcIdOwner != Long.MIN_VALUE;
        }

        public synchronized boolean trySharedLock() {
            if (this.hasExclusiveLock()) {
                return false;
            }
            ++this.sharedLock;
            return true;
        }

        public synchronized void releaseSharedLock() {
            --this.sharedLock;
        }

        protected synchronized boolean isSingleSharedLock() {
            return this.sharedLock == 1;
        }

        public synchronized boolean tryExclusiveLock(long procIdOwner) {
            assert (procIdOwner != Long.MIN_VALUE);
            if (this.isLocked()) {
                return false;
            }
            this.exclusiveLockProcIdOwner = procIdOwner;
            return true;
        }

        public synchronized void releaseExclusiveLock() {
            this.exclusiveLockProcIdOwner = Long.MIN_VALUE;
        }

        @Override
        public synchronized boolean isAvailable() {
            return !this.hasExclusiveLock() && !this.isEmpty();
        }

        public int compareKey(TKey cmpKey) {
            return this.key.compareTo(cmpKey);
        }

        public int compareTo(Queue<TKey> other) {
            return this.compareKey(other.key);
        }

        public String toString() {
            return String.format("%s(%s)", this.getClass().getSimpleName(), this.key);
        }
    }

    private static interface QueueInterface {
        public boolean isAvailable();

        public boolean isEmpty();

        public int size();

        public void add(Procedure var1, boolean var2);

        public boolean requireExclusiveLock(Procedure var1);

        public Procedure peek();

        public Procedure poll();

        public boolean isSuspended();
    }

    public static class TableQueue
    extends QueueImpl<TableName> {
        private TableLockManager.TableLock tableLock = null;

        public TableQueue(TableName tableName, int priority) {
            super(tableName, priority);
        }

        private boolean canAbortPendingOperations(Procedure proc) {
            TableProcedureInterface tpi = (TableProcedureInterface)proc;
            switch (tpi.getTableOperationType()) {
                case DELETE: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean requireExclusiveLock(Procedure proc) {
            TableProcedureInterface tpi = (TableProcedureInterface)proc;
            switch (tpi.getTableOperationType()) {
                case DELETE: 
                case CREATE: 
                case DISABLE: 
                case EDIT: 
                case ENABLE: {
                    return true;
                }
                case READ: {
                    return false;
                }
            }
            throw new UnsupportedOperationException("unexpected type " + (Object)((Object)tpi.getTableOperationType()));
        }

        private synchronized boolean trySharedLock(TableLockManager lockManager, String purpose) {
            if (this.hasExclusiveLock()) {
                return false;
            }
            TableName tableName = (TableName)this.getKey();
            this.tableLock = lockManager.readLock(tableName, purpose);
            try {
                this.tableLock.acquire();
            }
            catch (IOException e) {
                LOG.error((Object)("failed acquire read lock on " + tableName), (Throwable)e);
                this.tableLock = null;
                return false;
            }
            this.trySharedLock();
            return true;
        }

        private synchronized void releaseSharedLock(TableLockManager lockManager) {
            this.releaseTableLock(lockManager, this.isSingleSharedLock());
            this.releaseSharedLock();
        }

        private synchronized boolean tryZkExclusiveLock(TableLockManager lockManager, String purpose) {
            TableName tableName = (TableName)this.getKey();
            this.tableLock = lockManager.writeLock(tableName, purpose);
            try {
                this.tableLock.acquire();
            }
            catch (IOException e) {
                LOG.error((Object)("failed acquire write lock on " + tableName), (Throwable)e);
                this.tableLock = null;
                return false;
            }
            return true;
        }

        private synchronized void releaseZkExclusiveLock(TableLockManager lockManager) {
            this.releaseTableLock(lockManager, true);
        }

        private void releaseTableLock(TableLockManager lockManager, boolean reset) {
            for (int i = 0; i < 3; ++i) {
                try {
                    this.tableLock.release();
                    if (!reset) break;
                    this.tableLock = null;
                    break;
                }
                catch (IOException e) {
                    LOG.warn((Object)"Could not release the table write-lock", (Throwable)e);
                    continue;
                }
            }
        }
    }

    public static class ServerQueue
    extends QueueImpl<ServerName> {
        public ServerQueue(ServerName serverName) {
            super(serverName);
        }

        @Override
        public boolean requireExclusiveLock(Procedure proc) {
            ServerProcedureInterface spi = (ServerProcedureInterface)proc;
            switch (spi.getServerOperationType()) {
                case CRASH_HANDLER: {
                    return true;
                }
            }
            throw new UnsupportedOperationException("unexpected type " + (Object)((Object)spi.getServerOperationType()));
        }
    }

    public static class ProcedureEvent {
        private final String description;
        private Queue<ServerName> waitingServers = null;
        private Queue<TableName> waitingTables = null;
        private boolean ready = false;

        public ProcedureEvent(String description) {
            this.description = description;
        }

        public synchronized boolean isReady() {
            return this.ready;
        }

        private synchronized void setReady(boolean isReady) {
            this.ready = isReady;
        }

        private void suspendTableQueue(Queue<TableName> queue) {
            this.waitingTables = IterableList.append(this.waitingTables, queue);
        }

        private void suspendServerQueue(Queue<ServerName> queue) {
            this.waitingServers = IterableList.append(this.waitingServers, queue);
        }

        private boolean hasWaitingTables() {
            return this.waitingTables != null;
        }

        private Queue<TableName> popWaitingTable() {
            Queue<TableName> node = this.waitingTables;
            this.waitingTables = IterableList.remove(this.waitingTables, node);
            node.setSuspended(false);
            return node;
        }

        private boolean hasWaitingServers() {
            return this.waitingServers != null;
        }

        private Queue<ServerName> popWaitingServer() {
            Queue<ServerName> node = this.waitingServers;
            this.waitingServers = IterableList.remove(this.waitingServers, node);
            node.setSuspended(false);
            return node;
        }

        public String toString() {
            return String.format("ProcedureEvent(%s)", this.description);
        }
    }
}

