/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.curator;

import java.util.Arrays;
import java.util.List;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZKCuratorManager {
    private TestingServer server;
    private ZKCuratorManager curator;

    @Before
    public void setup() throws Exception {
        this.server = new TestingServer();
        Configuration conf = new Configuration();
        conf.set("hadoop.zk.address", this.server.getConnectString());
        this.curator = new ZKCuratorManager(conf);
        this.curator.start();
    }

    @After
    public void teardown() throws Exception {
        this.curator.close();
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    @Test
    public void testReadWriteData() throws Exception {
        String testZNode = "/test";
        String expectedString = "testString";
        Assert.assertFalse((boolean)this.curator.exists(testZNode));
        this.curator.create(testZNode);
        Assert.assertTrue((boolean)this.curator.exists(testZNode));
        this.curator.setData(testZNode, expectedString, -1);
        String testString = this.curator.getStringData("/test");
        Assert.assertEquals((Object)expectedString, (Object)testString);
    }

    @Test
    public void testChildren() throws Exception {
        List children = this.curator.getChildren("/");
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertFalse((boolean)this.curator.exists("/node1"));
        this.curator.create("/node1");
        Assert.assertTrue((boolean)this.curator.exists("/node1"));
        Assert.assertFalse((boolean)this.curator.exists("/node2"));
        this.curator.create("/node2");
        Assert.assertTrue((boolean)this.curator.exists("/node2"));
        children = this.curator.getChildren("/");
        Assert.assertEquals((long)3L, (long)children.size());
        this.curator.delete("/node2");
        Assert.assertFalse((boolean)this.curator.exists("/node2"));
        children = this.curator.getChildren("/");
        Assert.assertEquals((long)2L, (long)children.size());
    }

    @Test
    public void testGetStringData() throws Exception {
        String node1 = "/node1";
        String node2 = "/node2";
        Assert.assertFalse((boolean)this.curator.exists(node1));
        this.curator.create(node1);
        Assert.assertNull((Object)this.curator.getStringData(node1));
        byte[] setData = "setData".getBytes("UTF-8");
        this.curator.setData(node1, setData, -1);
        Assert.assertEquals((Object)"setData", (Object)this.curator.getStringData(node1));
        Stat stat = new Stat();
        Assert.assertFalse((boolean)this.curator.exists(node2));
        this.curator.create(node2);
        Assert.assertNull((Object)this.curator.getStringData(node2, stat));
        this.curator.setData(node2, setData, -1);
        Assert.assertEquals((Object)"setData", (Object)this.curator.getStringData(node2, stat));
    }

    @Test
    public void testTransaction() throws Exception {
        List zkAcl = ZKUtil.parseACLs((String)"world:anyone:rwcda");
        String fencingNodePath = "/fencing";
        String node1 = "/node1";
        String node2 = "/node2";
        byte[] testData = "testData".getBytes("UTF-8");
        Assert.assertFalse((boolean)this.curator.exists(fencingNodePath));
        Assert.assertFalse((boolean)this.curator.exists(node1));
        Assert.assertFalse((boolean)this.curator.exists(node2));
        ZKCuratorManager.SafeTransaction txn = this.curator.createTransaction(zkAcl, fencingNodePath);
        txn.create(node1, testData, zkAcl, CreateMode.PERSISTENT);
        txn.create(node2, testData, zkAcl, CreateMode.PERSISTENT);
        Assert.assertFalse((boolean)this.curator.exists(fencingNodePath));
        Assert.assertFalse((boolean)this.curator.exists(node1));
        Assert.assertFalse((boolean)this.curator.exists(node2));
        txn.commit();
        Assert.assertFalse((boolean)this.curator.exists(fencingNodePath));
        Assert.assertTrue((boolean)this.curator.exists(node1));
        Assert.assertTrue((boolean)this.curator.exists(node2));
        Assert.assertTrue((boolean)Arrays.equals(testData, this.curator.getData(node1)));
        Assert.assertTrue((boolean)Arrays.equals(testData, this.curator.getData(node2)));
        byte[] setData = "setData".getBytes("UTF-8");
        txn = this.curator.createTransaction(zkAcl, fencingNodePath);
        txn.setData(node1, setData, -1);
        txn.delete(node2);
        Assert.assertTrue((boolean)this.curator.exists(node2));
        Assert.assertTrue((boolean)Arrays.equals(testData, this.curator.getData(node1)));
        txn.commit();
        Assert.assertFalse((boolean)this.curator.exists(node2));
        Assert.assertTrue((boolean)Arrays.equals(setData, this.curator.getData(node1)));
    }
}

