/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.ResultManager;
import org.apache.phoenix.pherf.result.RunTime;
import org.apache.phoenix.pherf.result.ThreadTime;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.WorkloadExecutor;
import org.apache.phoenix.pherf.workload.WriteWorkload;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiThreadedRunner
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiThreadedRunner.class);
    private Query query;
    private ThreadTime threadTime;
    private PhoenixUtil pUtil = PhoenixUtil.create();
    private String threadName;
    private DataModelResult dataModelResult;
    private long numberOfExecutions;
    private long executionDurationInMs;
    private static long lastResultWritten = EnvironmentEdgeManager.currentTimeMillis() - 1000L;
    private final ResultManager resultManager;
    private final RulesApplier ruleApplier;
    private final Scenario scenario;
    private final WorkloadExecutor workloadExecutor;
    private final XMLConfigParser parser;
    private final boolean writeRuntimeResults;

    MultiThreadedRunner(String threadName, Query query, DataModelResult dataModelResult, ThreadTime threadTime, long numberOfExecutions, long executionDurationInMs, boolean writeRuntimeResults, RulesApplier ruleApplier, Scenario scenario, WorkloadExecutor workloadExecutor, XMLConfigParser parser) {
        this.query = query;
        this.threadName = threadName;
        this.threadTime = threadTime;
        this.dataModelResult = dataModelResult;
        this.numberOfExecutions = numberOfExecutions;
        this.executionDurationInMs = executionDurationInMs;
        this.ruleApplier = ruleApplier;
        this.scenario = scenario;
        this.resultManager = new ResultManager(dataModelResult.getName(), writeRuntimeResults);
        this.workloadExecutor = workloadExecutor;
        this.parser = parser;
        this.writeRuntimeResults = writeRuntimeResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        LOGGER.info("\n\nThread Starting " + this.threadName + " ; '" + this.query.getStatement() + "' for " + this.numberOfExecutions + " times\n\n");
        long threadStartTime = EnvironmentEdgeManager.currentTimeMillis();
        for (long i = 0L; i < this.numberOfExecutions; ++i) {
            long threadElapsedTime = EnvironmentEdgeManager.currentTimeMillis() - threadStartTime;
            if (threadElapsedTime >= this.executionDurationInMs) {
                LOGGER.info("Queryset timeout of " + this.executionDurationInMs + " ms reached; current time is " + threadElapsedTime + " ms.\nStopping queryset execution for query " + this.query.getId() + " on thread " + this.threadName + "...");
                break;
            }
            WorkloadExecutor workloadExecutor = this.workloadExecutor;
            synchronized (workloadExecutor) {
                if (!this.timedQuery(i + 1L)) {
                    break;
                }
                if (this.writeRuntimeResults && EnvironmentEdgeManager.currentTimeMillis() - lastResultWritten > 1000L) {
                    this.resultManager.write(this.dataModelResult, this.ruleApplier);
                    lastResultWritten = EnvironmentEdgeManager.currentTimeMillis();
                }
                continue;
            }
        }
        if (!this.writeRuntimeResults) {
            long duration = EnvironmentEdgeManager.currentTimeMillis() - threadStartTime;
            LOGGER.info("The read query " + this.query.getStatement() + " for this thread in (" + duration + ") Ms");
        }
        if (this.writeRuntimeResults) {
            WorkloadExecutor workloadExecutor = this.workloadExecutor;
            synchronized (workloadExecutor) {
                this.resultManager.flush();
            }
        }
        LOGGER.info("\n\nThread exiting." + this.threadName + "\n\n");
        return null;
    }

    private synchronized ThreadTime getThreadTime() {
        return this.threadTime;
    }

    private boolean timedQuery(long iterationNumber) throws Exception {
        boolean isSelectCountStatement = this.query.getStatement().toUpperCase().trim().contains("COUNT(");
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Long queryStartTime = EnvironmentEdgeManager.currentTimeMillis();
        Date startDate = Calendar.getInstance().getTime();
        String exception = null;
        Long resultRowCount = 0L;
        String queryIteration = this.threadName + ":" + iterationNumber;
        Long queryElapsedTime = 0L;
        try {
            boolean isQuery;
            conn = this.pUtil.getConnection(this.query.getTenantId(), this.scenario.getPhoenixProperties());
            conn.setAutoCommit(true);
            String statementString = this.query.getDynamicStatement(this.ruleApplier, this.scenario);
            statement = conn.prepareStatement(statementString);
            LOGGER.debug("Executing iteration: " + queryIteration + ": " + statementString);
            if (this.scenario.getWriteParams() != null) {
                WriteWorkload writes = new WriteWorkload(PhoenixUtil.create(), this.parser, PherfConstants.create().getProperties("pherf.properties", true), this.scenario, PherfConstants.GeneratePhoenixStats.NO);
                this.workloadExecutor.add(writes);
            }
            if (isQuery = statement.execute()) {
                rs = statement.getResultSet();
                Pair<Long, Long> r = this.getResults(rs, queryIteration, isSelectCountStatement, queryStartTime);
                resultRowCount = (Long)r.getFirst();
                queryElapsedTime = (Long)r.getSecond();
            } else {
                conn.commit();
            }
            this.getThreadTime().getRunTimesInMs().add(new RunTime(exception, startDate, resultRowCount, queryElapsedTime, queryElapsedTime > this.query.getTimeoutDuration()));
        }
        catch (Exception e) {
            try {
                LOGGER.error("Exception while executing query iteration " + queryIteration, (Throwable)e);
                exception = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                this.getThreadTime().getRunTimesInMs().add(new RunTime(exception, startDate, resultRowCount, queryElapsedTime, queryElapsedTime > this.query.getTimeoutDuration()));
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (conn != null) {
                    conn.close();
                }
                throw throwable;
            }
        }
        if (rs != null) {
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (conn != null) {
            conn.close();
        }
        return true;
    }

    @VisibleForTesting
    Pair<Long, Long> getResults(ResultSet rs, String queryIteration, boolean isSelectCountStatement, Long queryStartTime) throws Exception {
        Long resultRowCount = 0L;
        while (rs.next()) {
            long queryElapsedTime;
            if (null != this.query.getExpectedAggregateRowCount() && rs.getLong(1) != this.query.getExpectedAggregateRowCount().longValue()) {
                throw new RuntimeException("Aggregate count " + rs.getLong(1) + " does not match expected " + this.query.getExpectedAggregateRowCount());
            }
            if (isSelectCountStatement) {
                resultRowCount = rs.getLong(1);
            } else {
                Long l = resultRowCount;
                Long l2 = resultRowCount = Long.valueOf(resultRowCount + 1L);
            }
            if ((queryElapsedTime = EnvironmentEdgeManager.currentTimeMillis() - queryStartTime) < this.query.getTimeoutDuration()) continue;
            LOGGER.error("Query " + queryIteration + " exceeded timeout of " + this.query.getTimeoutDuration() + " ms at " + queryElapsedTime + " ms.");
            return new Pair((Object)resultRowCount, (Object)queryElapsedTime);
        }
        return new Pair((Object)resultRowCount, (Object)(EnvironmentEdgeManager.currentTimeMillis() - queryStartTime));
    }
}

