<!--
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at
      http://www.apache.org/licenses/LICENSE-2.0
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->

# Apache NiFi - MiNiFi - C++ C2 Readme.


This readme defines the Command and control configuration options that work with Apache NiFi. All
options defined are located in minifi.properties.

## Table of Contents

- [Apache NiFi - MiNiFi - C++ C2 Readme.](#apache-nifi---minifi---c-c2-readme)
  - [Table of Contents](#table-of-contents)
  - [Description](#description)
  - [Configuration](#configuration)
    - [Base Options](#base-options)
      - [Flow Id and URL](#flow-id-and-url)
      - [Agent Identifier Fallback](#agent-identifier-fallback)
    - [Metrics](#metrics)
    - [UpdatePolicies](#updatepolicies)
    - [Triggers](#triggers)
      - [C2 File triggers](#c2-file-triggers)
  - [C2 Response Nodes](#c2-response-nodes)
    - [AgentInformation](#agentinformation)
    - [AgentStatus](#agentstatus)
    - [AssetInformation](#assetinformation)
    - [BuildInformation](#buildinformation)
    - [ConfigurationChecksums](#configurationchecksums)
    - [DeviceInfoNode](#deviceinfonode)
    - [FlowInformation](#flowinformation)
    - [QueueMetrics](#queuemetrics)
    - [RepositoryMetrics](#repositorymetrics)
    - [Processor Metric Response Nodes](#processor-metric-response-nodes)

## Description

Apache NiFi MiNiFi C++ can communicates with a C2 Server via HTTP REST protocol. The protocol
delivers a C2 response the server, expecting requests in a heartbeat response. The protocol transforms
the C2 messages into a protocol specific representation. The internal representation is an AST therefore
you must define the root classes, which configure the classes that branch from the root. You can define
arbitrary nodes and sub-trees, but this isn't necessary and only advantageous for custom C2 servers. That
will be explained in greater detail in the metrics section.

## Configuration

### Base Options
For more more insight into the API used within the C2 agent, please visit:
https://cwiki.apache.org/confluence/display/MINIFI/C2+Design+Proposal

Release 0.6.0: Please note that all c2 properties now exist as `nifi.c2.*`. If your configuration properties
files contain the former naming convention of `c2.*`, we will continue to support that as
an alternate key, but you are encouraged to switch your configuration options as soon as possible.

Note: In release 0.8.0 there is a configuration option to minimize the heartbeat payload size by excluding agent manifest.
For that, add "nifi.c2.full.heartbeat"=false property.
With this change, heartbeat with agent manifest included is sent only for the first time then falls back to sending
light weight heartbeat. If for some reason the C2 server does not receive the first full heartbeat, the manifest can
be requested via C2 DESCRIBE manifest command.


    #in minifi.properties

    # Disable/Enable C2
    nifi.c2.enable=true

    # specify which sections the heartbeat message should contain
    #   DeviceInfoNode: basic info about the system (OS, number of cores etc)
    #   AgentInformation: info about the MiNiFi agent, may include the manifest
    #   FlowInformation: information about the current flow, including queue sizes
    #   AssetInformation: the state of the asset directory managed by the agent
    #   ConfigurationChecksums: hashes of the configuration files; can be used to detect unexpected modifications
    # the default is
    nifi.c2.root.classes=DeviceInfoNode,AgentInformation,FlowInformation,AssetInformation

    # control c2 heartbeat interval
    nifi.c2.agent.heartbeat.period=30 sec

    # enable reporter classes
    nifi.c2.agent.heartbeat.reporter.classes=RESTReceiver
    # If RESTReceiver is configured its listener port and optional SSL certificate can also be configured
    nifi.c2.rest.listener.port=<port>
    nifi.c2.rest.listener.cacert=<SSL Cert path>

    # specify the rest URIs if using RESTSender
    nifi.c2.rest.path.base=https://<your-c2-server>/<c2-api-path>
    # specify either absolute url or relative to the nifi.c2.rest.path.base url for hearbeat and acknowledge
    nifi.c2.rest.url=/c2-protocol/heartbeat
    nifi.c2.rest.url.ack=/c2-protocol/acknowledge
    nifi.c2.flow.base.url=http://<your-c2-server>/<c2-api-path>/c2-protocol/

    # c2 agent identifier -- must be defined to run agent
    nifi.c2.agent.identifier=<your identifier>

    # c2 agent class -- must be defined to run agent
    nifi.c2.agent.class=<your agent class>

    # configure SSL Context service for REST Protocol
    #nifi.c2.rest.ssl.context.service

    # specify encoding strategy for c2 requests (gzip, none)
    #nifi.c2.rest.request.encoding=none

    # minimize REST heartbeat updates
    #nifi.c2.rest.heartbeat.minimize.updates=true

    # specify the maximum number of bulletins to send in a heartbeat
    # nifi.c2.flow.info.processor.bulletin.limit=1000

#### Flow Id and URL

Flow id and URL are usually retrieved from the C2 server. These identify the last updated flow version and where the flow was downloaded from. These properties are persisted in the minifi.properties file.

    # in minifi.properties
    nifi.c2.flow.id=8da5de7f-dcdb-4f6b-aa2f-6f162a7f9dc4
    nifi.c2.flow.url=http://localhost:10090/c2-server/api/flows/8da5de7f-dcdb-4f6b-aa2f-6f162a7f9dc4/content?aid=efmtest

#### Agent Identifier Fallback

It is possible to set a persistent fallback agent id. This is needed so that the C2 server can identify the same agent after a restart, even if nifi.c2.agent.identifier is not specified.

    # in minifi.properties
    nifi.c2.agent.identifier.fallback=my_fallback_id

### Metrics

Command and Control metrics can be used to send metrics through the heartbeat or via the DESCRIBE
operation. Since responses are formed in an AST, metrics can be formed as a sub tree. Metrics classes
are defined apriori and may reference a metrics class specific to a processor. The following example describes
a configuration of an agent

    # in minifi.properties

    nifi.c2.root.class.definitions=metrics
    nifi.c2.root.class.definitions.metrics.name=metrics
    nifi.c2.root.class.definitions.metrics.metrics=runtimemetrics,loadmetrics,processorMetrics
    nifi.c2.root.class.definitions.metrics.metrics.runtimemetrics.name=RuntimeMetrics
    nifi.c2.root.class.definitions.metrics.metrics.runtimemetrics.classes=DeviceInfoNode,FlowInformation
    nifi.c2.root.class.definitions.metrics.metrics.loadmetrics.name=LoadMetrics
    nifi.c2.root.class.definitions.metrics.metrics.loadmetrics.classes=QueueMetrics,RepositoryMetrics
    nifi.c2.root.class.definitions.metrics.metrics.processorMetrics.name=ProcessorMetric
    nifi.c2.root.class.definitions.metrics.metrics.processorMetrics.classes=GetFileMetrics

Processor metrics can also be configured using regular expressions with the `processorMetrics/` prefix, so the following definition is also valid:

    nifi.c2.root.class.definitions.metrics.metrics.processorMetrics.classes=processorMetrics/Get.*Metrics

This example shows a metrics sub tree defined by the option 'nifi.c2.root.class.definitions'.

This is a comma separated list of all sub trees. In the example, above, only one sub tree exists: metrics.

The options below metrics define the sub-trees within metrics: typedmetrics and processorMetrics. Each of these has a name.
The classes sub option will define the metrics classes that are placed within this sub-tree. For the RESTProtocol, the above
configuration produces the following JSON:

    "metrics": {
      "RuntimeMetrics": {
          "deviceInfo": {
              "systemInfo": {
                  "cpuLoadAverage": 2.59521484375,
                  "cpuUtilization": 0.1188118811881188,
                  "machineArch": "x86_64",
                  "memoryUsage": 13103550464,
                  "operatingSystem": "Linux",
                  "physicalMem": 67024097280,
                  "vCores": 12
              },
              "networkInfo": {
                  "hostname": "ggyimesi-5540-ubuntu",
                  "ipAddress": "192.168.50.181"
              },
              "identifier": "13396751919892753964"
          },
          "flowInfo": {
              "versionedFlowSnapshotURI": {
                  "bucketId": "default",
                  "flowId": "8db40550-db5d-11ec-95d7-0433c2c9832b"
              },
              "queues": {
                  "2438e3c8-015a-1000-79ca-83af40ec1997": {
                      "dataSize": 0,
                      "dataSizeMax": 1048576,
                      "name": "GetFile/success/LogAttribute",
                      "size": 0,
                      "sizeMax": 0,
                      "uuid": "2438e3c8-015a-1000-79ca-83af40ec1997"
                  }
              },
              "processorBulletins": [
                {
                    "id": 1,
                    "timestamp": 1749037558068,
                    "level": "ERROR",
                    "category": "Log Message",
                    "message": "Error connecting to localhost:8776 due to Connection refused (2438e3c8-015a-1000-79ca-83af40ec1991)",
                    "groupId": "2438e3c8-015a-1000-79ca-83af40ec1990",
                    "groupName": "MiNiFi Flow",
                    "groupPath": "MiNiFi Flow",
                    "sourceId": "2438e3c8-015a-1000-79ca-83af40ec1991",
                    "sourceName": "GetTCP"
                }
              ],
              "processorStatuses": [
                {
                    "id": "5128e3c8-015a-1000-79ca-83af40ec1990",
                    "groupId": "2438e3c8-015a-1000-79ca-83af40ec1990",
                    "bytesRead": 0,
                    "bytesWritten": 0,
                    "flowFilesIn": 0,
                    "flowFilesOut": 0,
                    "bytesIn": 0,
                    "bytesOut": 0,
                    "invocations": 0,
                    "processingNanos": 0,
                    "activeThreadCount": -1,
                    "terminatedThreadCount": -1,
                    "runStatus": "RUNNING"
                },
                {
                    "id": "4fe2d51d-076a-49b0-88de-5cf5adf52b8f",
                    "groupId": "2438e3c8-015a-1000-79ca-83af40ec1990",
                    "bytesRead": 0,
                    "bytesWritten": 40,
                    "flowFilesIn": 0,
                    "flowFilesOut": 4,
                    "bytesIn": 0,
                    "bytesOut": 40,
                    "invocations": 4,
                    "processingNanos": 2119148,
                    "activeThreadCount": -1,
                    "terminatedThreadCount": -1,
                    "runStatus": "RUNNING"
                }
            ],
            "flowId": "96273342-b9fe-11ef-a0ad-10f60a596f64",
            "runStatus": "RUNNING"
          }
      },
      "LoadMetrics": {
          "QueueMetrics": {
              "GetFile/success/LogAttribute": {
                  "datasize": "0",
                  "datasizemax": "1048576",
                  "queued": "0",
                  "queuedmax": "0"
              }
          },
          "RepositoryMetrics": {
              "ff": {
                  "full": false,
                  "running": false,
                  "size": "0"
              },
              "repo_name": {
                  "full": false,
                  "running": true,
                  "size": "0"
              }
          }
      },
      "ProcessorMetrics": {
          "GetFileMetrics": {
              "2438e3c8-015a-1000-79ca-83af40ec1991": {
                  "AcceptedFiles": 0,
                  "InputBytes": 0,
                  "OnTriggerInvocations": 0
              }
          }
      }
    }

### UpdatePolicies

Updates to MiNiFi C++ properties can be controlled through an UpdatePolicyControllerService named
C2UpdatePolicy. The service supports several configuration options. They are defined in the following example:

    Controller Services:
    - id: 94491a38-015a-1000-0000-000000000001
      name: C2UpdatePolicy
      class: UpdatePolicyControllerService
      Properties:
        # true enables all properties to be updated.
        Allow All Properties: true
        # allowed properties are those which can be updated
        Allowed Properties:
          - value: Property_1
          - value: Property_2
        Disallowed Properties:
          - value: Property_3
          - value: Property_4

### Triggers

C2 Triggers can be activated to perform some C2 activity via a local event. Currently only FileUpdateTrigger exists, which monitors
for C2 File triggers to update the flow configuration. Classes can be defined as a comma separated list of classes to load via the option
nifi.c2.agent.trigger.classes


#### C2 File triggers

C2 updates can be triggered with updates to a flow configuration file. It doesn't have to be the same base configuration file. It
will be copied into place. A new property, nifi.c2.file.watch, can be placed into minifi.properties to monitor. If the update time
changes while the agent is running, it will be copied into place of the file defined by nifi.flow.configuration.file. The agent
will then be restarted with the new flow configuration. If a failure occurs in reading that file or it is an invalid YAML file, the
update process will be halted.

in minifi.properties to activate the file update trigger specify

    # specifying a trigger
    nifi.c2.agent.trigger.classes=FileUpdateTrigger
    nifi.c2.file.watch=<full path of file to monitor>

## C2 Response Nodes

The following is a list of nodes that can be defined in the minifi.properties file for the C2 heartbeat response as part of the C2 root nodes defined in the `nifi.c2.root.classes` property or in the metrics nodes defined in the tree under `nifi.c2.root.class.definitions` as stated above.

### AgentInformation

Contains information about the agent's build, extensions, supported C2 operations and status of its components.

```
"agentInfo": {
    "agentManifest": {
        "buildInfo": {
            "compiler": "/usr/lib/ccache/g++",
            "flags": " -std=c++20;-Wall;-Wextra;-Werror;-Wno-error=restrict;SODIUM_STATIC=1",
            "revision": "cc9aaac37a9a6b7efeb3c4394a97522a600a1758",
            "timestamp": 1734001238,
            "version": "0.99.1"
        },
        "bundles": [
            {
                "componentManifest": {
                    "processors": [
                    ...
                    ]
                },
                "artifact": "minifi-civet-extensions",
                "group": "org.apache.nifi.minifi",
                "version": "0.99.1"
            }
        ],
        "schedulingDefaults": {
            "defaultMaxConcurrentTasks": 1,
            "defaultRunDurationNanos": 0,
            "defaultSchedulingPeriodMillis": 1000,
            "defaultSchedulingStrategy": "TIMER_DRIVEN",
            "penalizationPeriodMillis": 30000,
            "yieldDurationMillis": 1000
        },
        "supportedOperations": [
            {
                "type": "acknowledge"
            }
            ...
        ],
        "agentType": "cpp",
        "identifier": "bH77vXakM0Lkgt8VcDOGZVW3"
    },
    "status": {
        "repositories": {
            "content_repo": {
                "entryCount": 0,
                "full": false,
                "maxSize": 0,
                "running": true,
                "size": 0
            },
            "flow_file_repo": {
                "entryCount": 0,
                "full": false,
                "maxSize": 0,
                "running": true,
                "size": 0
            },
            "org::apache::nifi::minifi::core::repository::VolatileContentRepository": {
                "entryCount": 4,
                "full": false,
                "maxSize": 7864320,
                "running": true,
                "size": 40
            }
        },
        "components": {
            "LogAttribute": {
                "running": true,
                "uuid": "5128e3c8-015a-1000-79ca-83af40ec1990"
            },
            "GenerateFlowFile": {
                "running": true,
                "uuid": "4fe2d51d-076a-49b0-88de-5cf5adf52b8f"
            },
            "FlowController": {
                "running": true,
                "uuid": "2438e3c8-015a-1000-79ca-83af40ec1990"
            }
        },
        "resourceConsumption": {
            "cpuUtilization": 0.05,
            "memoryUsage": 97955840
        },
        "uptime": 1025
    },
    "agentClass": "test",
    "agentManifestHash": "9FFC8326121A816E5B2FD674CE9A34321F89CC690AD0D1FD79DFB5969B3B523D6570520382E82C68CFA347FBD9897FC027E518E98CFA229C18617B062E1C9E77",
    "identifier": "9628acfe-b9fe-11ef-a0c0-10f60a596f64"
}
```

### AgentStatus

Contains information about the agent's status, including the status of its components, repositories, and resource consumption.

```
"AgentStatus": {
    "repositories": {
        "repo_name": {
            "entryCount": 0,
            "full": false,
            "maxSize": 0,
            "running": true,
            "size": 0
        },
        "ff": {
            "entryCount": 0,
            "full": false,
            "maxSize": 0,
            "running": true,
            "size": 0
        },
        "org::apache::nifi::minifi::core::repository::VolatileContentRepository": {
            "entryCount": 4,
            "full": false,
            "maxSize": 7864320,
            "running": true,
            "size": 40
        }
    },
    "components": {
        "LogAttribute": {
            "running": true,
            "uuid": "5128e3c8-015a-1000-79ca-83af40ec1990"
        },
        "GenerateFlowFile": {
            "running": true,
            "uuid": "4fe2d51d-076a-49b0-88de-5cf5adf52b8f"
        },
        "FlowController": {
            "running": true,
            "uuid": "2438e3c8-015a-1000-79ca-83af40ec1990"
        }
    },
    "resourceConsumption": {
        "cpuUtilization": 0.0028846153846153849,
        "memoryUsage": 97955840
    },
    "uptime": 995
}
```

### AssetInformation

Contains the calculated hash of the assets.

```
"resourceInfo": {
    "hash": "null"
}
```

### BuildInformation

Contains information about the agent's build.

```
"BuildInformation": {
    "compiler": {
        "compiler_command": "/usr/lib/ccache/g++",
        "compiler_flags": " -std=c++20;-Wall;-Wextra;-Werror;-Wno-error=restrict;SODIUM_STATIC=1",
        "compiler_version": "11.4.0"
    },
    "build_date": "1734001238",
    "build_rev": "cc9aaac37a9a6b7efeb3c4394a97522a600a1758",
    "build_version": "0.99.1",
    "device_id": "bH77vXakM0Lkgt8VcDOGZVW3"
}
```

### ConfigurationChecksums

Metric node that defines checksums of configuration files in the C2 protocol.

```
"configurationChecksums": {
    "SHA256": {
        "TestC2Metrics.yml": "9af6589bf7729bb88857aafe98cea4f41df049725401b5f0ded0a7b949d9b90c",
        "minifi.properties": "06fb9f4730e3db7d0a0a1ee606a7de3fee5813edf42eab140616e8a2995072df"
    }
},
```

### DeviceInfoNode

Contains information about the device the agent is running on.

```
"deviceInfo": {
    "systemInfo": {
        "cpuLoadAverage": 1.271484375,
        "cpuUtilization": 0.06179499754781756,
        "machineArch": "x86_64",
        "memoryUsage": 12681670656,
        "operatingSystem": "Linux",
        "physicalMem": 67081129984,
        "vCores": 20
    },
    "networkInfo": {
        "hostname": "ggyimesi-5570-ubuntu",
        "ipAddress": "10.255.0.1"
    },
    "identifier": "16475557466943148337"
}
```

### FlowInformation

Contains information about the flow the agent is running, including the versioned flow snapshot URI, queues, components, and processor statuses.

```
"flowInfo": {
    "versionedFlowSnapshotURI": {
        "bucketId": "default",
        "flowId": "96273342-b9fe-11ef-a0ad-10f60a596f64"
    },
    "queues": {
        "8368e3c8-015a-1003-52ca-83af40ec1332": {
            "dataSize": 40,
            "dataSizeMax": 1048576,
            "name": "GenerateFlowFile/success/LogAttribute",
            "size": 4,
            "sizeMax": 0,
            "uuid": "8368e3c8-015a-1003-52ca-83af40ec1332"
        }
    },
    "processorBulletins": [
        {
            "id": 1,
            "timestamp": 1749037558068,
            "level": "ERROR",
            "category": "Log Message",
            "message": "Error connecting to localhost:8776 due to Connection refused (2438e3c8-015a-1000-79ca-83af40ec1991)",
            "groupId": "2438e3c8-015a-1000-79ca-83af40ec1990",
            "groupName": "MiNiFi Flow",
            "groupPath": "MiNiFi Flow",
            "sourceId": "2438e3c8-015a-1000-79ca-83af40ec1991",
            "sourceName": "GetTCP"
        }
    ],
    "processorStatuses": [
        {
            "id": "5128e3c8-015a-1000-79ca-83af40ec1990",
            "groupId": "2438e3c8-015a-1000-79ca-83af40ec1990",
            "bytesRead": 0,
            "bytesWritten": 0,
            "flowFilesIn": 0,
            "flowFilesOut": 0,
            "bytesIn": 0,
            "bytesOut": 0,
            "invocations": 0,
            "processingNanos": 0,
            "activeThreadCount": -1,
            "terminatedThreadCount": -1,
            "runStatus": "RUNNING"
        },
        {
            "id": "4fe2d51d-076a-49b0-88de-5cf5adf52b8f",
            "groupId": "2438e3c8-015a-1000-79ca-83af40ec1990",
            "bytesRead": 0,
            "bytesWritten": 40,
            "flowFilesIn": 0,
            "flowFilesOut": 4,
            "bytesIn": 0,
            "bytesOut": 40,
            "invocations": 4,
            "processingNanos": 2119148,
            "activeThreadCount": -1,
            "terminatedThreadCount": -1,
            "runStatus": "RUNNING"
        }
    ],
    "flowId": "96273342-b9fe-11ef-a0ad-10f60a596f64",
    "runStatus": "RUNNING"
}
```

### QueueMetrics

Contains information about the queues in the flow, including the contained data and number of flow files.

```
"QueueMetrics": {
    "GenerateFlowFile/success/LogAttribute": {
        "datasize": "40",
        "datasizemax": "1048576",
        "queued": "4",
        "queuedmax": "0"
    }
}
```

### RepositoryMetrics

Contains information about the repositories in the agent, including the number of entries, size, and whether the repository is full.


```
"RepositoryMetrics": {
    "repo_name": {
        "entryCount": 0,
        "full": false,
        "maxSize": 0,
        "running": true,
        "size": 0
    },
    "ff": {
        "entryCount": 0,
        "full": false,
        "maxSize": 0,
        "running": true,
        "size": 0
    },
    "org::apache::nifi::minifi::core::repository::VolatileContentRepository": {
        "entryCount": 4,
        "full": false,
        "maxSize": 7864320,
        "running": true,
        "size": 40
    }
}
```

### Processor Metric Response Nodes

Each processor can have its own metrics. These metric nodes can be configured in the minifi.properties by requesting metrics in the \<ProcessorType\>Metrics format, for example GetTCPMetrics to request metrics for the GetTCP processors. Besides configuring processor metrics directly, they can also be configured using regular expressions with the `processorMetrics/` prefix. For example `processorMetrics/Get.*Metrics` will match all processor metrics that start with Get.

```
"GetTCPMetrics": {
    "2438e3c8-015a-1000-79ca-83af40ec1991": {
        "AverageOnTriggerRunTime": 0,
        "AverageSessionCommitRunTime": 0,
        "BytesRead": 0,
        "BytesWritten": 0,
        "IncomingBytes": 0,
        "IncomingFlowFiles": 0,
        "LastOnTriggerRunTime": 0,
        "LastSessionCommitRunTime": 0,
        "OnTriggerInvocations": 11,
        "ProcessingNanos": 729328,
        "TransferredBytes": 0,
        "TransferredFlowFiles": 0
    }
}
```
