/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.CompositeUserAndGroups;
import org.apache.nifi.registry.security.authorization.CompositeUserGroupProvider;
import org.apache.nifi.registry.security.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserAndGroups;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.apache.nifi.registry.security.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.UserGroupProviderLookup;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.util.PropertyValue;

public class CompositeConfigurableUserGroupProvider
extends CompositeUserGroupProvider
implements ConfigurableUserGroupProvider {
    static final String PROP_CONFIGURABLE_USER_GROUP_PROVIDER = "Configurable User Group Provider";
    private UserGroupProviderLookup userGroupProviderLookup;
    private ConfigurableUserGroupProvider configurableUserGroupProvider;

    public CompositeConfigurableUserGroupProvider() {
        super(true);
    }

    @Override
    public void initialize(UserGroupProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
        this.userGroupProviderLookup = initializationContext.getUserGroupProviderLookup();
        super.initialize(initializationContext);
    }

    @Override
    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        PropertyValue configurableUserGroupProviderKey = configurationContext.getProperty(PROP_CONFIGURABLE_USER_GROUP_PROVIDER);
        if (!configurableUserGroupProviderKey.isSet()) {
            throw new SecurityProviderCreationException("The Configurable User Group Provider must be set.");
        }
        UserGroupProvider userGroupProvider = this.userGroupProviderLookup.getUserGroupProvider(configurableUserGroupProviderKey.getValue());
        if (userGroupProvider == null) {
            throw new SecurityProviderCreationException(String.format("Unable to locate the Configurable User Group Provider: %s", configurableUserGroupProviderKey));
        }
        if (!(userGroupProvider instanceof ConfigurableUserGroupProvider)) {
            throw new SecurityProviderCreationException(String.format("The Configurable User Group Provider is not configurable: %s", configurableUserGroupProviderKey));
        }
        for (Map.Entry entry : configurationContext.getProperties().entrySet()) {
            String userGroupProviderKey;
            Matcher matcher = USER_GROUP_PROVIDER_PATTERN.matcher((CharSequence)entry.getKey());
            if (!matcher.matches() || StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())) || !(userGroupProviderKey = (String)entry.getValue()).equals(configurableUserGroupProviderKey.getValue())) continue;
            throw new SecurityProviderCreationException(String.format("Duplicate provider in Composite Configurable User Group Provider configuration: %s", userGroupProviderKey));
        }
        this.configurableUserGroupProvider = (ConfigurableUserGroupProvider)userGroupProvider;
        super.onConfigured(configurationContext);
    }

    public String getFingerprint() throws AuthorizationAccessException {
        return this.configurableUserGroupProvider.getFingerprint();
    }

    public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        this.configurableUserGroupProvider.inheritFingerprint(fingerprint);
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
        this.configurableUserGroupProvider.checkInheritability(proposedFingerprint);
    }

    public User addUser(User user) throws AuthorizationAccessException {
        return this.configurableUserGroupProvider.addUser(user);
    }

    public boolean isConfigurable(User user) {
        return this.configurableUserGroupProvider.isConfigurable(user);
    }

    public User updateUser(User user) throws AuthorizationAccessException {
        return this.configurableUserGroupProvider.updateUser(user);
    }

    public User deleteUser(User user) throws AuthorizationAccessException {
        return this.configurableUserGroupProvider.deleteUser(user);
    }

    public Group addGroup(Group group) throws AuthorizationAccessException {
        return this.configurableUserGroupProvider.addGroup(group);
    }

    public boolean isConfigurable(Group group) {
        return this.configurableUserGroupProvider.isConfigurable(group);
    }

    public Group updateGroup(Group group) throws AuthorizationAccessException {
        return this.configurableUserGroupProvider.updateGroup(group);
    }

    public Group deleteGroup(Group group) throws AuthorizationAccessException {
        return this.configurableUserGroupProvider.deleteGroup(group);
    }

    @Override
    public Set<User> getUsers() throws AuthorizationAccessException {
        HashSet<User> users = new HashSet<User>(this.configurableUserGroupProvider.getUsers());
        users.addAll(super.getUsers());
        return users;
    }

    @Override
    public User getUser(String identifier) throws AuthorizationAccessException {
        User user = this.configurableUserGroupProvider.getUser(identifier);
        if (user == null) {
            user = super.getUser(identifier);
        }
        return user;
    }

    @Override
    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        User user = this.configurableUserGroupProvider.getUserByIdentity(identity);
        if (user == null) {
            user = super.getUserByIdentity(identity);
        }
        return user;
    }

    @Override
    public Set<Group> getGroups() throws AuthorizationAccessException {
        HashSet<Group> groups = new HashSet<Group>(this.configurableUserGroupProvider.getGroups());
        groups.addAll(super.getGroups());
        return groups;
    }

    @Override
    public Group getGroup(String identifier) throws AuthorizationAccessException {
        Group group = this.configurableUserGroupProvider.getGroup(identifier);
        if (group == null) {
            group = super.getGroup(identifier);
        }
        return group;
    }

    @Override
    public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
        CompositeUserAndGroups combinedResult;
        UserAndGroups configurableProviderResult = this.configurableUserGroupProvider.getUserAndGroups(identity);
        UserAndGroups compositeProvidersResult = super.getUserAndGroups(identity);
        if (configurableProviderResult.getUser() != null && compositeProvidersResult.getUser() != null) {
            throw new IllegalStateException("Multiple UserGroupProviders claim to provide user " + identity);
        }
        if (configurableProviderResult.getUser() != null) {
            combinedResult = new CompositeUserAndGroups(configurableProviderResult.getUser(), configurableProviderResult.getGroups());
            combinedResult.addAllGroups(compositeProvidersResult.getGroups());
        } else if (compositeProvidersResult.getUser() != null) {
            combinedResult = new CompositeUserAndGroups(compositeProvidersResult.getUser(), compositeProvidersResult.getGroups());
            combinedResult.addAllGroups(configurableProviderResult.getGroups());
        } else {
            return UserAndGroups.EMPTY;
        }
        String userIdentifier = combinedResult.getUser().getIdentifier();
        for (Group group : this.configurableUserGroupProvider.getGroups()) {
            if (group.getUsers() == null || !group.getUsers().contains(userIdentifier)) continue;
            combinedResult.addGroup(group);
        }
        for (Group group : super.getGroups()) {
            if (group.getUsers() == null || !group.getUsers().contains(userIdentifier)) continue;
            combinedResult.addGroup(group);
        }
        return combinedResult;
    }

    @Override
    public void preDestruction() throws SecurityProviderDestructionException {
        super.preDestruction();
    }
}

