/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.entity.ProcessorEntity;

public class ProcessorResult
extends AbstractWritableResult<ProcessorEntity> {
    private final ProcessorEntity processorEntity;

    public ProcessorResult(ResultType resultType, ProcessorEntity processorEntity) {
        super(resultType);
        this.processorEntity = Objects.requireNonNull(processorEntity);
    }

    @Override
    public ProcessorEntity getResult() {
        return this.processorEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        ProcessorDTO processorDTO = this.processorEntity.getComponent();
        BundleDTO bundle = processorDTO.getBundle();
        output.printf("Name  : %s\nID    : %s\nType  : %s\nBundle: %s - %s %s\nState : %s\n", processorDTO.getName(), processorDTO.getId(), processorDTO.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion(), processorDTO.getState());
    }
}

