/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap;

import org.apache.nifi.minifi.bootstrap.BootstrapCommand;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiStdLogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHook
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.apache.nifi.minifi.bootstrap.Command");
    private final RunMiNiFi runner;
    private final MiNiFiStdLogHandler miNiFiStdLogHandler;

    public ShutdownHook(RunMiNiFi runner, MiNiFiStdLogHandler miNiFiStdLogHandler) {
        this.runner = runner;
        this.miNiFiStdLogHandler = miNiFiStdLogHandler;
    }

    @Override
    public void run() {
        LOGGER.info("Initiating Shutdown of MiNiFi...");
        this.miNiFiStdLogHandler.shutdown();
        this.runner.shutdownChangeNotifier();
        this.runner.getPeriodicStatusReporterManager().shutdownPeriodicStatusReporters();
        this.runner.setAutoRestartNiFi(false);
        this.runner.run(BootstrapCommand.STOP, new String[0]);
    }
}

