/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.requestParameterProvider.jsf;

import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;

import org.apache.myfaces.orchestra.lib.jsf.ExternalContextUtils;


public class RequestParameterExternalContextWrapperFactory extends ExternalContextFactory
{
    private ExternalContextFactory _delegate;

    public RequestParameterExternalContextWrapperFactory(ExternalContextFactory delegate)
    {
        _delegate = delegate;
    }
    
    @Override
    public ExternalContext getExternalContext(Object context, Object request,
            Object response) throws FacesException
    {
        if (!ExternalContextUtils.getRequestType(context, request).isPortlet())
        {
            return new RequestParameterExternalContextWrapper(
                _delegate.getExternalContext(context, request, response));
        }
        else
        {
            return _delegate.getExternalContext(context, request, response);
        }
    }
}
