/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.state.resourcebinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.state.resourcebinding.ResourceState;
import org.apache.vysper.xmpp.uuid.JVMBuiltinUUIDGenerator;
import org.apache.vysper.xmpp.uuid.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRegistry {
    final Logger logger = LoggerFactory.getLogger(ResourceRegistry.class);
    private UUIDGenerator resourceIdGenerator = new JVMBuiltinUUIDGenerator();
    protected final Map<String, SessionData> boundResources = new HashMap<String, SessionData>();
    protected final Map<Entity, List<String>> entityResources = new HashMap<Entity, List<String>>();
    protected final Map<SessionContext, List<String>> sessionResources = new HashMap<SessionContext, List<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bindSession(SessionContext sessionContext) {
        if (sessionContext == null) {
            throw new IllegalArgumentException("session context cannot be NULL");
        }
        if (sessionContext.getInitiatingEntity() == null) {
            throw new IllegalStateException("session context must have a initiating entity set");
        }
        String resourceId = this.resourceIdGenerator.create();
        Map<String, SessionData> map = this.boundResources;
        synchronized (map) {
            Map<Entity, List<String>> map2 = this.entityResources;
            synchronized (map2) {
                Map<SessionContext, List<String>> map3 = this.sessionResources;
                synchronized (map3) {
                    this.boundResources.put(resourceId, new SessionData(sessionContext, ResourceState.CONNECTED, 0));
                    Entity initiatingEntity = sessionContext.getInitiatingEntity();
                    List<String> resourceForEntityList = this.getResourceList(initiatingEntity);
                    if (resourceForEntityList == null) {
                        resourceForEntityList = new ArrayList<String>(1);
                        this.entityResources.put(this.getBareEntity(initiatingEntity), resourceForEntityList);
                    }
                    resourceForEntityList.add(resourceId);
                    this.logger.info("added resource no. " + resourceForEntityList.size() + " to entity {} <- {}", (Object)initiatingEntity.getFullQualifiedName(), (Object)resourceId);
                    List<String> resourcesForSessionList = this.sessionResources.get(sessionContext);
                    if (resourcesForSessionList == null) {
                        resourcesForSessionList = new ArrayList<String>(1);
                        this.sessionResources.put(sessionContext, resourcesForSessionList);
                    }
                    resourcesForSessionList.add(resourceId);
                    this.logger.info("added resource no. " + resourcesForSessionList.size() + " to session {} <- {}", (Object)sessionContext.getSessionId(), (Object)resourceId);
                }
            }
        }
        return resourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbindResource(String resourceId) {
        boolean noResourceRemainsForSession = false;
        Map<String, SessionData> map = this.boundResources;
        synchronized (map) {
            Map<Entity, List<String>> map2 = this.entityResources;
            synchronized (map2) {
                Map<SessionContext, List<String>> map3 = this.sessionResources;
                synchronized (map3) {
                    SessionContext sessionContext = this.getSessionContext(resourceId);
                    List<String> resourceListForEntity = this.getResourceList(sessionContext.getInitiatingEntity());
                    resourceListForEntity.remove(resourceId);
                    if (resourceListForEntity.isEmpty()) {
                        this.entityResources.remove(sessionContext.getInitiatingEntity());
                    }
                    List<String> resourceListForSession = this.sessionResources.get(sessionContext);
                    resourceListForSession.remove(resourceId);
                    noResourceRemainsForSession = resourceListForSession.isEmpty();
                    if (noResourceRemainsForSession) {
                        this.sessionResources.remove(sessionContext);
                    }
                    this.boundResources.remove(resourceId);
                }
            }
        }
        return noResourceRemainsForSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindSession(SessionContext unbindingSessionContext) {
        if (unbindingSessionContext == null) {
            return;
        }
        Map<String, SessionData> map = this.boundResources;
        synchronized (map) {
            Map<Entity, List<String>> map2 = this.entityResources;
            synchronized (map2) {
                Map<SessionContext, List<String>> map3 = this.sessionResources;
                synchronized (map3) {
                    List<String> removeResourceIds = this.getResourcesForSessionInternal(unbindingSessionContext);
                    for (String removeResourceId : removeResourceIds) {
                        this.boundResources.remove(removeResourceId);
                    }
                    List<String> resourceList = this.getResourceList(unbindingSessionContext.getInitiatingEntity());
                    if (resourceList != null) {
                        resourceList.removeAll(removeResourceIds);
                    }
                    this.sessionResources.remove(unbindingSessionContext);
                }
            }
        }
    }

    public String getUniqueResourceForSession(SessionContext sessionContext) {
        List<String> list = this.getResourcesForSessionInternal(sessionContext);
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public List<String> getResourcesForSession(SessionContext sessionContext) {
        return Collections.unmodifiableList(this.getResourcesForSessionInternal(sessionContext));
    }

    List<String> getResourcesForSessionInternal(SessionContext sessionContext) {
        if (sessionContext == null) {
            return null;
        }
        List<String> resourceList = this.sessionResources.get(sessionContext);
        if (resourceList == null) {
            resourceList = Collections.emptyList();
        }
        return resourceList;
    }

    public SessionContext getSessionContext(String resourceId) {
        SessionData data = this.boundResources.get(resourceId);
        if (data == null) {
            return null;
        }
        return data.context;
    }

    private Entity getBareEntity(Entity entity) {
        return entity == null ? null : entity.getBareJID();
    }

    private List<String> getResourceList(Entity entity) {
        return this.entityResources.get(this.getBareEntity(entity));
    }

    protected List<String> getBoundResources(Entity entity) {
        return this.getBoundResources(entity, true);
    }

    public List<String> getBoundResources(Entity entity, boolean considerBareID) {
        List<String> resourceList = this.getResourceList(entity);
        if (resourceList == null) {
            return Collections.emptyList();
        }
        if (considerBareID || entity.getResource() == null) {
            return Collections.unmodifiableList(resourceList);
        }
        if (!resourceList.contains(entity.getResource())) {
            return Collections.emptyList();
        }
        return Collections.singletonList(entity.getResource());
    }

    public List<SessionContext> getSessions(Entity entity) {
        ArrayList<SessionContext> sessionContexts = new ArrayList<SessionContext>();
        List<String> boundResources = this.getBoundResources(entity, false);
        for (String resourceId : boundResources) {
            sessionContexts.add(this.getSessionContext(resourceId));
        }
        return sessionContexts;
    }

    public List<SessionContext> getSessions(Entity entity, Integer prioThreshold) {
        if (prioThreshold == null) {
            prioThreshold = 0;
        }
        ArrayList<SessionContext> results = new ArrayList<SessionContext>();
        List<String> boundResourceIds = this.getBoundResources(entity, true);
        for (String resourceId : boundResourceIds) {
            SessionData sessionData = this.boundResources.get(resourceId);
            if (sessionData == null || sessionData.priority < prioThreshold) continue;
            results.add(sessionData.context);
        }
        return results;
    }

    public long getSessionCount() {
        return this.entityResources.size();
    }

    public List<SessionContext> getHighestPrioSessions(Entity entity, Integer prioThreshold) {
        Integer currentPrio = prioThreshold == null ? Integer.MIN_VALUE : prioThreshold;
        ArrayList<SessionContext> results = new ArrayList<SessionContext>();
        boolean isResourceSet = entity.isResourceSet();
        List<String> boundResourceIds = this.getBoundResources(entity, false);
        for (String resourceId : boundResourceIds) {
            SessionData sessionData = this.boundResources.get(resourceId);
            if (sessionData == null) continue;
            if (isResourceSet) {
                results.clear();
                results.add(sessionData.context);
                return results;
            }
            if (sessionData.priority > currentPrio) {
                results.clear();
                currentPrio = sessionData.priority;
                results.add(sessionData.context);
                continue;
            }
            if (sessionData.priority.intValue() != currentPrio.intValue()) continue;
            results.add(sessionData.context);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setResourceState(String resourceId, ResourceState state) {
        SessionData data = this.boundResources.get(resourceId);
        if (data == null) {
            throw new IllegalArgumentException("resource not registered: " + resourceId);
        }
        SessionData sessionData = data;
        synchronized (sessionData) {
            boolean result = data.state != state;
            data.state = state;
            return result;
        }
    }

    public ResourceState getResourceState(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        SessionData data = this.boundResources.get(resourceId);
        if (data == null) {
            return null;
        }
        return data.state;
    }

    public void setResourcePriority(String resourceId, int priority) {
        if (resourceId == null) {
            return;
        }
        SessionData data = this.boundResources.get(resourceId);
        if (data == null) {
            return;
        }
        data.priority = priority;
    }

    public List<String> getInterestedResources(Entity entity) {
        List<String> resources = this.getResourceList(entity);
        ArrayList<String> result = new ArrayList<String>();
        for (String resource : resources) {
            ResourceState resourceState = this.getResourceState(resource);
            if (!ResourceState.isInterested(resourceState)) continue;
            result.add(resource);
        }
        return result;
    }

    public List<String> getAvailableResources(Entity entity) {
        List<String> resources = this.getResourceList(entity);
        ArrayList<String> result = new ArrayList<String>();
        for (String resource : resources) {
            ResourceState resourceState = this.getResourceState(resource);
            if (resourceState != ResourceState.AVAILABLE && resourceState != ResourceState.AVAILABLE_INTERESTED) continue;
            result.add(resource);
        }
        return result;
    }

    private static class SessionData {
        private final SessionContext context;
        private ResourceState state;
        private Integer priority;

        SessionData(SessionContext context, ResourceState status, Integer priority) {
            this.context = context;
            this.state = status;
            this.priority = priority == null ? 0 : priority;
        }
    }
}

