/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.stanza;

import java.util.Map;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceStanza
extends XMPPCoreStanza {
    public static final String NAME = "presence";

    public static boolean isOfType(Stanza stanza) {
        return PresenceStanza.isOfType(stanza, NAME);
    }

    public PresenceStanza(Stanza stanza) {
        super(stanza);
        if (!PresenceStanza.isOfType(stanza)) {
            throw new IllegalArgumentException("only 'presence' stanza is allowed here");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public PresenceStanzaType getPresenceType() {
        String type = this.getType();
        if (type == null) {
            return null;
        }
        return PresenceStanzaType.valueOfOrNull(type);
    }

    public String getShow() throws XMLSemanticError {
        XMLElement element = this.getSingleInnerElementsNamed("show");
        if (element == null) {
            return null;
        }
        return element.getSingleInnerText().getText();
    }

    public String getStatus(String lang) throws XMLSemanticError {
        XMLElement element = this.getStatusMap().get(lang);
        if (element == null) {
            return null;
        }
        return element.getSingleInnerText().getText();
    }

    public Map<String, XMLElement> getStatusMap() throws XMLSemanticError {
        return this.getInnerElementsByXMLLangNamed("status");
    }

    public int getPriority() throws XMLSemanticError {
        int priorityValue = 0;
        XMLElement element = this.getSingleInnerElementsNamed("priority");
        if (element != null) {
            int intValue;
            String priorityString = element.getSingleInnerText().getText();
            try {
                intValue = Integer.parseInt(priorityString);
            }
            catch (NumberFormatException e) {
                throw new XMLSemanticError("presence priority must be an integer value in the -128 to 127 range", (Throwable)e);
            }
            if (intValue < -128 || intValue > 127) {
                throw new XMLSemanticError("presence priority must be an integer value in the -128 to 127 range");
            }
            priorityValue = intValue;
        }
        return priorityValue;
    }

    public int getPrioritySafe() {
        try {
            return this.getPriority();
        }
        catch (XMLSemanticError xmlSemanticError) {
            return 0;
        }
    }
}

