/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server.s2s;

import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsProceedHandler
implements StanzaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TlsProceedHandler.class);

    public String getName() {
        return "proceed";
    }

    public boolean verify(Stanza stanza) {
        if (stanza == null) {
            return false;
        }
        if (!this.getName().equals(stanza.getName())) {
            return false;
        }
        String namespaceURI = stanza.getNamespaceURI();
        if (namespaceURI == null) {
            return false;
        }
        return namespaceURI.equals("urn:ietf:params:xml:ns:xmpp-tls");
    }

    public boolean isSessionRequired() {
        return true;
    }

    public ResponseStanzaContainer execute(Stanza stanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext, SessionStateHolder sessionStateHolder) {
        sessionStateHolder.setState(SessionState.ENCRYPTION_STARTED);
        LOG.debug("XMPP server connector switching to TLS");
        sessionContext.switchToTLS(false, true);
        return null;
    }
}

