/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.addressing;

import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.stringprep.NodePrep;
import org.apache.vysper.xmpp.addressing.stringprep.ResourcePrep;
import org.apache.vysper.xmpp.addressing.stringprep.StringPrepViolationException;

public class EntityImpl
implements Entity {
    public static final String CHAR_AT = "@";
    public static final String CHAR_SLASH = "/";
    private String node;
    private String domain;
    private String resource;
    protected String fullyQualifiedCached = null;
    protected Entity bareEntityCached = null;

    public static EntityImpl parse(String entity) throws EntityFormatException {
        String node = null;
        String resource = null;
        if (entity == null) {
            throw new EntityFormatException("entity must not be NULL");
        }
        if (entity.contains(CHAR_AT)) {
            String[] parts = entity.split(CHAR_AT);
            if (parts.length != 2) {
                throw new EntityFormatException("entity must be of format node@domain/resource");
            }
            node = parts[0];
            node = NodePrep.prepare(node);
            entity = parts[1];
        }
        String domain = entity;
        if (entity.contains(CHAR_SLASH)) {
            int indexOfSlash = entity.indexOf(CHAR_SLASH);
            domain = entity.substring(0, indexOfSlash);
            resource = entity.substring(indexOfSlash + 1);
            resource = ResourcePrep.prepare(resource);
        }
        return new EntityImpl(node, domain, resource, true);
    }

    public static EntityImpl parseUnchecked(String entity) {
        try {
            return EntityImpl.parse(entity);
        }
        catch (EntityFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private EntityImpl(String node, String domain, String resource, boolean prepped) {
        try {
            this.node = !prepped && node != null ? NodePrep.prepare(node) : node;
            this.domain = domain;
            this.resource = !prepped && resource != null ? ResourcePrep.prepare(resource) : resource;
        }
        catch (StringPrepViolationException e) {
            throw new RuntimeException(e);
        }
    }

    public EntityImpl(String node, String domain, String resource) {
        this(node, domain, resource, false);
    }

    public EntityImpl(Entity bareId, String resource) {
        this(bareId.getNode(), bareId.getDomain(), resource);
    }

    public String getNode() {
        return this.node;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getResource() {
        return this.resource;
    }

    public String getFullQualifiedName() {
        if (this.fullyQualifiedCached == null) {
            this.fullyQualifiedCached = this.buildEntityString(this.node, this.domain, this.resource);
        }
        return this.fullyQualifiedCached;
    }

    private String buildEntityString(String node, String domain, String resource) {
        StringBuilder buffer = new StringBuilder();
        if (this.isNodeSet()) {
            buffer.append(node).append(CHAR_AT);
        }
        buffer.append(domain);
        if (this.isResourceSet()) {
            buffer.append(CHAR_SLASH).append(resource);
        }
        return buffer.toString();
    }

    public Entity getBareJID() {
        if (!this.isResourceSet()) {
            return this;
        }
        if (this.bareEntityCached == null) {
            this.bareEntityCached = new EntityImpl(this.node, this.domain, null);
        }
        return this.bareEntityCached;
    }

    public String getCanonicalizedName() {
        return null;
    }

    public boolean isNodeSet() {
        return this.node != null && !"".equals(this.node);
    }

    public boolean isResourceSet() {
        return this.resource != null && !"".equals(this.resource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Entity)) {
            return false;
        }
        Entity that = (Entity)o;
        if (this.domain != null ? !this.domain.equals(that.getDomain()) : that.getDomain() != null) {
            return false;
        }
        if (this.isNodeSet() != that.isNodeSet()) {
            return false;
        }
        if (this.isNodeSet() && (this.node != null ? !this.node.equals(that.getNode()) : that.getNode() != null)) {
            return false;
        }
        if (this.isResourceSet() != that.isResourceSet()) {
            return false;
        }
        return !this.isResourceSet() || !(this.resource != null ? !this.resource.equals(that.getResource()) : that.getResource() != null);
    }

    public int hashCode() {
        int result = this.node != null ? this.node.hashCode() : 0;
        result = 29 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 29 * result + (this.resource != null ? this.resource.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getFullQualifiedName();
    }
}

