/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.model;

import java.util.EnumSet;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Affiliation;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.RoomType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Role {
    Moderator,
    None,
    Participant,
    Visitor;


    public String toString() {
        return this.name().toLowerCase();
    }

    public static Role getRole(Affiliation affiliation, EnumSet<RoomType> roomTypes) {
        switch (affiliation) {
            case Owner: 
            case Admin: {
                return Moderator;
            }
            case Member: {
                return Participant;
            }
            case None: {
                if (roomTypes.contains((Object)RoomType.MembersOnly)) {
                    return None;
                }
                if (roomTypes.contains((Object)RoomType.Moderated)) {
                    return Visitor;
                }
                return Participant;
            }
        }
        return null;
    }

    public static Role fromString(String value) {
        if (Moderator.toString().equals(value)) {
            return Moderator;
        }
        if (None.toString().equals(value)) {
            return None;
        }
        if (Participant.toString().equals(value)) {
            return Participant;
        }
        if (Visitor.toString().equals(value)) {
            return Visitor;
        }
        throw new IllegalArgumentException("Unknown role: " + value);
    }
}

